 
/* scanf.c utility function Formatted input for HyperC */
 
#include <std.h>
#define BUFSIZ  100
#define TRUE    1
#define FALSE   0
 
INT     scanf(fmt,args)
TEXT    *fmt;
INT     *args;
 
{
TEXT    buf[BUFSIZ], temp[BUFSIZ];
TEXT    *str, *ptr;
INT     maxchars, nargs, i, **arv;
BOOL    ignore, space;
CHAR    fctl;
 
LOCAL INT convert()
{
INT     val;
CHAR    fctl;
 
val=0;
while (isdigit(*fmt))
    val = 10*val + *fmt++ -'0';
if (!val)
            switch (fctl =*fmt) {
                case 'd':
                case 'D':
                val = 6;
                break;
 
                case 'i':
                case 'I':
                val = 8;
                break;
 
                case 'u':
                case 'U':
                val = 5;
                break;
 
                case 'o':
                case 'O':
                val = 6;
                break;
 
                case 'x':
                case 'X':
                val = 4;
                break;
 
                case 'h':
                case 'H':
                val = 3;
                break;
 
                case 'c':
                case 'C':
                val = 1;
                break;
 
                default:
                val = BUFSIZ - 2;
                break;
            }
    return ((val > BUFSIZ-2) ? BUFSIZ-2 : val);
}
 
LOCAL VOID strcopy (dest, src)
CHAR    *src, *dest;
{
    while (*dest++ = *src++)
        ;
}
 
arv=&args;
nargs=0;
ignore = FALSE;
space = FALSE;
conRead (buf, BUFSIZ);
str = buf;
while (*fmt) {
    if (*fmt == ' ')
        space = TRUE;
    if (*fmt++ == '%')  {
       if  (*fmt == '*') { /* suppression character, useless but k&r use it*/
            ignore = TRUE;
            ++fmt;
            }
        maxchars = convert();
        ptr = temp;
        for (i =0; i < maxchars; i++) {
            if (isspace(*str) && space) {
                str++;
                break;
            }
            *ptr++ = *str++;
        }
        *ptr = '\0';
        ptr = temp;
        if (!ignore)
            switch (fctl = *fmt++) {
                case 'd':
                case 'D':
                case 'i':
                case 'I':
                **arv = atoi (&ptr);
                break;
 
                case 'u':
                case 'U':
                if (*ptr =='-')
                    *ptr=' ';
                **arv = atoi (&ptr);
                break;
 
                case 'o':
                case 'O':
                movel (ptr,ptr+1,8);
                ptr[0] = '0';
                **arv = atoi (&ptr);
                break;
 
                case 'x':
                case 'X':
                movel (ptr,&ptr[2],6);
                *ptr = '0';  /* add '0x' prefix to string to make atoi work*/
                ptr[1] = 'x';
                **arv = atoi (&ptr);
                break;
 
                case 'h':
                case 'H':
                **arv = atoi (&ptr);
                break;
 
                case 'c':
                case 'C':
                **arv = *ptr;
                break;
 
                case 'n':
                case 'N':
                arv++;
                break;
 
                case 's':
                case 'S':
                strcopy (*arv, ptr);
                break;
 
                default:
                **arv = '\0';
                break;
            }  /*end switch */
        arv++;
        ++nargs;
        fmt--;          /* clean up control string pointer */
        }   /* end if '%' */
    } /* end while */
return (nargs);
}   /*end scanf */
 
