	Page	58,132
	Title	STACK.ASM	Apple Private Stack Routines
;******************************************************************************
;
;   Name:	STACK.ASM	Apple Private Stack Routines
;
;   Group:	Emulator
;
;   Revision:	1.00
;
;   Date:	January 30, 1988
;
;   Author:	Randy W. Spurlock
;
;******************************************************************************
;
;  Module Functional Description:
;
;		This module contains all the code for the Apple
;	private stack routines.
;
;******************************************************************************
;
;  Changes:
;
;    DATE     REVISION				DESCRIPTION
;  --------   --------	-------------------------------------------------------
;   1/30/88	1.00	Original
;
;******************************************************************************
	Page
;
;  Public Declarations
;
	Public	Stack_Init		; Initialize stack routine
	Public	Push_Byte		; Push byte onto stack routine
	Public	Push_Word		; Push word onto stack routine
	Public	Push_Dword		; Push dword onto stack routine
	Public	Pop_Byte		; Pop byte from stack routine
	Public	Pop_Word		; Pop word from stack routine
	Public	Pop_Dword		; Pop dword from stack routine
	Public	Top_Byte		; Get top byte from stack routine
	Public	Top_Word		; Get top word from stack routine
	Public	Top_Dword		; Get top dword from stack routine
;
;  LOCAL Equates
;
BYTE_SIZE	Equ	0001h		; Byte size value
WORD_SIZE	Equ	0002h		; Word size value
DWORD_SIZE	Equ	0004h		; Dword size value
;
;  Define any include files needed
;
	Include 	Macros.inc	; Include the macro definitions
	Include 	Equates.inc	; Include the equate definitions
	Include 	Strucs.inc	; Include the structure definitions
	.286c				; Include 80286 instructions
	Page
;
;  Define the emulator code segment
;
Emulate Segment Word Public 'EMULATE'   ; Emulator code segment
	Assume	cs:Emulate, ds:Nothing, es:Nothing
	Subttl	Stack_Init	Initialize Private Stack Routine
	Page	+
;******************************************************************************
;
;	Stack_Init(Stack)
;
;		Save the required registers
;		Zero the private stack pointer (Start of stack)
;		Restore the required registers
;		Return to the caller
;
;	Registers on Entry:
;
;		DS:DI - Pointer to private stack structure
;
;	Registers on Exit:
;
;		None
;
;******************************************************************************
		Even			; Force procedure to even address
Stack_Init	Proc	Near		; Initialize private stack procedure
	Save	ax			; Save the required registers
	xor	ax,ax			; Initialize the private stack pointer
	mov	ds:[di.Private_Pointer],ax
	Restore ax			; Restore the required registers
	ret				; Return to the caller
Stack_Init	Endp			; End of the Stack_Init procedure
	Subttl	Push_Byte	Push Byte Stack Routine
	Page	+
;******************************************************************************
;
;	Push_Byte(Stack, Byte)
;
;		Save the required registers
;		Get pointer to the private stack area
;		Get the current stack pointer
;		Check for stack overflow
;		If no stack overflow
;			Push the byte value onto the stack
;			Update the current stack pointer
;		Else stack overflow
;			Set carry flag indicating stack overflow
;		Endif
;		Restore the required registers
;		Return to the caller
;
;	Registers on Entry:
;
;		AL    - Byte value to push
;		DS:DI - Pointer to private stack structure
;
;	Registers on Exit:
;
;		FL    - CY set if stack overflow
;
;******************************************************************************
		Even			; Force procedure to even address
Push_Byte	Proc	Near		; Push byte onto stack procedure
	Save	bx,si			; Save the required registers
	mov	bx,ds:[di.Private_Size] ; Setup to check for
	add	bx,BYTE_SIZE		;		     stack overflow
	mov	si,ds:[di.Private_Pointer]
	cmp	si,bx			; Check for stack overflow
	cmc				; Set carry flag to the correct state
	jc	Push_Byte_Exit		; Jump if stack overflow
	lea	bx,ds:[di.Private_Data] ; Get pointer to private stack area
	mov	ds:[bx + si],al 	; Save the byte value on the stack
	add	si,BYTE_SIZE		; Compute the new stack pointer value
	mov	ds:[di.Private_Pointer],si
Push_Byte_Exit:
	Restore bx,si			; Restore the required registers
	ret				; Return to the caller
Push_Byte	Endp			; End of the Push_Byte procedure
	Subttl	Push_Word	Push Word Stack Routine
	Page	+
;******************************************************************************
;
;	Push_Word(Stack, Word)
;
;		Save the required registers
;		Get pointer to the private stack area
;		Get the current stack pointer
;		Check for stack overflow
;		If no stack overflow
;			Push the word value onto the stack
;			Update the current stack pointer
;		Else stack overflow
;			Set carry flag indicating stack overflow
;		Endif
;		Restore the required registers
;		Return to the caller
;
;	Registers on Entry:
;
;		AX    - Word value to push
;		DS:DI - Pointer to private stack structure
;
;	Registers on Exit:
;
;		FL    - CY set if stack overflow
;
;******************************************************************************
		Even			; Force procedure to even address
Push_Word	Proc	Near		; Push word onto stack procedure
	Save	bx,si			; Save the required registers
	mov	bx,ds:[di.Private_Size] ; Setup to check for
	add	bx,WORD_SIZE		;		     stack overflow
	mov	si,ds:[di.Private_Pointer]
	cmp	si,bx			; Check for stack overflow
	cmc				; Set carry flag to the correct state
	jc	Push_Word_Exit		; Jump if stack overflow
	lea	bx,ds:[di.Private_Data] ; Get pointer to private stack area
	mov	ds:[bx + si],ax 	; Save the word value on the stack
	add	si,WORD_SIZE		; Compute the new stack pointer value
	mov	ds:[di.Private_Pointer],si
Push_Word_Exit:
	Restore bx,si			; Restore the required registers
	ret				; Return to the caller
Push_Word	Endp			; End of the Push_Word procedure
	Subttl	Push_Dword	Push Dword Stack Routine
	Page	+
;******************************************************************************
;
;	Push_Dword(Stack, Dword)
;
;		Save the required registers
;		Get pointer to the private stack area
;		Get the current stack pointer
;		Check for stack overflow
;		If no stack overflow
;			Push the dword value onto the stack
;			Update the current stack pointer
;		Else stack overflow
;			Set carry flag indicating stack overflow
;		Endif
;		Restore the required registers
;		Return to the caller
;
;	Registers on Entry:
;
;		DX:AX - Dword value to push
;		DS:DI - Pointer to private stack structure
;
;	Registers on Exit:
;
;		FL    - CY set if stack overflow
;
;******************************************************************************
		Even			; Force procedure to even address
Push_Dword	Proc	Near		; Push dword onto stack procedure
	Save	bx,si			; Save the required registers
	mov	bx,ds:[di.Private_Size] ; Setup to check for
	add	bx,DWORD_SIZE		;		     stack overflow
	mov	si,ds:[di.Private_Pointer]
	cmp	si,bx			; Check for stack overflow
	cmc				; Set carry flag to the correct state
	jc	Push_Dword_Exit 	; Jump if stack overflow
	lea	bx,ds:[di.Private_Data] ; Get pointer to private stack area
	mov	ds:[bx + si],ax 	; Save the dword value on the stack
	mov	ds:[bx + si + WORD_SIZE],dx
	add	si,DWORD_SIZE		; Compute the new stack pointer value
	mov	ds:[di.Private_Pointer],si
Push_Dword_Exit:
	Restore bx,si			; Restore the required registers
	ret				; Return to the caller
Push_Dword	Endp			; End of the Push_Dword procedure
	Subttl	Pop_Byte	Pop Byte Stack Routine
	Page	+
;******************************************************************************
;
;	Pop_Byte(Stack, Byte)
;
;		Save the required registers
;		Get pointer to the private stack area
;		Get the current stack pointer
;		Check for stack underflow
;		If no stack underflow
;			Pop the byte value from the stack
;			Update the current stack pointer
;		Else stack underflow
;			Set carry flag indicating stack underflow
;		Endif
;		Restore the required registers
;		Return to the caller
;
;	Registers on Entry:
;
;		DS:DI - Pointer to private stack structure
;
;	Registers on Exit:
;
;		AL    - Byte value from stack
;		FL    - CY set if stack underflow
;
;******************************************************************************
		Even			; Force procedure to even address
Pop_Byte	Proc	Near		; Pop byte from stack procedure
	Save	bx,si			; Save the required registers
	lea	bx,ds:[di.Private_Data] ; Get pointer to private stack area
	mov	si,ds:[di.Private_Pointer]
	sub	si,BYTE_SIZE		; Compute the new stack pointer value
	jc	Pop_Byte_Exit		; Jump if stack underflow
	mov	al,ds:[bx + si] 	; Get the byte value from the stack
	mov	ds:[di.Private_Pointer],si
Pop_Byte_Exit:
	Restore bx,si			; Restore the required registers
	ret				; Return to the caller
Pop_Byte	Endp			; End of the Pop_Byte procedure
	Subttl	Pop_Word	Pop Word Stack Routine
	Page	+
;******************************************************************************
;
;	Pop_Word(Stack, Word)
;
;		Save the required registers
;		Get pointer to the private stack area
;		Get the current stack pointer
;		Check for stack underflow
;		If no stack underflow
;			Pop the word value from the stack
;			Update the current stack pointer
;		Else stack underflow
;			Set carry flag indicating stack underflow
;		Endif
;		Restore the required registers
;		Return to the caller
;
;	Registers on Entry:
;
;		DS:DI - Pointer to private stack structure
;
;	Registers on Exit:
;
;		AX    - Word value from stack
;		FL    - CY set if stack underflow
;
;******************************************************************************
		Even			; Force procedure to even address
Pop_Word	Proc	Near		; Pop word from stack procedure
	Save	bx,si			; Save the required registers
	lea	bx,ds:[di.Private_Data] ; Get pointer to private stack area
	mov	si,ds:[di.Private_Pointer]
	sub	si,WORD_SIZE		; Compute the new stack pointer value
	jc	Pop_Word_Exit		; Jump if stack underflow
	mov	ax,ds:[bx + si] 	; Get the word value from the stack
	mov	ds:[di.Private_Pointer],si
Pop_Word_Exit:
	Restore bx,si			; Restore the required registers
	ret				; Return to the caller
Pop_Word	Endp			; End of the Pop_Word procedure
	Subttl	Pop_Dword	Pop Dword Stack Routine
	Page	+
;******************************************************************************
;
;	Pop_Dword(Stack, Dword)
;
;		Save the required registers
;		Get pointer to the private stack area
;		Get the current stack pointer
;		Check for stack underflow
;		If no stack underflow
;			Pop the dword value from the stack
;			Update the current stack pointer
;		Else stack underflow
;			Set carry flag indicating stack underflow
;		Endif
;		Restore the required registers
;		Return to the caller
;
;	Registers on Entry:
;
;		DS:DI - Pointer to private stack structure
;
;	Registers on Exit:
;
;		DX:AX - Dword value from stack
;		FL    - CY set if stack underflow
;
;******************************************************************************
		Even			; Force procedure to even address
Pop_Dword	Proc	Near		; Pop dword from stack procedure
	Save	bx,si			; Save the required registers
	lea	bx,ds:[di.Private_Data] ; Get pointer to private stack area
	mov	si,ds:[di.Private_Pointer]
	sub	si,DWORD_SIZE		; Compute the new stack pointer value
	jc	Pop_Dword_Exit		; Jump if stack underflow
	mov	ax,ds:[bx + si] 	; Get the dword value from the stack
	mov	dx,ds:[bx + si + WORD_SIZE]
	mov	ds:[di.Private_Pointer],si
Pop_Dword_Exit:
	Restore bx,si			; Restore the required registers
	ret				; Return to the caller
Pop_Dword	Endp			; End of the Pop_Dword procedure
	Subttl	Top_Byte	Get Top Byte Stack Routine
	Page	+
;******************************************************************************
;
;	Top_Byte(Stack, Byte)
;
;		Save the required registers
;		Get pointer to the private stack area
;		Get the current stack pointer
;		Check for stack underflow
;		If no stack underflow
;			Get the byte value from the stack
;		Else stack underflow
;			Set carry flag indicating stack underflow
;		Endif
;		Restore the required registers
;		Return to the caller
;
;	Registers on Entry:
;
;		DS:DI - Pointer to private stack structure
;
;	Registers on Exit:
;
;		AL    - Byte value from stack
;		FL    - CY set if stack underflow
;
;******************************************************************************
		Even			; Force procedure to even address
Top_Byte	Proc	Near		; Get top byte from stack procedure
	Save	bx,si			; Save the required registers
	lea	bx,ds:[di.Private_Data] ; Get pointer to private stack area
	mov	si,ds:[di.Private_Pointer]
	sub	si,BYTE_SIZE		; Compute the new stack pointer value
	jc	Top_Byte_Exit		; Jump if stack underflow
	mov	al,ds:[bx + si] 	; Get the byte value from the stack
Top_Byte_Exit:
	Restore bx,si			; Restore the required registers
	ret				; Return to the caller
Top_Byte	Endp			; End of the Top_Byte procedure
	Subttl	Top_Word	Get Top Word Stack Routine
	Page	+
;******************************************************************************
;
;	Top_Word(Stack, Word)
;
;		Save the required registers
;		Get pointer to the private stack area
;		Get the current stack pointer
;		Check for stack underflow
;		If no stack underflow
;			Get the word value from the stack
;		Else stack underflow
;			Set carry flag indicating stack underflow
;		Endif
;		Restore the required registers
;		Return to the caller
;
;	Registers on Entry:
;
;		DS:DI - Pointer to private stack structure
;
;	Registers on Exit:
;
;		AX    - Word value from stack
;		FL    - CY set if stack underflow
;
;******************************************************************************
		Even			; Force procedure to even address
Top_Word	Proc	Near		; Get top word from stack procedure
	Save	bx,si			; Save the required registers
	lea	bx,ds:[di.Private_Data] ; Get pointer to private stack area
	mov	si,ds:[di.Private_Pointer]
	sub	si,WORD_SIZE		; Compute the new stack pointer value
	jc	Top_Word_Exit		; Jump if stack underflow
	mov	ax,ds:[bx + si] 	; Get the word value from the stack
Top_Word_Exit:
	Restore bx,si			; Restore the required registers
	ret				; Return to the caller
Top_Word	Endp			; End of the Top_Word procedure
	Subttl	Top_Dword	Get Top Dword Stack Routine
	Page	+
;******************************************************************************
;
;	Top_Dword(Stack, Dword)
;
;		Save the required registers
;		Get pointer to the private stack area
;		Get the current stack pointer
;		Check for stack underflow
;		If no stack underflow
;			Get the dword value from the stack
;		Else stack underflow
;			Set carry flag indicating stack underflow
;		Endif
;		Restore the required registers
;		Return to the caller
;
;	Registers on Entry:
;
;		DS:DI - Pointer to private stack structure
;
;	Registers on Exit:
;
;		DX:AX - Dword value from stack
;		FL    - CY set if stack underflow
;
;******************************************************************************
		Even			; Force procedure to even address
Top_Dword	Proc	Near		; Get top dword from stack procedure
	Save	bx,si			; Save the required registers
	lea	bx,ds:[di.Private_Data] ; Get pointer to private stack area
	mov	si,ds:[di.Private_Pointer]
	sub	si,DWORD_SIZE		; Compute the new stack pointer value
	jc	Top_Dword_Exit		; Jump if stack underflow
	mov	ax,ds:[bx + si] 	; Get the word value from the stack
	mov	dx,ds:[bx + si + WORD_SIZE]
Top_Dword_Exit:
	Restore bx,si			; Restore the required registers
	ret				; Return to the caller
Top_Dword	Endp			; End of the Top_Dword procedure
;******************************************************************************
;
;	Define the end of the Emulator Code Segment
;
;******************************************************************************
Emulate Ends
	End				; End of the Stack module
