	Page	58,132
	Title	CONFIG.ASM	Apple System Configuration
;******************************************************************************
;
;   Name:	CONFIG.ASM	Apple System Configuration
;
;   Group:	Emulator
;
;   Revision:	1.00
;
;   Date:	January 30, 1988
;
;   Author:	Randy W. Spurlock
;
;******************************************************************************
;
;  Module Functional Description:
;
;		This module contains all the code for the Apple ][
;	system configuration.
;
;******************************************************************************
;
;  Changes:
;
;    DATE     REVISION				DESCRIPTION
;  --------   --------	-------------------------------------------------------
;   1/30/88	1.00	Original
;
;******************************************************************************
	Page
;
;  Public Declarations
;
	Public	Configuration		; Apple ][ system configuration routine
	Public	Assignment		; Parameter assignment test routine
	Public	Unknown 		; Unknown parameter routine
	Public	Noise			; Skip configuration noise routine
;
;  External Declarations
;
	Extrn	Get_Parameter:Near	; Get parameter routine       (SUPPORT)
	Extrn	Upper_Case:Near 	; Convert to upper case       (SUPPORT)
	Extrn	Match_Parameter:Near	; Match parameter routine     (SUPPORT)
	Extrn	ASCII_Binary:Near	; ASCII to binary conversion  (SUPPORT)
	Extrn	Select_Device:Near	; Select device type routine   (DEVICE)
	Extrn	Error:Near		; Apple emulator error routine	(APPLE)
	Extrn	Exit:Near		; Apple emulator exit routine	(APPLE)
	Extrn	CPU_Init:Near		; CPU initialization routine	  (CPU)
	Extrn	Debug_Init:Near 	; Debug initialization routine	(DEBUG)
        Extrn   Joy_X_Mid:Word          ; PC joystick X center value (JOYSTICK)
        Extrn   Joy_Y_Mid:Word          ; PC joystick Y center value (JOYSTICK)
        Extrn   Joy_Res:Byte            ; PC joystick resolution value(JOYSTICK)
	Extrn	Config_File:Byte	; Configuration file name	 (DATA)
	Extrn	Delimit_Input:Byte	; Input delimiter table 	 (DATA)
	Extrn	Name_Table:Byte 	; Device name match table	 (DATA)
	Extrn	Parm_Buffer:Byte	; Parameter buffer storage area  (DATA)
	Extrn	Slot_Init:Word		; Exp. slot initialization table (DATA)
	Extrn	System_Flag:Byte	; Apple emulator system flag byte(DATA)
	Extrn	Config_Flag:Byte	; Apple configuration flag byte  (DATA)
	Extrn	ERR_CONFIG_FILE:Abs	; Configuration file error code  (DATA)
	Extrn	ERR_PLACE_ERROR:Abs	; Parameter placement error code (DATA)
	Extrn	ERR_SECTION_ERROR:Abs	; Invalid section error code	 (DATA)
	Extrn	ERR_PARAMETER_ERROR:Abs ; Unknown parameter error code	 (DATA)
	Extrn	ERR_ASSIGN_ERROR:Abs	; Parameter assignment error code(DATA)
	Extrn	ERR_DEVICE_TYPE:Abs	; Invalid device type error code (DATA)
	Extrn	ERR_TYPE_ERROR:Abs	; Invalid slot type error code	 (DATA)
	Extrn	ERR_SLOT_ERROR:Abs	; Invalid slot number error code (DATA)
;
;  LOCAL Equates
;
HEX		Equ	16		; Base 16 - Hexadecimal
DECIMAL 	Equ	10		; Base 10 - Decimal
OCTAL		Equ	8		; Base 8  - Octal
BINARY		Equ	2		; Base 2  - Binary
TYPE_MASK	Equ	0Fh		; Delimiter type mask value
NEXT_SLOT	Equ	02h		; Slot initialization table offset value
CONFIG_SIZE	Equ	0C000h		; Maximum configuration file size (48k)
;
;  Define any include files needed
;
	Include 	Macros.inc	; Include the macro definitions
	Include 	Equates.inc	; Include the equate definitions
	Include 	Strucs.inc	; Include the structure definitions
	.286c				; Include 80286 instructions
	Page
;
;  Define the emulator code segment
;
Emulate Segment Word Public 'EMULATE'   ; Emulator code segment
	Assume	cs:Emulate, ds:Nothing, es:Nothing
	Subttl	Configuration	Apple ][ System Configuration
	Page	+
;******************************************************************************
;
;	Configuration(RAM_Space)
;
;		Save the required registers
;		Try to open the Apple ][ system configuration file (Apple.Ini)
;		If no errors opening the configuration file
;			Set flag indicating configuration data present
;			Read configuration file into Apple ][ RAM space
;			If no errors reading the configuration file
;				If configuration file is too large
;					Print configuration file error
;					Exit Apple ][ configuration
;				Endif
;			Else error reading configuration file
;				Print configuration file error
;				Exit Apple ][ configuration
;			Endif
;			Close the configuration file
;			While there are more lines in the configuration file
;				Get the next line from configuration file
;				While there are more parameters
;					If this is a comment line
;						Skip this configuration line
;					Endif
;					If this is the CPU configuration section
;						Call CPU configuration routine
;					Else
;						If this is a slot configuration
;							Call slot configuration
;							If configuration error
;								Print the error
;								Set carry flag
;								Exit config.
;							Endif
;						Else
;							Invalid configuration
;							Print the error
;							Set carry flag
;							Exit configuration
;						Endif
;					Endif
;				Endwhile no more parameters present
;			Endwhile no more lines in configuration file
;		Endif no configuration file is present
;		Clear the configuration data present flag
;		Initialize the slot counter
;		While there are more slots to check
;			If this slot is NOT initialized
;				Call the slot initialization routine
;			Endif
;			Increment to the next slot
;			Decrement the slot counter
;		Endwhile
;               Get joystick center values
;               Get joystick resolution value
;		Restore the required registers
;		Return to the caller
;
;	Registers on Entry:
;
;		DS    - 65C02 RAM space
;
;	Registers on Exit:
;
;		AX-DX - Destroyed
;		SI-DI - Destroyed
;
;******************************************************************************
		Even			; Force procedure to even address
Configuration	Proc	Near		; Apple system configuration procedure
	Save	bp,es			; Save the required registers
	mov	ax,cs			; Get the current code segment value
	mov	bx,ds			; Save 65C02 RAM space segment value
	mov	ds,ax			; Setup to open configurqation file
	mov	es,ax			; Initialize the extra segment value
	mov	ah,OPEN_FILE		; Get the open file function code
	mov	al,READ_ONLY		; Get the read file access code
	lea	dx,cs:[Config_File]	; Get pointer to configuration file name
	int	DOS			; Try to open the configuration file
	mov	ds,bx			; Restore 65C02 RAM space segment value
	mov	bx,ax			; Move file handle to BX register
	jc	Check_Slots		; Jump if no configuration file present
Read_Configuration:
	mov	ah,READ_FILE		; Get read file function code
	xor	dx,dx			; Setup the data buffer address (0000h)
	mov	cx,CONFIG_SIZE		; Get maximum configuration size (48k)
	int	DOS			; Try to read configuration file
	jnc	Check_Size		; Jump if no errors reading the file
Config_Error:
	mov	al,ERR_CONFIG_FILE	; Get configuration file error code
	call	Error			; Call routine to print the error
	call	Exit			; Call routine to exit emulator
Check_Size:
	cmp	ax,cx			; Check the configuration file size
	je	Config_Error		; Jump if configuration file too large
	mov	di,ax			; Setup to terminate configuration file
	mov	Byte Ptr ds:[di],EOF	; Make sure the file is terminated
	mov	ah,CLOSE_FILE		; Get close file function code
	int	DOS			; Close the configuration file
	xor	dx,dx			; Initialize the starting parse offset
	or	cs:[System_Flag],CONFIG_DATA
Config_Loop:
	mov	al,NULL 		; Get the parameter terminator byte
	mov	ah,EOF			; Get the buffer terminator byte
	lea	bx,es:[Delimit_Input]	; Get pointer to input delimiter table
	mov	cx,PARM_SIZE		; Get parameter buffer size [Bytes]
	lea	di,es:[Parm_Buffer]	; Get pointer to parameter buffer
	call	Get_Parameter		; Call routine to get next parameter
	jc	Check_Slots		; Jump if no more parameters available
	jz	Check_Type		; Jump if a null parameter
Placement_Error:
	mov	al,ERR_PLACE_ERROR	; Get parameter placement error code
	call	Error			; Call routine to print the error
	call	Exit			; Call routine to exit emulator
Check_Type:
	mov	bl,ah			; Get the delimiter type value
	and	bx,TYPE_MASK		; Mask off all but desired bits
	shl	bx,1			; Convert delimiter type to table index
	call	cs:[Type_Table + bx]	; Call routine to handle this type
	jmp	Short Config_Loop	; Loop till all parameters processed
Check_Slots:
	and	cs:[System_Flag],Not CONFIG_DATA
	mov	al,cs:[Config_Flag]	; Get the slot configuration flag byte
	xor	bx,bx			; Initialize slot initialization offset
	mov	cx,SLOT_MAX		; Get the number of slots to check
Slot_Loop:
	shr	al,1			; Check for this slot initialized
	jc	Slot_Next		; Jump if this slot initialized
	Save	ax,bx,cx		; Save the required registers
	mov	ax,bx			; Compute the actual
	shr	ax,1			;		     slot number
	call	cs:[Slot_Init + bx]	; Call the slot initialization routine
	Restore ax,bx,cx		; Restore the required registers
Slot_Next:
	add	bx,NEXT_SLOT		; Increment the slot offset value
	loop	Slot_Loop		; Loop till all slots are checked
        mov     dx,201h                 ; Get joystick port
        out     dx,al                   ; Write dummy to port to start timing
        xor     bx,bx                   ; Clear X count
        xor     cx,cx                   ; Clear Y count
        cli                             ; Clear interrupts so they dont interfere with the timing
X_Loop:
        in      al,dx                   ; Get byte from joystick port
        test    al,1                    ; Check X bit
        jz      Y_Loop                  ; Jump if clear
        inc     bx                      ; Increment X count
Y_Loop:
        test    al,2                    ; Check Y bit
        jz      XY_Loop                 ; Jump if clear
        inc     cx                      ; Increment Y count
        jz      Joy_Done                ; Jump on counter overflow
XY_Loop:
        test    al,3                    ; Check both bits
        jnz     X_Loop                  ; Jump if still more to read
Joy_Done:
        sti                             ; Restore interrupts
        mov     cs:[Joy_X_Mid],bx       ; Save X count as X center value
        mov     cs:[Joy_Y_Mid],cx       ; Save Y count as Y center value
        xor     cl,cl                   ; Clear joystick resolution value
Res_Loop:
        inc     cl                      ; Increment resolution value
        shr     bx,1                    ; Shift X right
        cmp     bx,8Fh                  ; Check if X is in range yet
        ja      Res_Loop                ; Loop until X value is in range
       ; dec     cl
        mov     cs:[Joy_Res],cl         ; Save joystick resolution value
	Restore bp,es			; Restore the required registers
	ret				; Return to the caller
Configuration	Endp			; End of the Configuration procedure
	Subttl	Unknown 	Unknown Parameter Routine
	Page	+
;******************************************************************************
;
;	Unknown()
;
;		Set error code to unknown parameter
;		Call routine to print error message
;		Call routine to exit the emulator
;		Return to the caller
;
;	Registers on Entry:
;
;		None
;
;	Registers on Exit:
;
;		None
;
;******************************************************************************
		Even			; Force procedure to even address
Unknown 	Proc	Near		; Unknown parameter procedure
	mov	al,ERR_PARAMETER_ERROR	; Set error code to unknown parameter
	call	Error			; Call routine to print the error
	call	Exit			; Call routine to exit emulator
	ret				; Return control to the caller
Unknown 	Endp			; End of the Unknown procedure
	Subttl	Assignment	Check Parameter Assignment Routine
	Page	+
;******************************************************************************
;
;	Assignment(Type, Position, Data, Buffer)
;
;		If current delimiter type is not assignment
;			Get the next parameter value
;			If parameter is non-null
;				Set error code to invalid parameter format
;				Call routine to print the error message
;				Call routine to exit the emulator
;			Else
;				If delimiter type is not assignment
;					Set error code to invalid parameter format
;					Call routine to print the error message
;					Call routine to exit the emulator
;				Endif
;			Endif
;		Endif
;		Return to the caller
;
;	Registers on Entry:
;
;		AH    - Current delimiter type
;		DX    - Current parse offset
;		DS:SI - Pointer to configuration data
;		ES:DI - Pointer to parameter buffer
;
;	Registers on Exit:
;
;		AX-CX - Destroyed
;		DX    - Updated to next parse offset
;
;******************************************************************************
		Even			; Force procedure to even address
Assignment	Proc	Near		; Parameter assignment test procedure
	test	ah,ASSIGN_TYPE		; Check current delimiter for assignment
	jnz	Assign_Exit		; Jump if delimiter type is assignment
	mov	al,NULL 		; Get the parameter terminator byte
	mov	ah,EOF			; Get the buffer terminator byte
	lea	bx,es:[Delimit_Input]	; Get pointer to input delimiter table
	mov	cx,PARM_SIZE		; Get parameter buffer size [Bytes]
	call	Get_Parameter		; Call routine to get next parameter
	jnc	Check_Assign		; Jump if a parameter was available
Assign_Error:
	mov	al,ERR_ASSIGN_ERROR	; Set error code to assignment error
	call	Error			; Call routine to print the error
	call	Exit			; Call routine to exit emulator
Check_Assign:
	jnz	Assign_Error		; Jump if not a null parameter
	test	ah,ASSIGN_TYPE		; Check for assignment delimiter
	jz	Assign_Error		; Jump if not assignment delimiter
Assign_Exit:
	ret				; Return control to the caller
Assignment	Endp			; End of the Assignment procedure
	Subttl	Invalid 	Invalid Delimiter Type Routine
	Page	+
;******************************************************************************
;
;	Invalid()
;
;		Print configuration file error
;		Exit the Apple ][ configuration
;		Return to the caller
;
;	Registers on Entry:
;
;		None
;
;	Registers on Exit:
;
;		None
;
;******************************************************************************
		Even			; Force procedure to even address
Invalid 	Proc	Near		; Invalid delimiter type procedure
	mov	al,ERR_CONFIG_FILE	; Get configuration file error code
	call	Error			; Call routine to print the error
	call	Exit			; Call routine to exit emulator
	ret				; Return to the caller (Dummy)
Invalid 	Endp			; End of the Invalid procedure
	Subttl	Skip		Skip Delimiter Routine
	Page	+
;******************************************************************************
;
;	Skip()
;
;		Return to the caller
;
;	Registers on Entry:
;
;		None
;
;	Registers on Exit:
;
;		None
;
;******************************************************************************
		Even			; Force procedure to even address
Skip		Proc	Near		; Skip delimiter procedure
	ret				; Return to the caller
Skip		Endp			; End of the Skip procedure
	Subttl	Noise		Comment Delimiter Type Routine
	Page	+
;******************************************************************************
;
;	Noise(Position, Data, Buffer)
;
;		While there is more configuration data
;			Get the next parameter value
;			If delimiter type is end of line
;				Exit the while loop
;			Endif
;		Endwhile
;		Return to the caller
;
;	Registers on Entry:
;
;		DX    - Current parse offset
;		DS:SI - Pointer to configuration data
;		ES:DI - Pointer to parameter buffer
;
;	Registers on Exit:
;
;		AX-CX - Destroyed
;		DX    - Updated to next parse offset
;
;******************************************************************************
		Even			; Force procedure to even address
Noise		Proc	Near		; Comment delimiter type procedure
	lea	bx,es:[Delimit_Input]	; Get pointer to input delimiter table
	mov	cx,PARM_SIZE		; Get parameter buffer size [Bytes]
Search_Loop:
	mov	al,NULL 		; Get the parameter terminator byte
	mov	ah,EOF			; Get the buffer terminator byte
	call	Get_Parameter		; Call routine to get next parameter
	jc	Noise_Done		; Jump if no more parameters
	test	ah,END_OF_LINE		; Check for end of line delimiter type
	jz	Search_Loop		; Loop till end of line is found
Noise_Done:
	ret				; Return to the caller
Noise		Endp			; End of the Noise procedure
	Subttl	Section 	Section Delimiter Type Routine
	Page	+
;******************************************************************************
;
;	Section(Position, Data, Buffer)
;
;		Call routine to get next parameter
;		If a valid parameter is present (non-null)
;			Call routine to convert parameter to uppercase
;			Call routine to check for section match
;			If no section match
;				Set error code to invalid section
;				Call routine to print error message
;				Call routine to exit the emulator
;			Endif
;			Call routine to handle this section
;		Else no/null parameter present
;			Set error code to invalid section
;			Call routine to print error message
;			Call routine to exit the emulator
;		Endif
;		Return to the caller
;
;	Registers on Entry:
;
;		DX    - Current parse offset
;		DS:SI - Pointer to configuration data
;		ES:DI - Pointer to parameter buffer
;
;	Registers on Exit:
;
;		AX-CX - Destroyed
;		DX    - Updated to next parse offset
;
;******************************************************************************
		Even			; Force procedure to even address
Section 	Proc	Near		; Section delimiter type procedure
	mov	al,NULL 		; Get the parameter terminator byte
	mov	ah,EOF			; Get the buffer terminator byte
	lea	bx,es:[Delimit_Input]	; Get pointer to input delimiter table
	mov	cx,PARM_SIZE		; Get parameter buffer size [Bytes]
	call	Get_Parameter		; Call routine to get next parameter
	jbe	Section_Error		; Jump if no section name present
	call	Upper_Case		; Call routine to convert to uppercase
	Save	si,ds			; Save pointer to configuration data
	mov	bx,es			; Setup to access
	mov	ds,bx			;		  section match table
	lea	si,ds:[Match_Table]	; Get pointer to start of match table
	xchg	al,ah			; Save the actual parameter length
	lodsb				; Get the match table entry size (Bytes)
	xchg	al,ah			; Restore the actual parameter length
	call	Match_Parameter 	; Call routine to check for a match
	Restore si,ds			; Restore pointer to configuration data
	jnc	Process_Section 	; Jump if a section match was found
Section_Error:
	mov	al,ERR_SECTION_ERROR	; Get configuration file error code
	call	Error			; Call routine to print the error
	call	Exit			; Call routine to exit emulator
Process_Section:
	cbw				; Convert match number to a full word
	mov	bx,ax			; Setup to process the section type
	shl	bx,1			; Convert match number to table index
	call	cs:[Section_Table + bx] ; Call routine to handle this section
	ret				; Return to the caller
Section 	Endp			; End of the Section procedure
	Subttl	CPU_Section	CPU Section Routine
	Page	+
;******************************************************************************
;
;	CPU_Section(Position, Data, Buffer)
;
;		Call routine to eat the rest of section title
;		Call routine to handle CPU initialization
;		Return to the caller
;
;	Registers on Entry:
;
;		DX    - Current parse offset
;		DS:SI - Pointer to configuration data
;		ES:DI - Pointer to parameter buffer
;
;	Registers on Exit:
;
;		AX-CX - Destroyed
;		DX    - Updated to next parse offset
;
;******************************************************************************
		Even			; Force procedure to even address
CPU_Section	Proc	Near		; CPU section procedure
	call	Noise			; Call routine to skip rest of line
	call	CPU_Init		; Call CPU initialization routine
	ret				; Return to the caller
CPU_Section	Endp			; End of the CPU_Section procedure
	Subttl	SLOT_Section	SLOT Section Routine
	Page	+
;******************************************************************************
;
;	SLOT_Section(Position, Data, Buffer)
;
;		Save the required registers
;		Call routine to get the next parameter
;		If a valid parameter is present (non-null)
;			Call routine to convert parameter to binary
;			If the parameter is a valid slot number
;				Save the selected slot number
;				Call routine to eat the rest of section title
;				While there is not a non-null parameter
;					Call routine to get the next parameter
;					If delimiter type is a comment
;						Call routine to skip this line
;					Endif
;				Endwhile
;				Call routine to convert parameter to uppercase
;				Call routine to match the parameter
;				If parameter is not card type
;					Set error code to invalid slot type
;					Call routine to print error message
;					Call routine to exit the emulator
;				Endif
;				Call routine to check for parameter assignment
;				Call routine to get the next parameter
;				If a valid parameter is present (non-null)
;					Call routine to convert to uppercase
;					Call routine to match the parameter
;					If there is no parameter match
;						Set error to invalid slot type
;						Call routine to print error
;						Call routine to exit emulator
;					Else there is a match
;						Call routine to handle device
;					Endif
;				Else no/null parameter present
;					Set error code to invalid slot type
;					Call routine to print error message
;					Call routine to exit the emulator
;				Endif
;			Else parameter is not a slot number
;				Set error code to invalid slot
;				Call routine to print error message
;				Call routine to exit the emulator
;			Endif
;		Else no/null parameter present
;			Set error code to invalid slot
;			Call routine to print error message
;			Call routine to exit the emulator
;		Endif
;		Restore the required registers
;		Return to the caller
;
;	Registers on Entry:
;
;		DX    - Current parse offset
;		DS:SI - Pointer to configuration data
;		ES:DI - Pointer to parameter buffer
;
;	Registers on Exit:
;
;		AX-CX - Destroyed
;		DX    - Updated to next parse offset
;
;******************************************************************************
		Even			; Force procedure to even address
SLOT_Section	Proc	Near		; SLOT section procedure
	Save	bp			; Save the required registers
	mov	al,NULL 		; Get the parameter terminator byte
	mov	ah,EOF			; Get the buffer terminator byte
	lea	bx,es:[Delimit_Input]	; Get pointer to input delimiter table
	mov	cx,PARM_SIZE		; Get parameter buffer size [Bytes]
	call	Get_Parameter		; Call routine to get next parameter
	jbe	Slot_Error		; Jump if no slot number present
	mov	ax,DECIMAL		; All slot numbers are decimal
	call	ASCII_Binary		; Call routine to convert to binary
	jc	Slot_Error		; Jump if parameter non-numeric
	cmp	ax,SLOT_MAX		; Check for a valid slot number
	jnc	Slot_Error		; Jump if an invalid slot number
	mov	bp,ax			; Save the actual slot number
	call	Noise			; Call routine to skip rest of line
Scan_Loop:
	mov	al,NULL 		; Get the parameter terminator byte
	mov	ah,EOF			; Get the buffer terminator byte
	lea	bx,es:[Delimit_Input]	; Get pointer to input delimiter table
	mov	cx,PARM_SIZE		; Get parameter buffer size [Bytes]
	call	Get_Parameter		; Call routine to get next parameter
	jc	Type_Error		; Jump if no slot type given
	jnz	Check_Parameter 	; Jump if non-null parameter was given
	test	ah,COMMENT_TYPE 	; Check for a comment type delimiter
	jz	Scan_Loop		; Jump if this is not a comment
	call	Noise			; Call routine to skip this line
	jmp	Short Scan_Loop 	; Go try to get slot type value
Check_Parameter:
	call	Upper_Case		; Call routine to convert to uppercase
	Save	si,ds			; Save pointer to configuration data
	mov	bx,es			; Setup to access
	mov	ds,bx			;		  slot match table
	lea	si,ds:[Slot_Table]	; Get pointer to start of match table
	xchg	al,ah			; Save the actual parameter length
	lodsb				; Get the match table entry size (Bytes)
	xchg	al,ah			; Restore the actual parameter length
	call	Match_Parameter 	; Call routine to check for a match
	Restore si,ds			; Restore pointer to configuration data
	jnc	Assign_Check		; Jump if a device type match found
Type_Error:
	mov	al,ERR_TYPE_ERROR	; Get invalid device type error code
	call	Error			; Call routine to print the error
	call	Exit			; Call routine to exit emulator
Slot_Error:
	mov	al,ERR_SLOT_ERROR	; Get invalid slot number error code
	call	Error			; Call routine to print the error
	call	Exit			; Call routine to exit emulator
Assign_Check:
	call	Assignment		; Call routine to check for assignment
	mov	al,NULL 		; Get the parameter terminator byte
	mov	ah,EOF			; Get the buffer terminator byte
	lea	bx,es:[Delimit_Input]	; Get pointer to input delimiter table
	mov	cx,PARM_SIZE		; Get parameter buffer size [Bytes]
	call	Get_Parameter		; Call routine to get next parameter
	jbe	Device_Error		; Jump if no slot device type given
	call	Upper_Case		; Call routine to convert to uppercase
	Save	ax,si,ds		; Save pointer to configuration data
	mov	bx,es			; Setup to access
	mov	ds,bx			;		  device name table
	lea	si,ds:[Name_Table]	; Get pointer to start of match table
	xchg	al,ah			; Save the actual parameter length
	lodsb				; Get the match table entry size (Bytes)
	xchg	al,ah			; Restore the actual parameter length
	call	Match_Parameter 	; Call routine to check for a match
	mov	bl,al			; Save the matching parameter number
	Restore ax,si,ds		; Restore pointer to configuration data
	jnc	Device_Check		; Jump if a device type match found
Device_Error:
	mov	al,ERR_DEVICE_TYPE	; Get invalid device type error code
	call	Error			; Call routine to print the error
	call	Exit			; Call routine to exit emulator
Device_Check:
	xor	bh,bh			; Convert device type to a full word
	push	bx			; Save the actual device type
	test	ah,COMMENT_TYPE 	; Check for comment type delimiter
	jz	Process_Device		; Jump if not a comment delimiter
	call	Noise			; Call routine to eat the comment
Process_Device:
	pop	bx			; Restore the actual device type
	call	Select_Device		; Call routine to select this device
Slot_Exit:
	Restore bp			; Restore the required registers
	ret				; Return to the caller
SLOT_Section	Endp			; End of the SLOT_Section procedure
	Subttl	DEBUG_Section	DEBUG Section Routine
	Page	+
;******************************************************************************
;
;	DEBUG_Section(Position, Data, Buffer)
;
;		Call routine to eat the rest of section title
;		Call routine to handle debug initialization
;		Return to the caller
;
;	Registers on Entry:
;
;		DX    - Current parse offset
;		DS:SI - Pointer to configuration data
;		ES:DI - Pointer to parameter buffer
;
;	Registers on Exit:
;
;		AX-CX - Destroyed
;		DX    - Updated to next parse offset
;
;******************************************************************************
		Even			; Force procedure to even address
DEBUG_Section	Proc	Near		; DEBUG section procedure
	call	Noise			; Call routine to skip rest of line
	call	Debug_Init		; Call debug initialization routine
	ret				; Return to the caller
DEBUG_Section	Endp			; End of the DEBUG_Section procedure
	Page
;******************************************************************************
;
;	Define the configuration data areas
;
;******************************************************************************
		Even			; Force byte to even address
Type_Table	Equ	This Word	; Define the delimiter type jump table
	Dw	Offset Invalid		; Type 0 - ***** Invalid *****
	Dw	Offset Skip		; Type 1 - Separator
	Dw	Offset Noise		; Type 2 - Comment
	Dw	Offset Noise		; Type 3 - Comment & Separator
	Dw	Offset Section		; Type 4 - Section
	Dw	Offset Section		; Type 5 - Section & Separator
	Dw	Offset Invalid		; Type 6 - ***** Invalid *****
	Dw	Offset Invalid		; Type 7 - ***** Invalid *****
	Dw	Offset Skip		; Type 8 - End of line
	Dw	Offset Skip		; Type 9 - End of line & Separator
	Dw	Offset Invalid		; Type A - ***** Invalid *****
	Dw	Offset Invalid		; Type B - ***** Invalid *****
	Dw	Offset Invalid		; Type C - ***** Invalid *****
	Dw	Offset Invalid		; Type D - ***** Invalid *****
	Dw	Offset Invalid		; Type E - ***** Invalid *****
	Dw	Offset Invalid		; Type F - ***** Invalid *****
Match_Table	Equ	This Byte	; Start of the section match table
	Db	6			; Size of match table entries
	Db	3,"CPU  "               ; CPU section type value
	Db	4,"SLOT "               ; SLOT section type value
	Db	4,"DEBUG"               ; DEBUG section type value
	Db	0			; End of match table
Section_Table	Equ	This Word	; Define the section jump table
	Dw	Offset CPU_Section	; CPU section processing routine
	Dw	Offset SLOT_Section	; SLOT section processing routine
	Dw	Offset DEBUG_Section	; DEBUG section processing routine
Slot_Table	Equ	This Byte	; Define the slot type match table
	Db	5			; Define the match table entry size
	Db	4,"TYPE"                ; Slot device type parameter string
	Db	0			; End of the match table
;******************************************************************************
;
;	Define the end of the Emulator Code Segment
;
;******************************************************************************
Emulate Ends
	End				; End of the Config module
