; Uploaded to simtel-20 by Ralph Hyre (ralphw@c.cs.cmu.edu)
; Sent to Ralph by Chris Peck (chris@bingvaxb.bitnet)
; You will need one of the follwing items to use these drivers:
;	the PCPI OEM package (bucks involved - order from PCPI)
;	the assembled output of the PCPI OEM package assembler.
;	(this will be made available here as soon as I can assemble it)
;*** Warning, be especially careful with this file as it came to me
;*** in two pieces and it may not be correct.  I tried to comment out
;*** the documentation I found, but double-check it first before feeding
;*** it to your assembler.		- Ralph
;
;SYNETIX.DVR                                  7/21/85
;SYNETIX.A65
;
;Release Ver. 1.6
;
;-Applicard device driver for Synetix Flashcard
;
;by:  Steven Hirsch
;     c/o The Mixingboard, Inc.
;     Box 1488
;     Burlington, Vermont
;     05401
;
;Voice Phone:   (802) 658-4793  M-F  10:00am.- 5:00pm. EST
;
;Or leave message on Z-Node Central: (415) 489-9005
;
;Intro:
;
;After being on the recieving end of many useful utilities and
;drivers for the Applicard, I am offering my own!
;
;A friend recently made me a deal that could not be refused; if I
;were to write him a driver for his Synetix Flashcard SSD (Solid-
;State Disk), he would trade me an extra SSD for my troubles! Many
;hours of sweat and frustration later, this file emerged.
;Apparently the Synetix company folded before they could execute
;their own (Butch at CALL A.P.P.L.E. informs me that a "buggy"
;version was floating around), so I am releasing this one for use
;by licensed owners of the Applicard. All rights regarding the
;sale and commercial distribution of this driver are reserved by
;myself, however. Please honor this fact and do not resell this,
;give it away only!
;
;Features:
;
;-Automatic recognition of an initialized directory on  cold-boot.
;This prevents loss of valid data on a non-power-off reboot (Open-
;Apple / CTRL / Reset on a IIe).
;
;-Will query user for the slot occupied by the card on a cold-
;boot, and/or may be patched to any desired default with no query.
;
;-Supports 144K (1/2 full) cards, by assembly-time conditionals,
;or by patching two bytes with DDT.
;
;Specs:
;
;The SSD appears to CP/M as a disk device with 72 physical tracks.
;Each track is divided into 16 physical sectors, 256 bytes per
;sector. This yields a total capacity (for a 288k card) of 286k,
;after allowing for the directory. For the technically inclined,
;here is the disk parameter header:
;
                ;Synetix 288k as CP/M ramdisk
        MHSTPARM        2048,256,16
        DW      256             ;BYTES PER SECTOR
        DW      32              ;CPM RECORDS PER TRACK
        DB      2               ;CPM RECORDS PER HOST BLOCK
        DB      16              ;CPM RECORDS PER ALLOCATON
        DB      1               ;SECTOR MASK
        DB      1               ;SECTOR SHIFT

        DISKDEF         0,0,31,0,2048,144,64,0,0
        DW      32              ;SEC PER TRACK
        DB      4               ;BLOCK SHIFT
        DB      15              ;BLOCK MASK
        DB      1               ;EXTNT MASK
        DW      143             ;DISK SIZE-1
        DW      63              ;DIRECTORY MAX
        DB      128             ;ALLOC0
        DB      0               ;ALLOC1
        DW      0               ;CHECK SIZE
        DW      0               ;OFFSET
 XLT0   EQU     0               ;NO XLATE TABLE

                ;-------------------------------------------------------------
                ; THE ALLOCATION AND CHECK VECTORS DEFINED BY ENDEF ARE PLACED
                ; IN THE HEADER BLOCKDEV INFORMATION ARRAY.
                ;-------------------------------------------------------------

      DIRBUF:   DS      128     ;DIRECTORY ACCESS BUFFER
      CSV0:     DS      0
      ALV0:     DS      18

                END

;Installation:
;
;Install the driver as you would any Applicard driver. It may be
;set up as any valid device number, though the number of devices
;must remain as one! Configuring it as drive A: will make for very
;fast warm-boots, as the Applicard does not require a system to be
;present on the default drive, and needs only to rebuild the
;allocation vector.
;
;Once installation is complete, cold-boot the new system. Shortly
;after the LOADING DRIVERS message appears, you will hear a beep,
;and be prompted for the slot number occupied by the SSD. Range
;checking will screen out any invalid slot numbers (outside the
;range of 1-7), but no attempt will be made to verify if the
;choice of slot is correct. If an error is made, just reboot and
;re-enter it. A future release may test for the card's prescence
;in the selected slot, but without a C800 ROM, this will be a
;difficult task to perform reliably.
;
;
;Modifications:
;
;Once a particular position has been decided, use DDT to set the
;byte at offset 2CDh (3CDh absolute address under DDT) to the
;binary equivalent of the slot number, ie. for slot #3:
;
;
;A>ren synetix.bak=synetix.dvr      For safety's sake.
;
;A>ddt synetix.bak
;
;(Response omitted)
;
;-s3CD <cr>
;
;3CD 00 03 <cr>                     Enter slot number.
;
;3CE 00 .  <cr>
;
;-G0       <cr>
;
;A>save 4 synetix.dvr
;
;If this driver is then installed, the sign-on query will not take
;place, and the default slot is activated. Reset the byte to zero
;to re-activate this feature.
;
;For anyone owning a 144k card, all I can say is that with the
;price of 16k RAM hovering around .79-.99, what's keeping you from
;upgrading? But for the die-hards, you may reassemble the file
;with Wink's A65.COM and related utilities, setting the SIZE144
;equate TRUE. If you do not have access to the OEM development kit
;which contains the cross-assembler, patch the following bytes:
;
;-s2AF
;
;2AF 8F 47                ;Fixes maxblk in DPH
;
;2B0 xx .
;
;-s2E6
;
;2E6 B0 57                ;Return error on track >= 36
;
;2E7 xx .
;
;-G0
;
;A>save 4 synetix.dvr
;
;
;Good luck with this program, and please let me know of any bugs
;or difficulties!

; *** This is presumably part 2 of the synetix driver, it wasn't clear in
; *** the mail I received.  Beware of spurious characters...

P
RW16K:  LDY     #00             ;Y COUNTS 0 - 256 FOR BUFFER INDEX
        ASL     A               ;MULTIPLY PAGE OFFSET BY 2 FOR HIGH ORDER
                                ;WHEN IN 16K BLOCK
        STA     CNT             ;STORE IT
C0X1E:  STA     y 

;************************************************************************
;*			Steven Hirsch w/ acknowledgements to:		*
;*                                                                      *
;*                      Wink (Winthrop Saville)                         *
;*                      Fred Meyer                                      *
;*                      Doug Laing                                      *
;*                      Albert F. Woodhull                              *
;*                                                                      *
;************************************************************************

FALSE   .EQU    0               ;ASSEMBLY TIME FALSE
TRUE    .EQU    NOT FALSE

SIZE144 .EQU    FALSE           ;SET TRUE TO ASSEMBLE FOR 144K SYNETIX CARD!

BASEP0  .QUERY  "ENTER BASE OF PAGE 0: "
LENP0   .EQU    4
PAGE0W0 .EQU    BASEP0
PAGE0W1 .EQU    BASEP0+2

;GET SYSTEM EQUATES
        .NOLIST
        .INCLUDE DRVREQUS.A65
        .LIST

;EQUATES
FDSK            .EQU    0       ;DEFAULT FIRST DISK IS A
;
;PAGE ZERO
;
RWDMA   .EQU    0FEH            ;THIS LOCATION WILL HAVE TO BE SAVED

;
CONDEV  .EQU    19              ;CONSOLE IS DEVICE #19

;HEADER
BEGDRVR:
        .WORD   0               ;LOAD ADDRESS (0=RELOCATE)
        .WORD   ((ENDDRVR-BEGDRVR)+0FFH) AND 0FF00H     ;LENGTH
        .BYTE   LENP0           ;LENGTH OF PAGE 0 DATA
        .BYTE   0               ;TAG FIELD (FOR FUTURE MUST BE ZERO)
FDISK:  .WORD   FDSK            ;FIRST DISK
MDISK:  .WORD   1               ;MAXIMUM NUMBER OF DRIVES
        .WORD   INIT            ;INITIALIZE
        .WORD   READ            ;READ A SECTOR
        .WORD   WRITE           ;WRITE A SECTOR
        .WORD   OTHER           ;OTHER
        .WORD   POLL            ;POLL
        .WORD   6               ;VERSION NUMBER
NAME:   .BYTE   15,"SYNETIX RAMDISK"    ;NAME (MUST BE 15 BYTES PLUS THE
                                        ; LENGTH BYTE)

        ;BUFFER SIZE, CHECK SIZE, AND ALLOCATION SIZE
        .WORD   256             ;HOST BUFFER SIZE
        .WORD   0               ;CHECK VECTOR SIZE
        .WORD   18              ;ALLOCATION VECTOR SIZE

;******************************
;ROUTINE: INIT
;PURP:  INITIALIZE ENTRY POINT
;ENTRY: NONE
;EXIT:  IF NO ERRORS THEN
;         A = 0
;       ELSE
;         A = 0FFH
;USED:  ALL
;******************************

        ;INITIIALIZE
INIT:   LDY     SLOTNO                  ;SKIP QUERY IF SLOTNO <> 0
        BNE     PRESET

        JSR     SETVECTOR               ;SET UP VECTORS TO SFTVIDEO R/W
MESS:   LDY     #00
$1:     INY
        LDA     MESSAGE,Y               ;GET A LETTER FROM MESSAGE
        JSR     APPLEOUT                ;DISPLAY IT
        CPY     MESSAGE                 ;= LENGTH OF MESSAGE?
        BNE     $1

$2:     LDA     #07                     ;BELL CHAR.
        JSR     APPLEOUT
        JSR     APPLEIN                 ;GET CHARACTER
        CMP     #31H                    ;LESS THAN ASCII "1"?
        BCC     $2                      ;TRY AGAIN
        CMP     #38H                    ;>= ASCII "8"?
        BCS     $2                      ;TRY AGAIN
        PHA                             ;APPLEOUT DOESN'T PRESERVE "A"
        JSR     APPLEOUT                ;DISPLAY CHOICE
        PLA
        SEC
        SBC     #30H                    ;CONVERT ASCII TO BINARY
        STA     SLOTNO                  ;AND SET SLOT #

;SET UP ABSOLUTE SLOT ADDRESSES
PRESET: LDA     SLOTNO          ;GET SLOT NUMBER
        ASL     A
        ASL     A
        ASL     A
        ASL     A               ;*16
        CLC
        ADC     #80H            ;ADD 80H FOR TOTAL SLOT OFFSET
        TAY

        STY     SLTBASE         ;INITIALIZE SLTBASE FOR LATER USE

        STY     C0X0A+1
        STY     C0X0B+1
        STY     C0X0C+1
        STY     C0X0D+1
        STY     C0X0E+1         ;INITIALIZE LOW-ORDER SSD ADDRESS BYTE

        INY
        STY     C0X1A+1
        STY     C0X1B+1
        STY     C0X1C+1
        STY     C0X1D+1
        STY     C0X1E+1         ;INITIALIZE HI-ORDER SSD ADDRESS BYTE

        INY
        STY     C0X2A+1
        STY     C0X2B+1
        STY     C0X2C+1         ;BLOCK TO R/W DURING DIRECTORY INITIALIZATION

;TEST THE FIRST 32 BYTES OF SSD BLOCK #1, PAGE #1 (DIRECTORY!) FOR PRESCENCE
;OF THE RAMDISK ID STRING
        LDA     #00
C0X1A:  STA     0C081H          ;SET HI-BYTE
        LDY     #00
C0X0A:  STY     0C080H          ;AND LO-BYTE TO 0
C0X2A:  LDA     0C082H          ;READ BLOCK 1
        CMP     RAMID,Y         ;LOOP UNTIL 16 BYTES OR TEST FAILS
        BNE     $2              ;TEST FAILED, INITIALIZE DIRECTORY
        INY
        CPY     #32
        BNE     C0X0A           ;FALL THRU IF WE PASSED THE TEST AND RETURN
        JMP     IDONE

$2:     LDA     #0E5H           ;FILL THE FIRST 8 PAGES WITH "E5'S"
        LDX     #00
C0X1B:  STX     0C081H
        LDY     #00
C0X0B:  STY     0C080H
C0X2B:  STA     0C082H
        INY
        BNE     C0X0B
        INX                     ;DONE WITH 256 BYTES, NEXT PAGE ....
        CPX     #08
        BNE     C0X1B

;COPY RAMDISK ID OVER THE FIRST 32 BYTES SO A COLDBOOT WON'T REINITIALIZE
C0X1C:  STY     0C081H          ;Y IS ZERO, STORE IT IN BOTH LATCHES...
C0X0C:  STY     0C080H
        LDA     RAMID,Y
C0X2C:  STA     0C082H
        INY
        CPY     #32
        BNE     C0X0C

IDONE:  LDA     #00             ;NO ERRORS
        RTS


;******************************
;ROUTINE: READ / WRITE
;PURP:  READ OR WRITE A SECTOR
;ENTRY: A = HIGH BYTE OF PARAMETERS
;       Y = LOW BYTE OF PARAMETERS
;         PARM[OCURDSK] = DRIVE
;         PARM[OCURTRK] = TRACK LOW BYTE
;         PARM[OCURTRK+1] = TRACK HIGH BYTE
;         PARM[OCURSEC] = SECTOR LOW BYTE
;         PARM[OCURSEC+1] = SECTOR HIGH BYTE (CURRENTLY 0)
;         PARM[OCURDMA] = BUFFER ADDRESS LOW BYTE
;         PARM[OCURDMA+1] = BUFFER ADDRESS HIGH BYTE
;EXIT:  IF NO ERRORS THEN
;         CLC
;       ELSE
;         SEC
;USED:  ALL
;******************************

READ:   LDX     #00             ;CODE FOR READ OPERATION
        STX     RWFLAG          ;SET FLAG
        JMP     RWMAIN

WRITE:  LDX     #01             ;WRITE OPERATION
        STX     RWFLAG          ;SET FLAG

RWMAIN: STY     PAGE0W0
        STA     PAGE0W0+1       ;SAVE PARAMETER BLOCK ADDRESS
        JSR     SAVELOCS        ;SAVE PAGE 0 LOCATIONS
        JSR     SETUP           ;SET UP SSD BLOCK#, PAGE OFFSET, AND DMA
        BCS     RWERR
        LDA     PAGENO          ;GET PAGE OFFSET
        LDY     FLAG16K         ;IS IT IN A 16K BLOCK?
        BNE     RW16K

;64K BLOCK R/W LOOP
C0X1D:  STA     0C081H          ;SET UP HIGH ORDER ADDRESS LATCH
        LDY     #00             ;WE WILL ALWAYS START ON A PAGE BOUNDRY
C0X0D:  STY     0C080H          ;SO SET LOW ORDER LATCH TO ZERO
        JSR     RWCOMM
        INY
        BNE     C0X0D              ;LOOP UNTIL WE TRANSFER 256 BYTES
        CLC
        JMP     RWDONE

;16K BLOCK R/W LOOP
RW16K:  LDY     #00             ;Y COUNTS 0 - 256 FOR BUFFER INDEX
        ASL     A               ;MULTIPLY PAGE OFFSET BY 2 FOR HIGH ORDER
                                ;WHEN IN 16K BLOCK
        STA     CNT             ;STORE IT
C0X1E:  STA     0C081H          ;AND SET HIGH LATCH WITH IT
        LDX     #00             ;X COUNTS 0 - 127 FOR LO-LATCH
C0X0E:  STX     0C080H          ;SET LOW LATCH
        STX     IDX             ;AND SAVE X
        JSR     RWCOMM
        LDX     IDX             ;RESTORE X
        INY                     ;BUMP 256 COUNTER
        BEQ     DONE16          ;DONE WITH 256 BYTES?
        INX                     ;NO, BUMP THE 128 COUNTER
        BPL     C0X0E           ;LOOP IF < 128
        INC     CNT             ;BUMP HIGH LATCH COUNTER FOR NEXT 128
        LDA     CNT
        JMP     C0X1E           ;BACK FOR ANOTHER 128 BYTES
DONE16: CLC
        JMP     RWDONE

;COMMON READ / WRITE ROUTINE, ADDRESS OFFSET FOR SSD "BLOCK" IS FILLED IN
;BY SETUP ROUTINE
RWCOMM: LDX     RWFLAG          ;TEST OP FLAG
        BNE     WR              ;WRITE IF NON-ZERO
;READ
C0XXA:  LDA     0C000H          ;LOW ORDER BYTE FILLED IN BY SETUP ROUTINE
        STA     (RWDMA),Y
        RTS
;WRITE
WR:     LDA     (RWDMA),Y
C0XXB:  STA     0C000H          ;FILLED IN BY SETUP
RWEND:  RTS


;RETURN WITH ERROR CODE IN A
RWERR:  LDA     #03             ;READ/WRITE ERROR FLAG
        SEC
RWDONE: JSR     RESTLOCS
        JMP     EXIT

;******************************
;ROUTINE: OTHER
;PURP:  OTHER COMMANDS
;ENTRY: PARAMETERS ARE READ DIRECTLY FROM Z-80
;EXIT:  IF NO ERRORS THEN
;         A = 0
;       ELSE
;         A = ERROR NUMBER
;USED:  ALL
;******************************

        ;OTHER COMMANDS
        ; OTHER PARAMETERS ARE DEPENDENT ON WHICH ENTRY IS CALLED
OTHER:
        CMP     #SNDPRMCMD      ;IS THIS THE SEND PARAMETERS COMMAND
        BNE     CHKFRMT         ;BIF NOT SEND PARMATERS

        ;SEND THE HOST AND DISK PARAMETERS
        ; ENTRY PARAMETERS:
        ;       THE DRIVE NUMBER (1 BYTE)
        ; EXIT PARAMETERS:
        ;       ERROR CODE (1 BYTE)
        JSR     RD1Z80BYTE      ;GET THE DRIVE NUMBER
        LDY     #0
        STY     IDX
$0:
        LDA     PARMS,Y
        JSR     WR1Z80BYTE      ;SEND THE NEXT BYTE
        INC     IDX             ;INCREMENT TO NEXT BYTE
        LDY     IDX
        CPY     #SZPARMS        ;ARE WE DONE ?
        BNE     $0              ;BIF NOT DONE
        LDA     #0              ;INDICATE NO ERRORS
        RTS


CHKFRMT:
        CMP     #FRMTCMD        ;FORMAT COMMAND ?
        BNE     CHKNAME         ;BIF NOT

        ;FORMAT A DRIVE
        ; ENTRY PARAMETERS:
        ;       THE DRIVE NUMBER (1 BYTE)
        ; EXIT PARAMETERS:
        ;       ERROR CODE (1 BYTE)
        JSR     RD1Z80BYTE      ;GET DRIVE AND FORMAT
        LDA     #0FFH           ;INDICATE AN ERROR (NO FORMTING)
        RTS

        ;CHECK FOR SEND NAME COMMAND
CHKNAME:
        CMP     #SNDNAMECMD     ;SEND NAME COMMAND ?
        BNE     CHKOTHR         ; BIF NOT

        ; ENTRY PARAMETERS:
        ;       NONE
        ; EXIT PARAMETERS:
        ;       SEND THE LENGTH OF THE NAME (1 BYTE)
        ;       FOLLOWED BYTE THE NAME (LENGTH NUMBER OF BYTES)
        ;       ERROR CODE (1 BYTE)
        LDA     NAME            ;GET LENGTH
        STA     CNT             ;SAVE AS COUNT
        JSR     WR1Z80BYTE      ;SEND IT TO HOST
        LDA     #1
        STA     IDX

$LP:    LDX     IDX
        LDA     NAME,X          ;GET NEXT CHARACTER
        JSR     WR1Z80BYTE      ;WRITE THE NEXT CHARACTER
        INC     IDX
        DEC     CNT
        BNE     $LP             ;CONTINUE UNTIL ALL BYTES ARE SENT
        LDA     #0              ;NO ERRORS
        RTS

CHKOTHR:
        LDA     #0FFH           ;BAD COMMAND
        RTS


;SYNETIX RAMDISK
PARMS:
        ;HOST PARAMETERS FIRST
        ;MHSTPARM       2048,256,16
        .WORD   256             ;BYTES PER SECTOR
        .WORD   32              ;CPM RECORDS PER TRACK
        .BYTE   2               ;CPM RECORDS PER HOST BLOCK
        .BYTE   16               ;CPM RECORDS PER ALLOCATION BLOCK
        .BYTE   1               ;SECTOR MASK
        .BYTE   1               ;SECTOR SHIFT COUNT

        ;DISK PARAMETER BLOCK
        ;DISKDEF        0,0,31,0,1024,128,48,48,3
        .WORD   32              ;SECTORS PER TRACK
        .BYTE   4               ;BLOCK SHIFT FACTOR
        .BYTE   15              ;BLOCK MASK
        .BYTE   1               ;EXTENT MASK

        .IF SIZE144
        .WORD   71              ;MAXBLK FOR 144K DISK
        .ELSE
        .WORD   143             ;NUMBER OF BLOCKS ON DISK - 1
        .ENDC

        .WORD   63              ;NUMBER OF DIRECTORY ENTRIES - 1
        .BYTE   128             ;ALLOC0 (MASKS)
        .BYTE   0               ;ALLOC1
        .WORD   0               ;CHECK MASKS
        .WORD   0               ;OFFSET TO DIRECTORY TRACK
SZPARMS: .EQU   $-PARMS


;***********************************
;ROUTINE: POLLENTRY
;PURP:  HANDLE POLLING, THIS ENTRY POINT
;       IS CALLED PERIODICALY WHILE THE APPLE IS
;       WAITING FOR A COMMAND FROM THE Z-80. THIS
;       CODE SHOULD BE VERY SHORT AS THE Z-80 IS
;       IGNORED WHILE THIS CODE IS BEING EXECUTED
;ENTRY: NONE
;EXIT:  NONE
;USED:  ALL
;***********************************

POLL:
        RTS

;************************************

;************************************
;*      General Subroutines
;*
;*
;*
;************************************

EXIT:   BCS     ERRXIT
        LDA     #0              ;NO ERRORS
        RTS

ERRXIT:
        TAY
        BNE     RET             ;IF A <> 0 THEN RETURN
                                ; THE SUBROUTINES ERROR CODE
ERROR:
        LDA     #0FFH
RET:    RTS

;SET THE TRACK AND SSD "BLOCK" #
SETUP:
        LDY     #OCURTRK
        LDA     (PAGE0W0),Y             ;GET TRACK IN A
        LDX     #00
        STX     FLAG16K                 ;CLEAR 16K FLAG

        CMP     #16                     ;TRACK >= 16 ?
        BCS     $1
        LDY     #02                     ;IT WILL BE IN SYNETIX BLOCK 1
        JMP     SETDONE

$1:     CMP     #32                     ;TRACK >= 32 ?
        BCS     $2
        SEC                             ;TRACK 16-31
        SBC     #16                     ;GET TRACK OFFSET WITHIN BLOCK
        LDY     #03                     ;IT WILL BE BLOCK 2
        JMP     SETDONE

$2:     CMP     #36                     ;TRACK >= 36 ?

        .IF     SIZE144
        BCS     SETEND                  ;ERROR FOR SMALL DISK
        .ELSE
        BCS     $3
        .ENDC

        SEC                             ;TRACK 32-35
        SBC     #32                     ;GET TRACK OFFSET WITHIN BLOCK
        LDY     #04                     ;IT'S BLOCK 3
        INC     FLAG16K                 ;SET 16K BLOCK RD/WR FLAG
        JMP     SETDONE

$3:     CMP     #52                     ;TRACK >= 52 ?
        BCS     $4
        SEC                             ;TRACK 36-51
        SBC     #36                     ;GET TRACK OFFSET WITHIN BLOCK
        LDY     #05                     ;IT'S BLOCK 4
        JMP     SETDONE

$4:     CMP     #68                     ;TRACK >= 68 ?
        BCS     $5
        SEC                             ;TRACK 52-67
        SBC     #52                     ;GET TRACK OFFSET WITHIN BLOCK
        LDY     #06                     ;IT'S BLOCK 5
        JMP     SETDONE

$5:     CMP     #72                     ;TRACK >= 72 ?
        BCS     SETEND                  ;MUST BE AN ERROR, RETURN...
        SEC                             ;TRACK 68-71
        SBC     #68                     ;GET TRACK OFFSET WITHIN BLOCK
        LDY     #07                     ;IT'S BLOCK 6
        INC     FLAG16K                 ;SET 16K BLOCK RD/WR FLAG


;A HAS TRACK OFFSET WITHIN SSD "BLOCK", Y HAS SLOT I/O BLOCK OFFSET
;TO ADDRESS WHERE THE DATA WILL BE R/W FROM/TO.

SETDONE:
        ASL     A
        ASL     A                       ;SINCE EACH TRACK IS 4K BYTES, OR
        ASL     A                       ;16 PAGES....
        ASL     A                       ;MULTIPLY FOR PAGE OFFSET WITHIN BLOCK
        TAX                             ;HIDE A

;PATCH BLOCK ADDRESS INTO THE R/W TRANSFER ROUTINE
        TYA                             ;GET OFFSET IN A
        ADC     SLTBASE                 ;ADD SLOT I/O BASE ADDRESS
        STA     C0XXA+1                 ;SET LOW BYTE OF POINTERS IN COMMON
        STA     C0XXB+1                 ;READ / WRITE ROUTINE

;SET THE SECTOR
        LDY     #OCURSEC
        LDA     (PAGE0W0),Y             ;GET SECTOR NUMBER
        CMP     #16
        BCS     SETEND                  ;ERROR IF >= 16
        TXA                             ;RESTORE A
        ADC     (PAGE0W0),Y             ;ADD SECTOR#, YIELDING PAGE OFFSET FOR
                                        ;READ / WRITE TRANSFER
        STA     PAGENO                  ;STORE IT FOR USE LATER

;SET THE DMA ADDRESS
        LDY     #OCURDMA+1              ;GET OFFSET TO DMA ADDRESS HI-BYTE
        LDA     (PAGE0W0),Y             ;GET THE HI-BYTE
        STA     RWDMA+1                 ;STORE IN HI-BYTE OF OUR PAGE0 VAR
        DEY                             ;DO THE SAME FOR THE LO-BYTE...
        LDA     (PAGE0W0),Y
        STA     RWDMA

SETEND: RTS

;SAVE AND RESTORE THE PAGE 0 VARIABLES WHICH WILL BE USED BY US
SAVELOCS:
        LDA     RWDMA
        STA     ZEROLOCS
        LDA     RWDMA+1
        STA     ZEROLOCS+1
        RTS

RESTLOCS:
        LDA     ZEROLOCS
        STA     RWDMA
        LDA     ZEROLOCS+1
        STA     RWDMA+1
        RTS

;A HUGE DEBT OF GRATITUDE IS OWED TO FRED MEYER FOR THE FOLLOWING CODE,
;BORROWED FROM HIS MONCALL.A65 DEVICE DRIVER! IT SEEMS THAT APPLE ROM
;ROUTINES ARE NOT THE WAY TO HANDLE I/O FROM THE CONSOLE WHEN SFTVIDEO.DVR
;IS PRESENT. I KNEW THERE WAS A WAY TO CALL THE SFTVIDEO ROUTINES FROM THE
;6502 SIDE OF THE FENCE, BUT WINK'S DOCUMENTATION (NEVER VERY WORDY!) WAS
;JUST A BIT TERSE ON THIS SUBJECT. AFTER SPENDING AN ENTIRE EVENING ATTEMPTING
;TO RE-INVENT THE WHEEL, I STUMBLED UPON THIS. THANKS FRED!!!!
;                                               SH.

SETVECTOR:                      ;ENTRY=NONE  ..  SETS INDIRECT JUMP VARIABLE
                                ;TO CHARACTER OUTPUT ROUTINE OF DEVICE #3.
        LDY     #@1WCDEV+(8*(CONDEV-16))
        LDA     (SYSP1),Y       ;GET LO BYTE OF WRITE VECTOR FOR CONDEV
        STA     CONOUT
        INY
        LDA     (SYSP1),Y       ;GET HI BYTE OF WRITE VECTOR FOR CONDEV
        STA     CONOUT+1
        LDY     #@1RCDEV+(8*(CONDEV-16))
        LDA     (SYSP1),Y       ;GET LO BYTE OF READ VECTOR FOR CONDEV
        STA     CONIN
        INY
        LDA     (SYSP1),Y       ;GET HI BYTE OF READ VECTOR FOR CONDEV
        STA     CONIN+1

APPLEOUT:                       ;ON ENTRY A=CHARACTER FOR DISPLAY
        STA     CONDAT          ;SAVE DATA
        TXA
        PHA                     ;SAVE X
        TYA
        PHA                     ;SAVE Y
        LDA     CONDAT          ;RESTORE DATA
        JSR     SENDIT          ;SEND CHAR TO THE CONSOLE DEVICE
        PLA
        TAY                     ;RESTORE Y
        PLA
        TAX                     ;RESTORE X
        RTS

SENDIT: LDY     #(CONDEV-16)*10H        ;Y REGISTER SETUP
        LDX     #(CONDEV-16)+0C0H       ;X REGISTER SETUP
        JMP     (CONOUT)                ;SEND CHAR TO THE CONSOLE DEVICE

APPLEIN:                ;LINEFEEDS ARE IGNORED
        TXA
        PHA                     ;SAVE X
        TYA
        PHA                     ;SAVE Y
$1:     JSR     RECVIT          ;GET CHAR FROM CONSOLE DEVICE
        CMP     #0AH            ;LINEFEED ?
        BEQ     $1              ;YES..IGNORE & WAIT FOR ANOTHER CHAR
        STA     CONDAT          ;SAVE CHAR
        PLA
        TAY                     ;RESTORE Y
        PLA
        TAX                     ;RESTORE X
        LDA     CONDAT          ;RESTORE CHAR
        RTS

RECVIT:
        LDY     #(CONDEV-16)*10H        ;Y REGISTER SETUP
        LDX     #(CONDEV-16)+0C0H       ;X REGISTER SETUP
        JMP     (CONIN)                 ;GET CHAR FROM THE CONSOLE DEVICE
;
;DATA AREA
;

IDX:    .BLOCK  1               ;TEMPORARY
CNT:    .BLOCK  1               ;TEMPORARY
FLAG16K:
        .BLOCK  1               ;READ / WRITE 16K BLOCK IF = 01
RWFLAG: .BYTE   00              ;WRITE = 1, READ = 0
PAGENO: .BYTE   00              ;PAGE OFFSET FOR READ / WRITE IN SSD
ZEROLOCS:
        .BLOCK  2               ;STORAGE FOR PAGE 0 VARIABLES

;DUMMY DIRECTORY ENTRY FOR RAMDISK INITIALIZATION
RAMID:  .BYTE   0FH,"RAMDISK ","I"+80H,"D"+80H," ",0,0,0,0
        .BYTE   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

SLTBASE:
        .BYTE   00              ;INITIALIZE STORES SLOT * 16 HERE
SLOTNO: .BYTE   00              ;SSD SLOT USED, WILL QUERY FOR INPUT
                                ;ON COLD BOOT IF ZERO. PRESET OTHERWISE...

CONIN:  .BLOCK  2               ;VECTORS FOR APPLICARD CONSOLE DEVICE
CONOUT: .BLOCK  2
CONDAT: .BLOCK  1               ;STORE I/O CHARACTER

;NOTE: THE BACKSPACE CHARACTER AND THE EXTRA SPACE BEFORE THE MESSAGE
;WERE "KLUDGES" WHICH WERE NECESSARY TO GET A CLEAN DISPLAY ON BOTH
;APPLE IIE 80-COLUMN CARDS AND THE VIDEX ULTRATERM. IT SHOULD ALSO
;WORK O.K. WITH ANY 80-COLUMN CARD RECOGNIZED BY SFTVIDEO.DVR.

MESSAGE:
        .BYTE   33,08H," ENTER SLOT FOR SSD CARD (1-7): "

ENDDRVR:

        .END
