/*********************************************************************
 *                                                                   *
 *                     XGS : Apple IIGS Emulator                     *
 *                                                                   *
 *        Written and Copyright (C)1996 by Joshua M. Thompson        *
 *                                                                   *
 *  You are free to distribute this code for non-commercial purposes *
 * I ask only that you notify me of any changes you make to the code *
 *     Commercial use is prohibited without my written permission    *
 *                                                                   *
 *********************************************************************/

/*
 * File: arch/win32/snd-drv.c
 *
 * DirectSound driver for Windows 95 or NT 4.0 w/Service Pack 3
 * By Ian Schmidt (irsman@iag.net).
 *
 * Driver version 1.1 (October 6, 1997).
 *
 */

#include "xgs.h"

#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#ifdef HAVE_FCNTL_H
#include <fcntl.h>
#endif
#include "sound.h"
#include "snd-drv.h"

#include <cguid.h>
#include "dsound.h"

LPDIRECTSOUND lpDS;			// DirectSound COM object
LPDIRECTSOUNDBUFFER lpPDSB;	// Primary DirectSound buffer
LPDIRECTSOUNDBUFFER lpSecB;	// Secondary DirectSound buffer

int soundbuffer;
int inited = 0;
int dskick = 0;
long dsbpos = 0;

WORD prepbuff[OUTPUT_BUFFER_SIZE*2];

extern HWND	hWnd;

FILE *outfile;					// used for output to file test only


int SND_outputInit(int rate)
{
	DSBUFFERDESC	dsbuf;
	WAVEFORMATEX	format;

	// create a DirectSound COM object

	if (DS_OK != DirectSoundCreate(NULL, &lpDS, NULL))
	{
    	printf("Unable to create DirectSound object!\n");
		return(0);
	}

	// set cooperative level where we need it

	if (DS_OK != IDirectSound_SetCooperativeLevel(lpDS, GetForegroundWindow(), DSSCL_PRIORITY))
	{
    	printf("Unable to set cooperative level!\n");
		return(0);
	}

	// now create a primary sound buffer
	
	memset(&format, 0, sizeof(format));
	format.wFormatTag = WAVE_FORMAT_PCM;
	format.nChannels = 2;
	format.wBitsPerSample = 16;
	format.nSamplesPerSec = rate;
	format.nBlockAlign = format.nChannels*format.wBitsPerSample / 8;
	format.cbSize = 0;
	format.nAvgBytesPerSec = format.nSamplesPerSec*format.nBlockAlign;

	memset(&dsbuf, 0, sizeof(dsbuf));
	dsbuf.dwSize = sizeof(DSBUFFERDESC);
	dsbuf.dwFlags = DSBCAPS_PRIMARYBUFFER;
	dsbuf.dwBufferBytes = 0;
	dsbuf.lpwfxFormat = NULL;

	if (DS_OK != IDirectSound_CreateSoundBuffer(lpDS, &dsbuf, &lpPDSB, NULL))
	{
    	printf("Unable to create primary buffer!");
		return(0);		
	}

	// and set it's format how we want
	
	if (DS_OK != IDirectSoundBuffer_SetFormat(lpPDSB, &format))		
	{
    	printf("Unable to set primary buffer format!\n");
		return(0);
	}

	// start the primary buffer playing now so we get
	// minimal lag when we trigger our secondary buffer

	IDirectSoundBuffer_Play(lpPDSB, 0, 0, DSBPLAY_LOOPING);

	// that's done, now let's create our secondary buffer

    memset(&dsbuf, 0, sizeof(DSBUFFERDESC));
    dsbuf.dwSize = sizeof(DSBUFFERDESC);
	// we'll take default controls for this one
    dsbuf.dwFlags = DSBCAPS_CTRLDEFAULT; 
	// we'll take about 4 buffer chunks worth of sound
    dsbuf.dwBufferBytes = OUTPUT_BUFFER_SIZE*8;
    dsbuf.lpwfxFormat = (LPWAVEFORMATEX)&format;
	
	if (DS_OK != IDirectSound_CreateSoundBuffer(lpDS, &dsbuf, &lpSecB, NULL))
	{
    	printf("Unable to create secondary buffer\n");
		return(0);
	}

	// set the secondary buffer format

	IDirectSoundBuffer_SetFormat(lpSecB, &format);

	// ok, cool, we're ready to go!

	soundbuffer = 0;

//	outfile = fopen("mtout.raw", "wb+");

	dskick = 0;
	inited = 1;
	return(rate);
}

void SND_outputShutdown(void)
{
	inited = 0;

//	fclose(outfile);

	if (lpSecB)
	{
		IDirectSoundBuffer_Stop(lpSecB);
		IDirectSoundBuffer_Release(lpSecB);
		lpSecB = NULL;
	}

	if (lpPDSB)
	{
		IDirectSoundBuffer_Stop(lpPDSB);
		IDirectSoundBuffer_Release(lpPDSB);
		lpPDSB = NULL;
	}

    if (lpDS) 
    {
		IDirectSound_Release(lpDS);
		lpDS = NULL;
    }
}

size_t SND_outputWrite(snd_sample_struct *buffer, size_t len)
{
	unsigned char *wp1, *wp2;
	unsigned long ws1, ws2;
	HRESULT hr;
	long i;
	long pcurs, wcurs;

	if (!inited) return 0;

	if (len != OUTPUT_BUFFER_SIZE) 
	{
		return 0;
	}

	// check if we can write more yet: if DirectSound is playing
	// our double-buffer, see if it's in the half we want to write
	// to.  if so, bail for now.  if not, write away.

	if (dskick)
	{
		IDirectSoundBuffer_GetCurrentPosition(lpSecB, (void *)&pcurs, (void *)&wcurs);
		
		if (dsbpos)	// want to write to second half
		{
			if (pcurs > OUTPUT_BUFFER_SIZE*4)
			{
				return(0);	// not yet!
			}
		}
		else		// want to write to first half
		{
			if (pcurs < OUTPUT_BUFFER_SIZE*4)
			{
				return(0);
			}
		}
	}

// now prepare the samples into the output format

	for (i=0; i<OUTPUT_BUFFER_SIZE; i++)
	{
		prepbuff[i*2] = (WORD)(buffer[i].left >> 2);
		prepbuff[(i*2)+1] = (WORD)(buffer[i].right >> 2);
	}

 	hr = IDirectSoundBuffer_Lock(lpSecB, dsbpos, OUTPUT_BUFFER_SIZE*4, &wp1, &ws1, &wp2, &ws2, 0);

	dsbpos += OUTPUT_BUFFER_SIZE*4;
	if (dsbpos >= OUTPUT_BUFFER_SIZE*8)
	{
		dsbpos = 0;
	}
	
	if (hr != DS_OK)
	{
		printf("DirectSound lock error!\n");
		return(0);
	}

	CopyMemory(wp1, &prepbuff[0], ws1);
	if (wp2 != NULL)
	{
		CopyMemory(wp2, &prepbuff[ws1>>1], ws2);
	}

	IDirectSoundBuffer_Unlock(lpSecB, wp1, ws1, wp2, ws2);

	// start DirectSound playing after first buffer chunk written
	
	if (dskick == 0)
	{
		dskick++;
		IDirectSoundBuffer_SetCurrentPosition(lpSecB, 0);
		IDirectSoundBuffer_Play(lpSecB, 0, 0, DSBPLAY_LOOPING);
//		IDirectSoundBuffer_SetFrequency(lpSecB, 34000);	// no idea why, but this makes the pitch sound right =)
	}

	return(OUTPUT_BUFFER_SIZE);
}
// -P-
