
/*********************************************************************
 *																																	 *
 *										 XGS : Apple IIGS Emulator										 *
 *																																	 *
 *				Written and Copyright (C)1996 by Joshua M. Thompson				*
 *																																	 *
 *	You are free to distribute this code for non-commercial purposes *
 * I ask only that you notify me of any changes you make to the code *
 *		 Commercial use is prohibited without my written permission		*
 *																																	 *
 *********************************************************************/

/*
 * File: super.c
 *
 * Contains the routines responsible for managing the super high-res
 * graphics page.
 */

#include "xgs.h"
#include "video.h"
#include "vid-drv.h"

void VID_refreshSuperHires()
{
	register byte	v,scb;
	register PIXEL	*scrn,*scrn2;
	register int	a,palette,pixel,lastpixel;
	register int	line_changed;
	register int	row,col,fillmode;

	register int	rowTimes2;
	register int	colTimes4;
	register PIXEL	*vidLinesRowTimes2;
	register PIXEL	*vidLinesRowTimes2Plus1;

	register int	myvidpixel;

	VID_outputSetSuperColors();

	lastpixel = 0;
	for (row = 0 ; row < 200 ; row++) {
		scb = slow_memory[0x019D00 + row];
		fillmode = ((scb & 0x20) == 0x20);

		line_changed = (mem_slowram_changed[0x019D] &
				mem_change_masks[row]) || fillmode;

		rowTimes2 = row*2;
		palette = (scb & 0x0F) << 4;

		vidLinesRowTimes2 = vid_lines[rowTimes2];
		vidLinesRowTimes2Plus1 = vid_lines[rowTimes2+1];

		if (scb & 0x80) {
			for (col = 0 ; col < 160 ; col++) {
				a = 0x012000 + (row * 160) + col;
				if (line_changed ||
						(mem_slowram_changed[a >> 8] &
						 mem_change_masks[a & 0xFF])) {

					colTimes4 = col*4;

					v = slow_memory[a];
					scrn = vidLinesRowTimes2 + (colTimes4);
					scrn2 = vidLinesRowTimes2Plus1 + (colTimes4);
#ifndef WORDS_BIGENDIAN
					pixel = (v & 0x03) + palette + 12;
					myvidpixel = (pixel << 24);

					pixel = ((v >> 2) & 0x03) + palette + 8;
					myvidpixel |= (pixel << 16);

					pixel = ((v >> 4) & 0x03) + palette + 4;
					myvidpixel |= (pixel << 8);

					pixel = (v >> 6) + palette;
					myvidpixel |= pixel;
#else /* WORDS_BIGENDIAN */
					pixel = (v & 0x03) + palette + 12;
					myvidpixel = pixel;

					pixel = ((v >> 2) & 0x03) + palette + 8;
					myvidpixel |= (pixel << 8);

					pixel = ((v >> 4) & 0x03) + palette + 4;
					myvidpixel |= (pixel << 16);

					pixel = (v >> 6) + palette;
					myvidpixel |= (pixel << 24);
#endif /* WORDS_BIGENDIAN */
					*((int *)scrn) = *((int *)scrn2) = myvidpixel;
					if (vid_xmin > colTimes4)
						vid_xmin = colTimes4;
					if (vid_xmax < (colTimes4+4))
						vid_xmax = (colTimes4+4);
					if (vid_ymin > rowTimes2)
						vid_ymin = rowTimes2;
					if (vid_ymax < (rowTimes2+2))
						vid_ymax = rowTimes2+2;
				}
			}
		} else {
			for (col = 0 ; col < 160 ; col++) {
				a = 0x012000 + (row * 160) + col;
				if (line_changed ||
						(mem_slowram_changed[a >> 8] &
						 mem_change_masks[a & 0xFF])) {

					colTimes4 = col*4;

					v = slow_memory[a];
					scrn = vidLinesRowTimes2 + (colTimes4);
					scrn2 = vidLinesRowTimes2Plus1 + (colTimes4);
#ifndef WORDS_BIGENDIAN
					pixel = v >> 4;
					if (fillmode && !pixel)
						pixel = lastpixel;
					lastpixel = pixel;
					pixel += palette;

					myvidpixel = (pixel << 8);
					myvidpixel |= pixel;

					pixel = v & 0x0F;
					if (fillmode && !pixel)
						pixel = lastpixel;
					lastpixel = pixel;
					pixel += palette;

					myvidpixel |= (pixel << 24);
					myvidpixel |= (pixel << 16);
#else /* WORDS_BIGENDIAN */
					pixel = v >> 4;
					if (fillmode && !pixel)
						pixel = lastpixel;
					else
						lastpixel = pixel;
					pixel += palette;

					myvidpixel = (pixel << 16);
					myvidpixel |= (pixel << 24);

					pixel = v & 0x0F;
					if (fillmode && !pixel)
						pixel = lastpixel;
					else
						lastpixel = pixel;
					pixel += palette;

					myvidpixel |= pixel;
					myvidpixel |= (pixel << 8);
#endif /* WORDS_BIGENDIAN */
					*((int *)scrn) = *((int *)scrn2) = myvidpixel;

					if (vid_xmin > colTimes4)
						vid_xmin = colTimes4;
					if (vid_xmax < (colTimes4+4))
						vid_xmax = (colTimes4+4);
					if (vid_ymin > rowTimes2)
						vid_ymin = rowTimes2;
					if (vid_ymax < (rowTimes2+2))
						vid_ymax = rowTimes2+2;
				}
			}
		}
	}
	for (a = 0x0120 ; a < 0x019E ; a++) mem_slowram_changed[a] = 0;
}
