typedef unsigned char	byte;		/* used for 8-bit values  */
typedef unsigned short	word;		/* used for 16-bit values */
typedef unsigned long	address;	/* used for 24-bit values */

typedef signed char	offset_s;	/* short offset           */
typedef signed short	offset_l;	/* long offset            */

/* Union definition of a 16-bit value that can also be */
/* accessed as its component 8-bit values. Useful for  */
/* registers, which change sized based on teh settings */
/* the M and X program status register bits.           */

typedef union {
#ifdef LSB_FIRST
	struct { byte	L,H; } B;
#else
	struct { byte	H,L; } B;
#endif
	word	W;
} dualw;

/* Same as above but for addresses. */

typedef union {
#ifdef LSB_FIRST
	struct { byte	L,H,B,Z; } B;
	struct { word	L,H; } W;
#else
	struct { byte	Z,B,H,L; } B;
	struct { word	H,L; } W;
#endif
	address	A;
} duala;

/* These are the core memory access macros used in the 65816 emulator. */
/* Set these to point to routines which handle your emulated machine's */
/* memory access (generally these routines will check for access to    */
/* memory-mapped I/O and things of that nature.)                       */

#define M_READ(a)
#define M_WRITE(a,v)

/* Set this macro to your emulator's "update" routine. Your update */
/* routine would probably do things like update hardware sprites,  */
/* and check for user keypresses. M65816_run() calls this routine  */
/* periodically to make sure the rest of your emulator gets time   */
/* to run.                                                         */

#define E_UPDATE()

/* Set the 65816 emulator's update period (the number of instructions	*/
/* executed between calls to the E_UPDATE routine.)			*/

void M65816_uperiod(int period);

/* Set the 65816 emulator's trace mode to off (0) or on (nonzero) */

void M65816_trace(int mode);

/* Send a reset to the 65816 emulator. You should do this at	*/
/* startup before you call M65816_run().			*/

void M65816_reset(void);

/* Send an abort to the 65816 emulator. */

void M65816_abort(void);

/* Send aa non-maskable interrupt to the 65816 emulator */

void M65816_nmi(void);

/* Send a standard (maskable) interrupt to the 65816 emulator */

void M65816_irq(void);

/* This routine never returns; it sits in a loop processing opcodes */
/* until the emulator exits. Periodic calls to the emulator update  */
/* macro are made to allow the rest of the emulator to function.    */

void M65816_run(void);
