/*********************************************************************
 *                                                                   *
 *                     XGS : Apple IIGS Emulator                     *
 *                                                                   *
 *        Written and Copyright (C)1996 by Joshua M. Thompson        *
 *                                                                   *
 *  You are free to distribute this code for non-commercial purposes *
 * I ask only that you notify me of any changes you make to the code *
 *     Commercial use is prohibited without my written permission    *
 *                                                                   *
 *********************************************************************/

/*
 * File: vid-switches.c
 *
 * Contains the video soft switches and the routines responsible for
 * reading/writing them.
 */

#include "xgs.h"
#include "video.h"

int	vid_currmode;

int	vid_super;
int	vid_linear;
int	vid_a2mono;

int	vid_80col;
int	vid_altcharset;
int	vid_text;
int	vid_mixed;
int	vid_page2;
int	vid_hires;
int	vid_dblres;

byte VID_clear80col(byte val)
{
	vid_80col = 0;
	VID_newMode();
	return 0;
}

byte VID_set80col(byte val)
{
	vid_80col = 1;
	VID_newMode();
	return 0;
}

byte VID_get80col(byte val)
{
	return vid_80col? 0x80 : 0x00;
}

byte VID_clearAltCh(byte val)
{
	vid_altcharset = 0;
	VID_newMode();
	return 0;
}

byte VID_setAltCh(byte val)
{
	vid_altcharset = 1;
	VID_newMode();
	return 0;
}

byte VID_getAltCh(byte val)
{
	return vid_altcharset? 0x80 : 0x00;
}

byte VID_getColorReg(byte val)
{
	return (vid_textcolor[1] << 4) | vid_textcolor[0];
}

byte VID_setColorReg(byte val)
{
	vid_textcolor[1] = (val >> 4) & 0x0F;
	vid_textcolor[0] = val & 0x0F;
	mem_slowram_changed[0x0004] = 0xFFFFFFFF;
	mem_slowram_changed[0x0005] = 0xFFFFFFFF;
	mem_slowram_changed[0x0006] = 0xFFFFFFFF;
	mem_slowram_changed[0x0007] = 0xFFFFFFFF;
	mem_slowram_changed[0x0008] = 0xFFFFFFFF;
	mem_slowram_changed[0x0009] = 0xFFFFFFFF;
	mem_slowram_changed[0x000A] = 0xFFFFFFFF;
	mem_slowram_changed[0x000B] = 0xFFFFFFFF;
	VID_newMode();
	return 0;
}

byte VID_getNewVideo(byte val)
{
	val = 0x01;
	if (vid_super) val |= 0x80;
	if (vid_linear) val |= 0x40;
	if (vid_a2mono) val |= 0x20;
	return val;
}

byte VID_setNewVideo(byte val)
{
	vid_super = (val & 0x80)? 1:0;
	vid_linear = (val & 0x40)? 1:0;
	vid_a2mono = (val & 0x20)? 1:0;
	VID_newMode();
	return 0;
}

byte VID_getBorder(byte val)
{
	return vid_bordercolor;
}

byte VID_setBorder(byte val)
{
	if (vid_bordercolor == val) return 0;
	vid_bordercolor = val;
	VID_drawBorder();
	return 0;
}

byte VID_clearText(byte val)
{
	vid_text = 0;
	VID_newMode();
	return 0;
}

byte VID_setText(byte val)
{
	vid_text = 1;
	VID_newMode();
	return 0;
}

byte VID_getText(byte val)
{
	return vid_text? 0x80 : 0x00;
}

byte VID_clearMixed(byte val)
{
	vid_mixed = 0;
	VID_newMode();
	return 0;
}

byte VID_setMixed(byte val)
{
	vid_mixed = 1;
	VID_newMode();
	return 0;
}

byte VID_getMixed(byte val)
{
	return vid_mixed? 0x80 : 0x00;
}

byte VID_clearPage2(byte val)
{
	vid_page2 = 0;
	if(mem_80store) {
		MEM_rebuildMainMem();
	} else {
		VID_newMode();
	}
	return 0;
}

byte VID_setPage2(byte val)
{
	vid_page2 = 1;
	if(mem_80store) {
		MEM_rebuildMainMem();
	} else {
		VID_newMode();
	}
	return 0;
}

byte VID_getPage2(byte val)
{
	return vid_page2? 0x80 : 0x00;
}

byte VID_clearHires(byte val)
{
	vid_hires = 0;
	VID_newMode();
	return 0;
}

byte VID_setHires(byte val)
{
	vid_hires = 1;
	VID_newMode();
	return 0;
}

byte VID_getHires(byte val)
{
	return vid_hires? 0x80 : 0x00;
}

byte VID_clearDblRes(byte val)
{
	vid_dblres = 0;
	VID_newMode();
	return 0;
}

byte VID_setDblRes(byte val)
{
	vid_dblres = 1;
	VID_newMode();
	return 0;
}
