/*********************************************************************
 *                                                                   *
 *                     XGS : Apple IIGS Emulator                     *
 *                                                                   *
 *        Written and Copyright (C)1996 by Joshua M. Thompson        *
 *                                                                   *
 *  You are free to distribute this code for non-commercial purposes *
 * I ask only that you notify me of any changes you make to the code *
 *     Commercial use is prohibited without my written permission    *
 *                                                                   *
 *********************************************************************/

/*
 * File: super.c
 *
 * Contains the routines responsible for managing the super high-res
 * graphics page.
 */

#include "xgs.h"
#include "video.h"

word	vid_old_super_palettes[16][16];

PIXEL	vid_super_palettes[16][16];

XColor	vid_super_color = { 0, 0, 0, 0, DoRed | DoGreen | DoBlue };

void VID_refreshSuperHires()
{
	byte		*a,v,scb;
	word		*c,color;
	PIXEL		*scrn,*scrn2;
	int		pixel,lastpixel;
	register int	row,col,fillmode;

	lastpixel = 0;
	c = (word *) (slow_memory + 0x019E00);
	for (row = 0 ; row < 16 ; row++) {
		for (col = 0 ; col < 16 ; col++) {
			color = *c++;
			if (color != vid_old_super_palettes[row][col]) {
				vid_old_super_palettes[row][col] = color;
#ifdef LSB_FIRST
				vid_super_color.red = ((color >> 8) & 0x000F) * 4369;
				vid_super_color.green = ((color >> 4) & 0x000F)* 4369;
				vid_super_color.blue = (color & 0x000F) * 4369;
#else
				vid_super_color.red = (color & 0x000F) * 4369;
				vid_super_color.green = ((color >> 12) & 0x000F)* 4369;
				vid_super_color.blue = ((color >> 8) & 0x000F) * 4369;
#endif
				XAllocColor(vid_display,vid_colormap,&vid_super_color);
				vid_super_palettes[row][col] = vid_super_color.pixel;
			}
		}
	}
	scrn = vid_lines[40];
	scrn2 = vid_lines[41];
	a = slow_memory + 0x012000;
	for (row = 0 ; row < 200 ; row++) {
		scb = *(slow_memory + 0x019D00 + row);
		if (scb & 0x80) {
			for (col = 0 ; col < 160 ; col++) {
				v = *a++;
				pixel = v >> 6;
				*scrn++ = *scrn2++ = vid_super_palettes[scb & 0x0F][pixel];
				pixel = (v >> 4) & 0x03;
				*scrn++ = *scrn2++ = vid_super_palettes[scb & 0x0F][pixel+4];
				pixel = (v >> 2) & 0x03;
				*scrn++ = *scrn2++ = vid_super_palettes[scb & 0x0F][pixel+8];
				pixel = v & 0x03;
				*scrn++ = *scrn2++ = vid_super_palettes[scb & 0x0F][pixel+12];
			}
		} else {
			fillmode = scb & 0x20;
			for (col = 0 ; col < 160 ; col++) {
				v = *a++;
				pixel = v >> 4;
				if (fillmode && !pixel) pixel = lastpixel;
				lastpixel = pixel;
				*scrn++ = *scrn2++ = vid_super_palettes[scb & 0x0F][pixel];
				*scrn++ = *scrn2++ = vid_super_palettes[scb & 0x0F][pixel];
				pixel = v & 0x0F;
				if (fillmode && !pixel) pixel = lastpixel;
				lastpixel = pixel;
				*scrn++ = *scrn2++ = vid_super_palettes[scb & 0x0F][pixel];
				*scrn++ = *scrn2++ = vid_super_palettes[scb & 0x0F][pixel];
			}
		}
		scrn += VID_WIDTH;
		scrn2 += VID_WIDTH;
	}
}
