/*********************************************************************
 *                                                                   *
 *                     XGS : Apple IIGS Emulator                     *
 *                                                                   *
 *        Written and Copyright (C)1996 by Joshua M. Thompson        *
 *                                                                   *
 *  You are free to distribute this code for non-commercial purposes *
 * I ask only that you notify me of any changes you make to the code *
 *     Commercial use is prohibited without my written permission    *
 *                                                                   *
 *********************************************************************/

/*
 * File: lores.c
 *
 * Contains the routines responsible for managing the low-res
 * graphics pages 1 and 2 in both standard and double-resolution.
 */

#include "xgs.h"
#include "video.h"

/* No use duplicating this when we can borrow it from	*/
/* the text mode drivers!				*/

extern address vid_textbases1[24];
extern address vid_textbases2[24];

void VID_refreshLoresPage1()
{
	int	row,col,i,val,max;
	PIXEL	*scrn,top,btm;

	if (vid_mixed) {
		vid_80col? VID_refreshText80Page1() : VID_refreshText40Page1();
		max = 20;
	} else {
		max = 24;
	}

	for (row = 0 ; row < max ; row++) {
		for (col = 0 ; col < 40 ; col++) {
			scrn = vid_lines[(row * 16 + 48)] + (col * 14 + 40);
			val = *(slow_memory + vid_textbases1[row] + col);
			top = vid_textpalette[val & 0x0F];
			btm = vid_textpalette[val >> 4];
			for (i = 0 ; i < 8 ; i++) {
				*scrn++ = top;
				*scrn++ = top;
				*scrn++ = top;
				*scrn++ = top;
				*scrn++ = top;
				*scrn++ = top;
				*scrn++ = top;
				*scrn++ = top;
				*scrn++ = top;
				*scrn++ = top;
				*scrn++ = top;
				*scrn++ = top;
				*scrn++ = top;
				*scrn++ = top;
				scrn += (VID_WIDTH - 14);
			}
			for (i = 0 ; i < 8 ; i++) {
				*scrn++ = btm;
				*scrn++ = btm;
				*scrn++ = btm;
				*scrn++ = btm;
				*scrn++ = btm;
				*scrn++ = btm;
				*scrn++ = btm;
				*scrn++ = btm;
				*scrn++ = btm;
				*scrn++ = btm;
				*scrn++ = btm;
				*scrn++ = btm;
				*scrn++ = btm;
				*scrn++ = btm;
				scrn += (VID_WIDTH - 14);
			}
		}
	}
}

void VID_refreshLoresPage2()
{
	int	row,col,i,val,max;
	PIXEL	*scrn,top,btm;

	if (vid_mixed) {
		vid_80col? VID_refreshText80Page2() : VID_refreshText40Page2();
		max = 20;
	} else {
		max = 24;
	}

	for (row = 0 ; row < max ; row++) {
		for (col = 0 ; col < 40 ; col++) {
			scrn = vid_lines[(row * 16 + 48)] + (col * 14 + 40);
			val = *(slow_memory + vid_textbases1[row] + col);
			top = vid_textpalette[val & 0x0F];
			btm = vid_textpalette[val >> 4];
			for (i = 0 ; i < 8 ; i++) {
				*scrn++ = top;
				*scrn++ = top;
				*scrn++ = top;
				*scrn++ = top;
				*scrn++ = top;
				*scrn++ = top;
				*scrn++ = top;
				*scrn++ = top;
				*scrn++ = top;
				*scrn++ = top;
				*scrn++ = top;
				*scrn++ = top;
				*scrn++ = top;
				*scrn++ = top;
				scrn += (VID_WIDTH - 14);
			}
			for (i = 0 ; i < 8 ; i++) {
				*scrn++ = btm;
				*scrn++ = btm;
				*scrn++ = btm;
				*scrn++ = btm;
				*scrn++ = btm;
				*scrn++ = btm;
				*scrn++ = btm;
				*scrn++ = btm;
				*scrn++ = btm;
				*scrn++ = btm;
				*scrn++ = btm;
				*scrn++ = btm;
				*scrn++ = btm;
				*scrn++ = btm;
				scrn += (VID_WIDTH - 14);
			}
		}
	}
}

void VID_refreshDLoresPage1()
{
	int	row,col,i,val,max;
	PIXEL	*scrn,top,btm;

	if (vid_mixed) {
		vid_80col? VID_refreshText80Page1() : VID_refreshText40Page1();
		max = 20;
	} else {
		max = 24;
	}

	for (row = 0 ; row < max ; row++) {
		for (col = 0 ; col < 40 ; col++) {
			scrn = vid_lines[(row * 16 + 48)] + (col * 14 + 40);
			val = *(slow_memory + ((~col & 0x01) * 65536) + vid_textbases1[row] + (col >> 1));
			top = vid_textpalette[val & 0x0F];
			btm = vid_textpalette[val >> 4];
			for (i = 0 ; i < 8 ; i++) {
				*scrn++ = top;
				*scrn++ = top;
				*scrn++ = top;
				*scrn++ = top;
				*scrn++ = top;
				*scrn++ = top;
				*scrn++ = top;
				scrn += (VID_WIDTH - 7);
			}
			for (i = 0 ; i < 8 ; i++) {
				*scrn++ = btm;
				*scrn++ = btm;
				*scrn++ = btm;
				*scrn++ = btm;
				*scrn++ = btm;
				*scrn++ = btm;
				*scrn++ = btm;
				scrn += (VID_WIDTH - 7);
			}
		}
	}
}

void VID_refreshDLoresPage2()
{
	int	row,col,i,val,max;
	PIXEL	*scrn,top,btm;

	if (vid_mixed) {
		vid_80col? VID_refreshText80Page2() : VID_refreshText40Page2();
		max = 20;
	} else {
		max = 24;
	}

	for (row = 0 ; row < max ; row++) {
		for (col = 0 ; col < 40 ; col++) {
			scrn = vid_lines[(row * 16 + 48)] + (col * 14 + 40);
			val = *(slow_memory + ((~col & 0x01) * 65536) + vid_textbases2[row] + (col >> 1));
			top = vid_textpalette[val & 0x0F];
			btm = vid_textpalette[val >> 4];
			for (i = 0 ; i < 8 ; i++) {
				*scrn++ = top;
				*scrn++ = top;
				*scrn++ = top;
				*scrn++ = top;
				*scrn++ = top;
				*scrn++ = top;
				*scrn++ = top;
				scrn += (VID_WIDTH - 7);
			}
			for (i = 0 ; i < 8 ; i++) {
				*scrn++ = btm;
				*scrn++ = btm;
				*scrn++ = btm;
				*scrn++ = btm;
				*scrn++ = btm;
				*scrn++ = btm;
				*scrn++ = btm;
				scrn += (VID_WIDTH - 7);
			}
		}
	}
}
