/*********************************************************************
 *                                                                   *
 *                     XGS : Apple IIGS Emulator                     *
 *                                                                   *
 *        Written and Copyright (C)1996 by Joshua M. Thompson        *
 *                                                                   *
 *  You are free to distribute this code for non-commercial purposes *
 * I ask only that you notify me of any changes you make to the code *
 *     Commercial use is prohibited without my written permission    *
 *                                                                   *
 *********************************************************************/

/*
 * File: colors.c
 *
 * This file contains the color tables.
 */

#include "xgs.h"
#include "video.h"

XColor	vid_textcolors[16] = {
	{ 0, 0x0000, 0x0000, 0x0000, DoRed | DoGreen | DoBlue, 0 },
	{ 0, 0xDDDD, 0x0000, 0x3333, DoRed | DoGreen | DoBlue, 0 },
	{ 0, 0x0000, 0x0000, 0x9999, DoRed | DoGreen | DoBlue, 0 },
	{ 0, 0xDDDD, 0x2222, 0xDDDD, DoRed | DoGreen | DoBlue, 0 },
	{ 0, 0x0000, 0x7777, 0x2222, DoRed | DoGreen | DoBlue, 0 },
	{ 0, 0x5555, 0x5555, 0x5555, DoRed | DoGreen | DoBlue, 0 },
	{ 0, 0x2222, 0x2222, 0xFFFF, DoRed | DoGreen | DoBlue, 0 },
	{ 0, 0x6666, 0xAAAA, 0xFFFF, DoRed | DoGreen | DoBlue, 0 },
	{ 0, 0x8888, 0x5555, 0x0000, DoRed | DoGreen | DoBlue, 0 },
	{ 0, 0xFFFF, 0x6666, 0x0000, DoRed | DoGreen | DoBlue, 0 },
	{ 0, 0xAAAA, 0xAAAA, 0xAAAA, DoRed | DoGreen | DoBlue, 0 },
	{ 0, 0xFFFF, 0x9999, 0x8888, DoRed | DoGreen | DoBlue, 0 },
	{ 0, 0x0000, 0xDDDD, 0x0000, DoRed | DoGreen | DoBlue, 0 },
	{ 0, 0xFFFF, 0xFFFF, 0x0000, DoRed | DoGreen | DoBlue, 0 },
	{ 0, 0x5555, 0xFFFF, 0x9999, DoRed | DoGreen | DoBlue, 0 },
	{ 0, 0xFFFF, 0xFFFF, 0xFFFF, DoRed | DoGreen | DoBlue, 0 },
};

int	vid_bordercolor;
int	vid_textcolor[2];

PIXEL	vid_palette[16][16];
PIXEL	vid_textpalette[16];

void VID_allocTextColors()
{
	int	i;

	for (i = 0 ; i < 16 ; i++) {
		XAllocColor(vid_display, vid_colormap, &vid_textcolors[i]);
		vid_textpalette[i] = vid_textcolors[i].pixel;
	}
}

void VID_deallocTextColors()
{
	/* not needed now, just dispose of the whole private colormap */
}
