/*********************************************************************
 *                                                                   *
 *                     XGS : Apple IIGS Emulator                     *
 *                                                                   *
 *        Written and Copyright (C)1996 by Joshua M. Thompson        *
 *                                                                   *
 *  You are free to distribute this code for non-commercial purposes *
 * I ask only that you notify me of any changes you make to the code *
 *     Commercial use is prohibited without my written permission    *
 *                                                                   *
 *********************************************************************/

/*
 * File: unlockimg.c
 *
 * Write enables an XGS ".img" file.
 *
 * Usage: unlockimg file
 */

#include <xgs.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "disks.h"

xgs_image	image;

void main(int argc, char *argv[])
{
	FILE		*fp;

	if ((fp = fopen(argv[1],"r+")) == NULL) {
		perror("Can't open image file");
		exit(1);
	}

	fread((void *) &image,1,sizeof(xgs_image),fp);

	if (strncmp(image.magic,"XGS!",4)) {
		printf("\nImage header is corrupt.\n");
		fclose(fp);
		exit(1);
	}

	if (image.version != 0x00) {
		printf("Unknown image format. Cannot continue.\n");
		fclose(fp);
		exit(1);
	}

	image.protected = 0;

	rewind(fp);
	fwrite((void *) &image,1,sizeof(xgs_image),fp);

	printf("Image unlocked.\n");
}
