/*********************************************************************
 *                                                                   *
 *                     XGS : Apple IIGS Emulator                     *
 *                                                                   *
 *        Written and Copyright (C)1996 by Joshua M. Thompson        *
 *                                                                   *
 *  You are free to distribute this code for non-commercial purposes *
 * I ask only that you notify me of any changes you make to the code *
 *     Commercial use is prohibited without my written permission    *
 *                                                                   *
 *********************************************************************/

/*
 * File: raw2img.c
 *
 * Create an XGS ".img" file from a raw dump of an Apple II disk, such
 * as the output of the Unix "dd" program.
 *
 * Usage: raw2img sourcefile destfile
 */

/*
 * It was pretty much completely ripped off of dc2img.c
 * by Chad Trost, give credit to whom ever you feel like. (Josh)
 */

#include <xgs.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "disks.h"

byte	block_buffer[512];

dd_header	ddimage;
xgs_image	image;

void swapWord(unsigned short *val)
{
	wswap	temp;
	byte	i;

	temp.W = *val;
	i = temp.B.B1;
	temp.B.B1 = temp.B.B2;
	temp.B.B2 = i;
	*val = temp.W;
}

void main(int argc, char *argv[])
{
	int		i;
	char		buffer[64],*cp;
	unsigned long	checksum;
	unsigned short	blocks;
	FILE		*fp1,*fp2;

	if ((fp1 = fopen(argv[1],"r")) == NULL) {
		perror("Can't open source file");
		exit(1);
	}

	if ((fp2 = fopen(argv[2],"w")) == NULL) {
		perror("Can't open source file");
		exit(1);
	}


	if(fseek(fp1, 0L, SEEK_END)) {
		perror("Can't fseek to the end of the source file");	
		exit(1);
	}
	
	ddimage.dataSize = ftell(fp1);
	rewind(fp1);

	printf("\nNeed dd image information:\n\n");

	printf("    Disk name : ");
	scanf("%s", buffer);

	printf("    Data size : %ld bytes\n",ddimage.dataSize);

	bzero((void *) &image,sizeof(image));

	blocks = ddimage.dataSize / 512;
	printf("** Creating an XGS image file of %hd blocks.\n",blocks);

	image.magic[0] = 'X';
	image.magic[1] = 'G';
	image.magic[2] = 'S';
	image.magic[3] = '!';
	image.version = 0x00;
	image.protected = 1;
	image.num_blocks = blocks;

#ifndef LSB_FIRST
	swapWord(&image.num_blocks);
#endif

	cp = strdup(buffer);	/* save this in case we need it */

	printf("\nEnter a name for this image (1-32 chars) or RETURN to use DiskCopy name:\n");
	gets(buffer);
	if (strlen(buffer)) {
		strncpy(image.name,buffer,31);
		free(cp);
	} else {
		strncpy(image.name,cp,31);
	}

	fwrite(&image,1,sizeof(image),fp2);

	printf("\nCopying data: ");
	checksum = 0;
	for (i = 0 ; i < blocks ; i++) {
		fread(block_buffer,1,512,fp1);
		fwrite(block_buffer,1,512,fp2);
		printf(".");
		fflush(stdout);
	}

	fclose(fp1);
	fclose(fp2);
}
