/*********************************************************************
 *                                                                   *
 *                     XGS : Apple IIGS Emulator                     *
 *                                                                   *
 *        Written and Copyright (C)1996 by Joshua M. Thompson        *
 *                                                                   *
 *  You are free to distribute this code for non-commercial purposes *
 * I ask only that you notify me of any changes you make to the code *
 *     Commercial use is prohibited without my written permission    *
 *                                                                   *
 *********************************************************************/

/*
 * File: newimg.c
 *
 * Program to create a blank image file. Size is specified in KB
 *
 * Usage: newimg filename size 
 */

#include <xgs.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "disks.h"

byte	block_buffer[512];

xgs_image	image;

void swapWord(unsigned short *val)
{
	wswap	temp;
	byte	i;

	temp.W = *val;
	i = temp.B.B1;
	temp.B.B1 = temp.B.B2;
	temp.B.B2 = i;
	*val = temp.W;
}

void main(int argc, char *argv[])
{
	int		i,size;
	unsigned short	blocks;
	char		buffer[64];
	FILE		*fp;

	size = atoi(argv[2]);
	if ((size < 16) || (size > 32767)) {
		printf("Valid sizes are 16 KB to 32767 KB (32 MB)\n");
		exit(1);
	}

	if ((fp = fopen(argv[1],"w")) == NULL) {
		perror("Can't create output file");
		exit(1);
	}

	bzero((void *) &image,sizeof(image));

	blocks = (size * 2) + 1;
	printf("** Creating an XGS image file of %hd blocks.\n",blocks);

	image.magic[0] = 'X';
	image.magic[1] = 'G';
	image.magic[2] = 'S';
	image.magic[3] = '!';
	image.version = 0x00;
	image.protected = 0;
	image.num_blocks = blocks;

#ifndef LSB_FIRST
	swapWord(&image.num_blocks);
#endif

	printf("\nEnter a name for this image (1-32 chars):\n");
	gets(buffer);
	strncpy(image.name,buffer,31);

	fwrite(&image,1,sizeof(image),fp);

	printf("\nZeroing image data: ");

	bzero((void *) block_buffer,sizeof(block_buffer));

	for (i = 0 ; i < blocks ; i++) {
		fwrite(block_buffer,1,512,fp);
		if (!(i & 0xFF)) {
			printf(".");
			fflush(stdout);
		}
	}

	printf("\n\nDone.\n");
	fclose(fp);
}
