/*********************************************************************
 *                                                                   *
 *                     XGS : Apple IIGS Emulator                     *
 *                                                                   *
 *        Written and Copyright (C)1996 by Joshua M. Thompson        *
 *                                                                   *
 *  You are free to distribute this code for non-commercial purposes *
 * I ask only that you notify me of any changes you make to the code *
 *     Commercial use is prohibited without my written permission    *
 *                                                                   *
 *********************************************************************/

/*
 * File: imginfo.c
 *
 * Display information about an XGS ".img" file.
 *
 * Usage: imginfo file
 */

#include <xgs.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "disks.h"

xgs_image	image;

void swapWord(unsigned short *val)
{
	wswap	temp;
	byte	i;

	temp.W = *val;
	i = temp.B.B1;
	temp.B.B1 = temp.B.B2;
	temp.B.B2 = i;
	*val = temp.W;
}

void main(int argc, char *argv[])
{
	FILE		*fp;

	if ((fp = fopen(argv[1],"r")) == NULL) {
		perror("Can't open image file");
		exit(1);
	}

	fread((void *) &image,1,sizeof(xgs_image),fp);

#ifndef LSB_FIRST
	swapWord(&image.num_blocks);
#endif

	if (strncmp(image.magic,"XGS!",4)) {
		printf("\nImage header is corrupt.\n");
		fclose(fp);
		exit(1);
	}

	if (image.version != 0x00) {
		printf("Unknown image format. Cannot continue.\n");
		fclose(fp);
		exit(1);
	}

	printf("\nXGS image statistics:\n\n");

	printf("   Image name : %s\n",image.name);
	printf("No. of blocks : %hd\n",image.num_blocks);
	printf("Write Protect : ");
	if (image.protected) {
		printf("Enabled\n");
	} else {
		printf("Disabled\n");
	}

	printf("\nDescription   : \n%s\n",image.desc);

	printf("\n");

	fclose(fp);
}
