/*********************************************************************
 *                                                                   *
 *                     XGS : Apple IIGS Emulator                     *
 *                                                                   *
 *        Written and Copyright (C)1996 by Joshua M. Thompson        *
 *                                                                   *
 *  You are free to distribute this code for non-commercial purposes *
 * I ask only that you notify me of any changes you make to the code *
 *     Commercial use is prohibited without my written permission    *
 *                                                                   *
 *********************************************************************/

/*
 * File: snd-switches.c
 *
 * Code to handle reads/writes to the Sound GLU soft switches
 */

#include "xgs.h"
#include "sound.h"

byte	snd_registers[256];

int	snd_busy,snd_select,snd_auto,snd_vol;

word	snd_addr_reg;

byte SND_clickSpeaker(byte val)
{
#ifdef USS_SOUND
	static unsigned int	last_click = 0;

	if ((snd_dspfd != -1) && ((cpu_cycle_count - last_click) >= SND_SAMPLE_CYCLES)) {
		snd_click_buffer[snd_click_index++] = cpu_cycle_count;
		snd_click_index &= (SND_CLICK_BUFFER_SIZE-1);
		snd_click_count++;
		last_click = cpu_cycle_count;
	}
#endif
	return 0;
}

byte SND_readSoundCtl(byte val)
{
	val = 0x10;
	if (snd_busy) val |= 0x80;
	if (snd_select) val |= 0x40;
	if (snd_auto) val |= 0x20;
	return val;
}

byte SND_readSoundData(byte val)
{
	if (snd_select) {
		return snd_docram[snd_addr_reg];
	} else {
		switch(snd_addr_reg & 0xFF) {
			case 0xE0 :	return 0xC1;
			case 0xE1 :	return 0;
			default :	return snd_registers[snd_addr_reg & 0xFF];
		}
	}
}

byte SND_readSoundAddrL(byte val)
{
	return (snd_addr_reg & 0xFF);
}

byte SND_readSoundAddrH(byte val)
{
	return ((snd_addr_reg >> 8) & 0xFF);
}

byte SND_writeSoundCtl(byte val)
{
	snd_select = (val & 0x40)? 1 : 0;
	snd_auto = (val & 0x20)? 1 : 0;
	snd_vol = val & 0x0F;
	return 0;
}

byte SND_writeSoundData(byte val)
{
	if (snd_select) {
		snd_docram[snd_addr_reg] = val;
	} else {
		switch(snd_addr_reg & 0xFF) {
			case 0xE0 :
			case 0xE2 :	break;
			default :	snd_registers[snd_addr_reg & 0xFF] = val;
					break;
		}
	}
	return 0;
}

byte SND_writeSoundAddrL(byte val)
{
	snd_addr_reg = (snd_addr_reg & 0xFF00) | val;
	return 0;
}

byte SND_writeSoundAddrH(byte val)
{
	snd_addr_reg = (val << 8) | (snd_addr_reg & 0x00FF);
	return 0;
}
