/*********************************************************************
 *                                                                   *
 *                     XGS : Apple IIGS Emulator                     *
 *                                                                   *
 *        Written and Copyright (C)1996 by Joshua M. Thompson        *
 *                                                                   *
 *  You are free to distribute this code for non-commercial purposes *
 * I ask only that you notify me of any changes you make to the code *
 *     Commercial use is prohibited without my written permission    *
 *                                                                   *
 *********************************************************************/

/*
 * File: snd-main.c
 *
 * Sound initialization and core routines.
 */

#include "xgs.h"
#include "sound.h"

byte		*snd_docram;

unsigned long	*snd_click_buffer,snd_last_click;
int		snd_click_index,snd_click_outindex,snd_click_count;
byte		snd_last_click_sample;

byte		*snd_output_buffer;

int		snd_dspfd;

int SND_init()
{
#ifdef USS_SOUND
	long	parm;
#endif

	snd_dspfd = -1;

	printf("\nInitializing sound system\n");

	printf("    - Allocating Ensoniq DOC RAM (64 KB): ");
	if ((snd_docram = malloc(65536)) == NULL) {
		printf("Failed\n");
		return 1;
	}
	printf("Done\n");

	printf("    - Allocating Apple II sound RAM (%d KB): ",SND_CLICK_BUFFER_SIZE/1024);
	if ((snd_click_buffer = malloc(SND_CLICK_BUFFER_SIZE)) == NULL) {
		printf("Failed\n");
		return 0;
	}
	printf("Done\n");

	printf("    - Allocating sound output buffer (%d KB): ",SND_OUTPUT_BUFFER_SIZE/1024);
	if ((snd_output_buffer = malloc(SND_OUTPUT_BUFFER_SIZE)) == NULL) {
		printf("Failed\n");
		free(snd_click_buffer);
		return 0;
	}
	printf("Done\n");

#ifdef USS_SOUND
	printf("    - Opening & configuring sound device: ");
	if ((snd_dspfd = open(SND_DEVICE_NAME, O_WRONLY, 0)) == -1) {
		printf("Failed (can't open)\n");
		free(snd_output_buffer);
		free(snd_click_buffer);
		close(snd_dspfd);
		snd_dspfd = -1;
		return 0;
	}
	parm = AFMT_U8;
	if ((ioctl(snd_dspfd,SNDCTL_DSP_SETFMT,&parm) == -1) || (parm != AFMT_U8)) {
		printf("Failed (can't set sample mode)\n");
		free(snd_output_buffer);
		free(snd_click_buffer);
		close(snd_dspfd);
		snd_dspfd = -1;
		return 0;
	}
	parm = 1;
	if ((ioctl(snd_dspfd,SOUND_PCM_WRITE_CHANNELS,&parm) == -1) || (parm != 1)) {
		printf("Failed (can't set mono mode)\n");
		free(snd_output_buffer);
		free(snd_click_buffer);
		close(snd_dspfd);
		snd_dspfd = -1;
		return 0;
	}
	parm = SND_SAMPLE_RATE;
	if ((ioctl(snd_dspfd,SNDCTL_DSP_SPEED,&parm) == -1) || (parm != SND_SAMPLE_RATE)) {
		printf("Failed (can't set sample rate)\n");
		free(snd_output_buffer);
		free(snd_click_buffer);
		close(snd_dspfd);
		snd_dspfd = -1;
		return 0;
	}
	parm = 4;
	ioctl(snd_dspfd, SNDCTL_DSP_SUBDIVIDE, &parm);
	printf("Done)\n");
#endif

	snd_last_click_sample = 0;
	snd_last_click = 0;
	snd_click_index = 0;
	snd_click_outindex = 0;
	snd_click_count = 0;
	return 0;
}

void SND_update()
{
#ifdef USS_SOUND
	register int	i;

	snd_last_click = snd_click_buffer[snd_click_outindex] + 1;
	for (i = 0 ; i < (SND_SAMPLE_RATE/4) ; i++) {
		if ((snd_click_count) && (snd_last_click >= snd_click_buffer[snd_click_outindex])) {
			snd_last_click_sample ^= 0xFF;
			snd_click_outindex = (snd_click_outindex + 1) & (SND_CLICK_BUFFER_SIZE - 1);
			snd_click_count--;
		}
		snd_output_buffer[i] = snd_last_click_sample;
		snd_last_click += SND_SAMPLE_CYCLES;
	}
	write(snd_dspfd, (char *) snd_output_buffer, i);
#endif
}

void SND_reset()
{
}

void SND_shutdown()
{
#ifdef USS_SOUND
	printf("\nShutting down sound system\n");
	if (snd_dspfd != -1) {
		printf("    - Closing sound output device: ");
		close(snd_dspfd);
		snd_dspfd = -1;
		printf("Done\n");
	}
#endif
}
