/*********************************************************************
 *                                                                   *
 *                     XGS : Apple IIGS Emulator                     *
 *                                                                   *
 *        Written and Copyright (C)1996 by Joshua M. Thompson        *
 *                                                                   *
 *  You are free to distribute this code for non-commercial purposes *
 * I ask only that you notify me of any changes you make to the code *
 *     Commercial use is prohibited without my written permission    *
 *                                                                   *
 *********************************************************************/

/*
 * File: rw.c
 *
 * This is the top-level code for reading and writing bytes from
 * emulator RAM, calling the appropriate fault routines for accesses
 * to special memory areas.
 */

#include "xgs.h"
#include "emul.h"

unsigned long	mem_change_masks[256] = {
	0x00000001, 0x00000001, 0x00000001, 0x00000001, 0x00000001, 0x00000001, 0x00000001, 0x00000001,
	0x00000002, 0x00000002, 0x00000002, 0x00000002, 0x00000002, 0x00000002, 0x00000002, 0x00000002, 
	0x00000004, 0x00000004, 0x00000004, 0x00000004, 0x00000004, 0x00000004, 0x00000004, 0x00000004,
	0x00000008, 0x00000008, 0x00000008, 0x00000008, 0x00000008, 0x00000008, 0x00000008, 0x00000008,
	0x00000010, 0x00000010, 0x00000010, 0x00000010, 0x00000010, 0x00000010, 0x00000010, 0x00000010,
	0x00000020, 0x00000020, 0x00000020, 0x00000020, 0x00000020, 0x00000020, 0x00000020, 0x00000020,
	0x00000040, 0x00000040, 0x00000040, 0x00000040, 0x00000040, 0x00000040, 0x00000040, 0x00000040,
	0x00000080, 0x00000080, 0x00000080, 0x00000080, 0x00000080, 0x00000080, 0x00000080, 0x00000080,
	0x00000100, 0x00000100, 0x00000100, 0x00000100, 0x00000100, 0x00000100, 0x00000100, 0x00000100,
	0x00000200, 0x00000200, 0x00000200, 0x00000200, 0x00000200, 0x00000200, 0x00000200, 0x00000200,
	0x00000400, 0x00000400, 0x00000400, 0x00000400, 0x00000400, 0x00000400, 0x00000400, 0x00000400,
	0x00000800, 0x00000800, 0x00000800, 0x00000800, 0x00000800, 0x00000800, 0x00000800, 0x00000800,
	0x00001000, 0x00001000, 0x00001000, 0x00001000, 0x00001000, 0x00001000, 0x00001000, 0x00001000,
	0x00002000, 0x00002000, 0x00002000, 0x00002000, 0x00002000, 0x00002000, 0x00002000, 0x00002000,
	0x00004000, 0x00004000, 0x00004000, 0x00004000, 0x00004000, 0x00004000, 0x00004000, 0x00004000,
	0x00008000, 0x00008000, 0x00008000, 0x00008000, 0x00008000, 0x00008000, 0x00008000, 0x00008000,
	0x00010000, 0x00010000, 0x00010000, 0x00010000, 0x00010000, 0x00010000, 0x00010000, 0x00010000,
	0x00020000, 0x00020000, 0x00020000, 0x00020000, 0x00020000, 0x00020000, 0x00020000, 0x00020000,
	0x00040000, 0x00040000, 0x00040000, 0x00040000, 0x00040000, 0x00040000, 0x00040000, 0x00040000,
	0x00080000, 0x00080000, 0x00080000, 0x00080000, 0x00080000, 0x00080000, 0x00080000, 0x00080000,
	0x00100000, 0x00100000, 0x00100000, 0x00100000, 0x00100000, 0x00100000, 0x00100000, 0x00100000,
	0x00200000, 0x00200000, 0x00200000, 0x00200000, 0x00200000, 0x00200000, 0x00200000, 0x00200000,
	0x00400000, 0x00400000, 0x00400000, 0x00400000, 0x00400000, 0x00400000, 0x00400000, 0x00400000,
	0x00800000, 0x00800000, 0x00800000, 0x00800000, 0x00800000, 0x00800000, 0x00800000, 0x00800000,
	0x01000000, 0x01000000, 0x01000000, 0x01000000, 0x01000000, 0x01000000, 0x01000000, 0x01000000,
	0x02000000, 0x02000000, 0x02000000, 0x02000000, 0x02000000, 0x02000000, 0x02000000, 0x02000000,
	0x04000000, 0x04000000, 0x04000000, 0x04000000, 0x04000000, 0x04000000, 0x04000000, 0x04000000,
	0x08000000, 0x08000000, 0x08000000, 0x08000000, 0x08000000, 0x08000000, 0x08000000, 0x08000000,
	0x10000000, 0x10000000, 0x10000000, 0x10000000, 0x10000000, 0x10000000, 0x10000000, 0x10000000,
	0x20000000, 0x20000000, 0x20000000, 0x20000000, 0x20000000, 0x20000000, 0x20000000, 0x20000000,
	0x40000000, 0x40000000, 0x40000000, 0x40000000, 0x40000000, 0x40000000, 0x40000000, 0x40000000,
	0x80000000, 0x80000000, 0x80000000, 0x80000000, 0x80000000, 0x80000000, 0x80000000, 0x80000000,
};

unsigned long	mem_slowram_changed[512];

byte MEM_readMem(address addr)
{
	word	page;
	byte	offset;
	word	flags;
	
	page = addr >> 8;
	offset = addr;
	flags = mem_pages[page].readFlags;
	if (flags & MEM_FLAG_INVALID) return 0;
	if (flags & MEM_FLAG_IO) return MEM_ioReadFaultHandler(offset);
	return *(mem_pages[page].readPtr + offset);
	return 0xEA;
}

void MEM_writeMem(address addr, byte val)
{
	word	page;
	byte	offset;
	word	flags;
	
	page = addr >> 8;
	offset = addr;
	flags = mem_pages[page].writeFlags;
	if (flags & MEM_FLAG_INVALID) return;
	if (flags & MEM_FLAG_IO) {
		MEM_ioWriteFaultHandler(offset,val);
		return;
	}
	if ((page >= 0xE000) && (page < 0xE200)) {
		if (*(mem_pages[page].writePtr + offset) != val) {
			mem_slowram_changed[page & 0x1FF] |= mem_change_masks[offset];
			*(mem_pages[page].writePtr + offset) = val;
		}
		return;
	}
	*(mem_pages[page].writePtr + offset) = val;
	if (flags & MEM_FLAG_SHADOW_E0) {
		page = (page & 0xFF) + 0xE000;
		if (*(mem_pages[page].writePtr + offset) != val) {
			mem_slowram_changed[page & 0x1FF] |= mem_change_masks[offset];
			*(mem_pages[page].writePtr + offset) = val;
		}
	}
	if (flags & MEM_FLAG_SHADOW_E1) {
		page = (page & 0xFF) + 0xE100;
		if (*(mem_pages[page].writePtr + offset) != val) {
			mem_slowram_changed[page & 0x1FF] |= mem_change_masks[offset];
			*(mem_pages[page].writePtr + offset) = val;
		}
	}
}
