/*********************************************************************
 *                                                                   *
 *                     XGS : Apple IIGS Emulator                     *
 *                                                                   *
 *        Written and Copyright (C)1996 by Joshua M. Thompson        *
 *                                                                   *
 *  You are free to distribute this code for non-commercial purposes *
 * I ask only that you notify me of any changes you make to the code *
 *     Commercial use is prohibited without my written permission    *
 *                                                                   *
 *********************************************************************/

/*
 * File: mem-switches.c
 *
 * Contains all of the memory-related softswitches, and the routines
 * for manipulating them.
 */

#include "xgs.h"
#include "adb.h"
#include "emul.h"
#include "video.h"

int	mem_ramsize;

int	mem_shadow_text;
int	mem_shadow_hires1;
int	mem_shadow_hires2;
int	mem_shadow_super;
int	mem_shadow_aux;
int	mem_shadow_lc;

int	mem_slot_reg[8];

int	mem_lcbank2;
int	mem_lcread;
int	mem_lcwrite;
int	mem_lcsecond;

int	mem_auxrd;
int	mem_auxwrt;
int	mem_altzp;
int	mem_80store;

int	mem_diagtype;

byte	*slow_memory;
byte	*fast_memory;
byte	*rom_memory;

byte	junk_memory[256];

mem_pagestruct	mem_pages[65536];

byte MEM_clear80store(byte val)
{
	mem_80store = 0;
	MEM_rebuildMainMem();
	return 0;
}

byte MEM_set80store(byte val)
{
	mem_80store = 1;
	MEM_rebuildMainMem();
	return 0;
}

byte MEM_get80store(byte val)
{
	return mem_80store? 0x80 : 0x00;
}

byte MEM_clearAuxRd(byte val)
{
	mem_auxrd = 0;
	MEM_rebuildMainMem();
	return 0;
}

byte MEM_setAuxRd(byte val)
{
	mem_auxrd = 1;
	MEM_rebuildMainMem();
	return 0;
}

byte MEM_getAuxRd(byte val)
{
	return mem_auxrd? 0x80 : 0x00;
}

byte MEM_clearAuxWrt(byte val)
{
	mem_auxwrt = 0;
	MEM_rebuildMainMem();
	return 0;
}

byte MEM_setAuxWrt(byte val)
{
	mem_auxwrt = 1;
	MEM_rebuildMainMem();
	return 0;
}

byte MEM_getAuxWrt(byte val)
{
	return mem_auxwrt? 0x80 : 0x00;
}

byte MEM_clearAltZP(byte val)
{
	mem_altzp = 0;
	MEM_rebuildAltZpMem();
	return 0;
}

byte MEM_setAltZP(byte val)
{
	mem_altzp = 1;
	MEM_rebuildAltZpMem();
	return 0;
}

byte MEM_getAltZP(byte val)
{
	return mem_altzp? 0x80 : 0x00;
}

byte MEM_getLCbank(byte val)
{
	return mem_lcbank2? 0x80 : 0x00;
}

byte MEM_getLCread(byte val)
{
	return mem_lcread? 0x80 : 0x00;
}

byte MEM_getSlotReg(byte val)
{
	register int	i;

	val = 0;
	for (i = 7 ; i >= 0 ; i--) {
		val = val << 1;
		val |= mem_slot_reg[i];
	}
	return val;
}

byte MEM_setSlotReg(byte val)
{
	register int	i;

	val |= 0xE0;
	for (i = 0 ; i < 8 ; i++) {
		mem_slot_reg[i] = val & 0x01;
		val = val >> 1;
	}
	MEM_rebuildLangCardMem();
	return 0;
}

byte MEM_getShadowReg(byte val)
{
	val = 0;
	if (!mem_shadow_text) val |= 0x01;
	if (!mem_shadow_hires1) val |= 0x02;
	if (!mem_shadow_hires2) val |= 0x04;
	if (!mem_shadow_super) val |= 0x08;
	if (!mem_shadow_aux) val |= 0x10;
	if (!mem_shadow_lc) val |= 0x40;
	return val;
}

byte MEM_setShadowReg(byte val)
{
	mem_shadow_text = (val & 0x01)? 0 : 1;
	mem_shadow_hires1 = (val & 0x02)? 0 : 1;
	mem_shadow_hires2 = (val & 0x04)? 0 : 1;
	mem_shadow_super = (val & 0x08)? 0 : 1;
	mem_shadow_aux = (val & 0x10)? 0 : 1;
	mem_shadow_lc = (val & 0x40)? 0 : 1;
	MEM_rebuildLangCardMem();
	MEM_rebuildShadowMem();
	return 0;
}

byte MEM_getCYAReg(byte val)
{
	val = 0;
	if (emul_speed) val |= 0x80;
	return val;
}

byte MEM_setCYAReg(byte val)
{
	emul_speed = (val & 0x80)? 1 : 0;
	return 0;
}

byte MEM_getIntEnReg(byte val)
{
	val = 0;
	if (emul_qtrsecirq) val |= 0x10;
	if (emul_vblirq) val |= 0x08;
	if (adb_m2mouseswirq) val |= 0x04;
	if (adb_m2mousemvirq) val |= 0x02;
	if (adb_m2mouseenable) val |= 0x01;
	return val;
}

byte MEM_setIntEnReg(byte val)
{
	adb_m2mouseenable = (val & 0x01)? 1 : 0;
	adb_m2mousemvirq = (val & 0x02)? 1 : 0;
	adb_m2mouseswirq = (val & 0x04)? 1 : 0;
	emul_vblirq = (val & 0x08)? 1 : 0;
	emul_qtrsecirq = (val & 0x10)? 1 : 0;
	return 0;
}

byte MEM_getDiagType(byte val)
{
	return mem_diagtype;
}

byte MEM_setVBLClear(byte val)
{
	mem_diagtype &= ~0x18;
	return 0;
}

byte MEM_getStateReg(byte val)
{
	val = 0;
	if (mem_lcbank2) val |= 0x04;
	if (!mem_lcread) val |= 0x08;
	if (mem_auxwrt) val |= 0x10;
	if (mem_auxrd) val |= 0x20;
	if (vid_page2) val |= 0x40;
	if (mem_altzp) val |= 0x80;
	return val;
}

byte MEM_setStateReg(byte val)
{
	mem_lcbank2 = (val & 0x04)? 1:0;
	mem_lcread = (val & 0x08)? 0:1;
	mem_auxwrt = (val & 0x10)? 1:0;
	mem_auxrd = (val & 0x20)? 1:0;
	(val & 0x40)? VID_setPage2(0) : VID_clearPage2(0);
	mem_altzp = (val & 0x80)? 1:0;
	MEM_rebuildMainMem();
	MEM_rebuildAltZpMem();
	return 0;
}

byte MEM_setLCx80(byte val)
{
	mem_lcbank2 = 1;
	mem_lcread = 1;
	mem_lcwrite = 0;
	mem_lcsecond = 0;
	MEM_rebuildLangCardMem();
	return 0;
}

byte MEM_setLCx81(byte val)
{
	if (mem_lcsecond) {
		mem_lcbank2 = 1;
		mem_lcread = 0;
		mem_lcwrite = 1;;
		mem_lcsecond = 0;
		MEM_rebuildLangCardMem();
	} else {
		mem_lcsecond = 1;
	}
	return 0;
}

byte MEM_setLCx82(byte val)
{
	mem_lcbank2 = 1;
	mem_lcread = 0;
	mem_lcwrite = 0;
	mem_lcsecond = 0;
	MEM_rebuildLangCardMem();
	return 0;
}

byte MEM_setLCx83(byte val)
{
	if (mem_lcsecond) {
		mem_lcbank2 = 1;
		mem_lcread = 1;
		mem_lcwrite = 1;
		mem_lcsecond = 0;
		MEM_rebuildLangCardMem();
	} else {
		mem_lcsecond = 1;
	}
	return 0;
}

byte MEM_setLCx88(byte val)
{
	mem_lcbank2 = 0;
	mem_lcread = 1;
	mem_lcwrite = 0;
	mem_lcsecond = 0;
	MEM_rebuildLangCardMem();
	return 0;
}

byte MEM_setLCx89(byte val)
{
	if (mem_lcsecond) {
		mem_lcbank2 = 0;
		mem_lcread = 0;
		mem_lcwrite = 1;;
		mem_lcsecond = 0;
		MEM_rebuildLangCardMem();
	} else {
		mem_lcsecond = 1;
	}
	return 0;
}

byte MEM_setLCx8A(byte val)
{
	mem_lcbank2 = 0;
	mem_lcread = 0;
	mem_lcwrite = 0;
	mem_lcsecond = 0;
	MEM_rebuildLangCardMem();
	return 0;
}

byte MEM_setLCx8B(byte val)
{
	if (mem_lcsecond) {
		mem_lcbank2 = 0;
		mem_lcread = 1;
		mem_lcwrite = 1;;
		mem_lcsecond = 0;
		MEM_rebuildLangCardMem();
	} else {
		mem_lcsecond = 1;
	}
	return 0;
}

byte MEM_getC071(byte val)
{
#ifdef ROM_03
	return *(rom_memory+0x03C071);
#else
	return *(rom_memory+0x01C071);
#endif
}

byte MEM_getC072(byte val)
{
#ifdef ROM_03
	return *(rom_memory+0x03C072);
#else
	return *(rom_memory+0x01C072);
#endif
}

byte MEM_getC073(byte val)
{
#ifdef ROM_03
	return *(rom_memory+0x03C073);
#else
	return *(rom_memory+0x01C073);
#endif
}

byte MEM_getC074(byte val)
{
#ifdef ROM_03
	return *(rom_memory+0x03C074);
#else
	return *(rom_memory+0x01C074);
#endif
}

byte MEM_getC075(byte val)
{
#ifdef ROM_03
	return *(rom_memory+0x03C075);
#else
	return *(rom_memory+0x01C075);
#endif
}

byte MEM_getC076(byte val)
{
#ifdef ROM_03
	return *(rom_memory+0x03C076);
#else
	return *(rom_memory+0x01C076);
#endif
}

byte MEM_getC077(byte val)
{
#ifdef ROM_03
	return *(rom_memory+0x03C077);
#else
	return *(rom_memory+0x01C077);
#endif
}

byte MEM_getC078(byte val)
{
#ifdef ROM_03
	return *(rom_memory+0x03C078);
#else
	return *(rom_memory+0x01C078);
#endif
}

byte MEM_getC079(byte val)
{
#ifdef ROM_03
	return *(rom_memory+0x03C079);
#else
	return *(rom_memory+0x01C079);
#endif
}

byte MEM_getC07A(byte val)
{
#ifdef ROM_03
	return *(rom_memory+0x03C07A);
#else
	return *(rom_memory+0x01C07A);
#endif
}

byte MEM_getC07B(byte val)
{
#ifdef ROM_03
	return *(rom_memory+0x03C07B);
#else
	return *(rom_memory+0x01C07B);
#endif
}

byte MEM_getC07C(byte val)
{
#ifdef ROM_03
	return *(rom_memory+0x03C07C);
#else
	return *(rom_memory+0x01C07C);
#endif
}

byte MEM_getC07D(byte val)
{
#ifdef ROM_03
	return *(rom_memory+0x03C07D);
#else
	return *(rom_memory+0x01C07D);
#endif
}

byte MEM_getC07E(byte val)
{
#ifdef ROM_03
	return *(rom_memory+0x03C07E);
#else
	return *(rom_memory+0x01C07E);
#endif
}

byte MEM_getC07F(byte val)
{
#ifdef ROM_03
	return *(rom_memory+0x03C07F);
#else
	return *(rom_memory+0x01C07F);
#endif
}
