#include <X11/Xlib.h>
#include <X11/Xutil.h>

#ifdef MITSHM
#include <sys/ipc.h>
#include <sys/shm.h>
#include <X11/extensions/XShm.h>
#endif

/* Size of the window we create. */

#define VID_WIDTH	640
#define VID_HEIGHT	480

#define VID_WIN_WIDTH	640
#define VID_WIN_HEIGHT	530

#define VID_STATUS_FONT	"8x13"

/* Set up the pixel size and image depth (16 or 24 bits) */

#ifdef TRUECOLOR
#define PIXEL unsigned long
#define VID_DEPTH 24
#define VID_CLASS TrueColor
#else
#ifdef HICOLOR
#define PIXEL unsigned short
#define VID_DEPTH 16
#define VID_CLASS DirectColor
#else
#define PIXEL unsigned char
#define VID_DEPTH 8
#define VID_CLASS PseudoColor
#endif
#endif

/* X11-related stuff */

extern Screen		*vid_screen;
extern Display		*vid_display;
extern Visual		*vid_visual;
extern XImage		*vid_image;
extern PIXEL		*vid_buffer;
extern Window		vid_root,vid_window;
extern PIXEL		vid_black,vid_white;
extern GC		vid_gc;
extern Colormap		vid_colormap;

extern XFontStruct	*vid_fontinfo;

extern PIXEL		*vid_lines[VID_HEIGHT];

/* Text-mode colors, in XColor format. */

extern XColor		vid_textcolors[16];

/* Table for the 16 super hires palettes of 16 colors each.	*/
/* These are built on-the-fly as the super hires palettes are	*/
/* modified in memory.						*/

extern PIXEL		vid_palette[16][16];

/* Text mode palette for setting the foreground, background,	*/
/* and border colors. This is initialized at compile time.	*/

extern PIXEL		vid_textpalette[16];

extern word		vid_old_super_palettes[16][16];
extern PIXEL		vid_super_palettes[16][16];

/* Font-related stuff */

extern byte		*vid_font40[2];
extern byte		*vid_font80[2];

/* Current video mode for dispatching */

extern int		vid_currmode;

#define VID_MODE_40TEXT1	0
#define VID_MODE_40TEXT2	1
#define VID_MODE_80TEXT1	2
#define VID_MODE_80TEXT2	3

#define VID_MODE_LORES1		4
#define VID_MODE_LORES2		5
#define VID_MODE_DLORES1	6
#define VID_MODE_DLORES2	7

#define VID_MODE_HIRES1		8
#define VID_MODE_HIRES2		9
#define VID_MODE_DHIRES1	10
#define VID_MODE_DHIRES2	11

#define VID_MODE_SUPER		12

/* Flags for the New Video Register ($C029) */

extern int	vid_super;
extern int	vid_linear;
extern int	vid_a2mono;

extern int	vid_bordercolor;
extern int	vid_textcolor[2];

/* Video softswitches */

extern int	vid_80col;
extern int	vid_altcharset;

extern int	vid_text;
extern int	vid_mixed;
extern int	vid_page2;
extern int	vid_hires;
extern int	vid_dblres;	/* actually AN3... */

extern void	(*VID_updateRoutine)(void);

int VID_init(void);
void VID_update(void);
void VID_reset(void);
void VID_shutdown(void);

void VID_drawStatus1(char *);
void VID_drawStatus2(char *);

void VID_newMode(void);

void VID_drawBorder();

void VID_allocTextColors();
void VID_deallocTextColors();

byte VID_clear80col(byte);
byte VID_set80col(byte);
byte VID_get80col(byte);
byte VID_clearAltCh(byte);
byte VID_setAltCh(byte);
byte VID_getAltCh(byte);
byte VID_getColorReg(byte);
byte VID_setColorReg(byte);
byte VID_getNewVideo(byte);
byte VID_setNewVideo(byte);
byte VID_getBorder(byte);
byte VID_setBorder(byte);
byte VID_clearText(byte);
byte VID_setText(byte);
byte VID_getText(byte);
byte VID_clearMixed(byte);
byte VID_setMixed(byte);
byte VID_getMixed(byte);
byte VID_clearPage2(byte);
byte VID_setPage2(byte);
byte VID_getPage2(byte);
byte VID_clearHires(byte);
byte VID_setHires(byte);
byte VID_getHires(byte);
byte VID_clearDblRes(byte);
byte VID_setDblRes(byte);

void VID_refreshText40Page1(void);
void VID_refreshText40Page2(void);
void VID_refreshText80Page1(void);
void VID_refreshText80Page2(void);

void VID_refreshLoresPage1(void);
void VID_refreshLoresPage2(void);
void VID_refreshDLoresPage1(void);
void VID_refreshDLoresPage2(void);

void VID_refreshHiresPage1(void);
void VID_refreshHiresPage2(void);
void VID_refreshDHiresPage1(void);
void VID_refreshDHiresPage2(void);

void VID_refreshSuperHires(void);
