#ifdef __linux__
#include <sys/soundcard.h>
#else
#include <machine/soundcard.h>
#endif

#include <fcntl.h>
#include <unistd.h>
#include <sys/ioctl.h>

/* Sound GLU and Ensoniq DOC stuff */

extern byte	*snd_docram;				/* Pointer to 64 KB sound RAM buffer	*/
extern int	snd_busy,snd_select,snd_auto,snd_vol;	/* Sound GLU control register bits	*/
extern word	snd_addr_reg;				/* Sound GLU address register value	*/
extern byte	snd_registers[256];			/* Ensoniq DOC registers		*/

/* Stuff pertaining to output device and sample rate */

#define SND_DEVICE_NAME		"/dev/dsp"
#define SND_SAMPLE_RATE		44100
#define SND_SAMPLE_CYCLES	((unsigned long) (1024000/SND_SAMPLE_RATE))

extern int			snd_dspfd;		/* file descriptor of output device	*/

/* Stuff pertaining to logging of speaker "clicks" */

#define SND_CLICK_BUFFER_SIZE	16384
extern unsigned long	*snd_click_buffer;
extern int		snd_click_index;
extern int		snd_click_outindex;
extern int		snd_click_count;
extern byte		snd_last_click_sample;

/* Stuff pertaining to the sound output buffer */

#define SND_OUTPUT_BUFFER_SIZE	65536
extern byte		*snd_output_buffer;

/* Function prototypes */

int SND_init(void);
void SND_update(void);
void SND_reset(void);
void SND_shutdown(void);

byte SND_clickSpeaker(byte);
byte SND_readSoundCtl(byte);
byte SND_readSoundData(byte);
byte SND_readSoundAddrL(byte);
byte SND_readSoundAddrH(byte);

byte SND_writeSoundCtl(byte);
byte SND_writeSoundData(byte);
byte SND_writeSoundAddrL(byte);
byte SND_writeSoundAddrH(byte);
