#ifdef ROM_03
#define ROMSIZE	4
#else
#define ROMSIZE	2
#endif

extern int	mem_ramsize;

/* Flags that make up the Shadow Register ($C035). */

extern int	mem_shadow_text;
extern int	mem_shadow_hires1;
extern int	mem_shadow_hires2;
extern int	mem_shadow_super;
extern int	mem_shadow_aux;
extern int	mem_shadow_lc;

/* The slot control bits in the slot register */

extern int mem_slot_reg[8];

/* Language card control registers */

extern int	mem_lcbank2;
extern int	mem_lcread;
extern int	mem_lcwrite;
extern int	mem_lcsecond;

/* Auxillary memory access registers */

extern int	mem_auxrd;
extern int	mem_auxwrt;
extern int	mem_altzp;
extern int	mem_80store;

/* Diagnostics and Interrupt status register */

extern int	mem_diagtype;

/* Master pointers to our slow and fast RAM blocks	*/

extern byte	*slow_memory;
extern byte	*fast_memory;
extern byte	*rom_memory;

/* Junk memory for writing to when an area is read-protected */

extern byte	junk_memory[256];

/* Structure used to regulate all memory access	*/
/* on a page-by-page basis. This allows the	*/
/* emulator to easily rearrange memory as the	*/
/* softswitches are flipped.			*/

typedef struct {
	byte	*readPtr;
	byte	*writePtr;
	word	readFlags;
	word	writeFlags;
} mem_pagestruct;

/* Read/write flag definitions for above struct	*/

#define MEM_FLAG_SHADOW_E0	0x0001
#define MEM_FLAG_SHADOW_E1	0x0002
#define MEM_FLAG_IO		0x0004
#define MEM_FLAG_INVALID	0x8000

/* Tables for determining which bytes in slow_memory have changed, to	*/
/* within 8 bytes of resolution.					*/

extern unsigned long	mem_change_masks[256];
extern unsigned long	mem_slowram_changed[512];

extern mem_pagestruct	mem_pages[65536];

extern int	MEM_init(void);
extern void	MEM_update(void);
extern void	MEM_reset(void);
extern void	MEM_shutdown(void);

extern void	MEM_rebuildMainMem(void);
extern void	MEM_rebuildAltZpMem(void);
extern void	MEM_rebuildLangCardMem(void);
extern void	MEM_rebuildShadowMem(void);
extern void	MEM_buildLanguageCard(int, int, byte *);

extern byte	MEM_readMem(address);
extern void	MEM_writeMem(address, byte);

extern byte	MEM_ioReadFaultHandler(byte);
extern void	MEM_ioWriteFaultHandler(byte,byte);

extern byte	MEM_ioUnimp(byte);

extern byte	MEM_clear80store(byte val);
extern byte	MEM_set80store(byte val);
extern byte	MEM_get80store(byte val);
extern byte	MEM_clearAuxRd(byte val);
extern byte	MEM_setAuxRd(byte val);
extern byte	MEM_getAuxRd(byte val);
extern byte	MEM_clearAuxWrt(byte val);
extern byte	MEM_setAuxWrt(byte val);
extern byte	MEM_getAuxWrt(byte val);
extern byte	MEM_clearAltZP(byte val);
extern byte	MEM_setAltZP(byte val);
extern byte	MEM_getAltZP(byte val);
extern byte	MEM_getLCbank(byte val);
extern byte	MEM_getLCread(byte val);
extern byte	MEM_getSlotReg(byte val);
extern byte	MEM_setSlotReg(byte val);
extern byte	MEM_getShadowReg(byte val);
extern byte	MEM_setShadowReg(byte val);
extern byte	MEM_getCYAReg(byte val);
extern byte	MEM_setCYAReg(byte val);
extern byte	MEM_getIntEnReg(byte val);
extern byte	MEM_setIntEnReg(byte val);
extern byte	MEM_getDiagType(byte val);
extern byte	MEM_setVBLClear(byte val);
extern byte	MEM_getStateReg(byte val);
extern byte	MEM_setStateReg(byte val);
extern byte	MEM_setLCx80(byte val);
extern byte	MEM_setLCx81(byte val);
extern byte	MEM_setLCx82(byte val);
extern byte	MEM_setLCx83(byte val);
extern byte	MEM_setLCx88(byte val);
extern byte	MEM_setLCx89(byte val);
extern byte	MEM_setLCx8A(byte val);
extern byte	MEM_setLCx8B(byte val);

extern byte	MEM_getC071(byte val);
extern byte	MEM_getC072(byte val);
extern byte	MEM_getC073(byte val);
extern byte	MEM_getC074(byte val);
extern byte	MEM_getC075(byte val);
extern byte	MEM_getC076(byte val);
extern byte	MEM_getC077(byte val);
extern byte	MEM_getC078(byte val);
extern byte	MEM_getC079(byte val);
extern byte	MEM_getC07A(byte val);
extern byte	MEM_getC07B(byte val);
extern byte	MEM_getC07C(byte val);
extern byte	MEM_getC07D(byte val);
extern byte	MEM_getC07E(byte val);
extern byte	MEM_getC07F(byte val);
