#define S5D1_DEFAULT	"s5d1.img"
#define S5D2_DEFAULT	"s5d2.img"
#define S6D1_DEFAULT	"s5d1.img"
#define S6D2_DEFAULT	"s5d2.img"
#define S7D1_DEFAULT	"hd1.img"
#define S7D2_DEFAULT	"hd2.img"

/* Description of an XGS image file header. Note that this is	*/
/* Note that multi-byte values are in LSB order!		*/

typedef struct {
	char	magic[4];	/* Should be "XGS!"			*/
	byte	version;	/* Format version (currently 0x00)	*/
	word	num_blocks;	/* Number of blocks in image		*/
	byte	protected;	/* Nonzero if image is write-protected	*/
	char	name[32];	/* Name of this image			*/
	char	desc[1024];	/* Description of this image		*/

	/* Fields below this line are valid only in memory */

	char	*filename;	/* Pathname of the image file		*/
	FILE	*stream;	/* Stream pointer for open image	*/
} xgs_image;

/* Filenames of images to mount at startup */

extern char		*s5d1_startup;
extern char		*s5d2_startup;
extern char		*s6d1_startup;
extern char		*s6d2_startup;
extern char		*s7d1_startup;
extern char		*s7d2_startup;

/* Pointers to image headers for currently mounted images */

extern xgs_image	*dsk_s5d1_image;
extern xgs_image	*dsk_s5d2_image;
extern xgs_image	*dsk_s6d1_image;
extern xgs_image	*dsk_s6d2_image;
extern xgs_image	*dsk_s7d1_image;
extern xgs_image	*dsk_s7d2_image;

extern byte		dsk_slot5_rom[256];
extern byte		dsk_slot7_rom[256];

int		DSK_init(void);
void		DSK_update(void);
void		DSK_reset(void);
void		DSK_shutdown(void);

xgs_image	*DSK_loadImage(char *);

void		DSK_handleSlot5(void);
void		DSK_handleSlot7(void);
