typedef unsigned char	byte;		/* used for 8-bit values  */
typedef unsigned short	word;		/* used for 16-bit values */
typedef unsigned long	address;	/* used for 24-bit values */

typedef signed char	offset_s;	/* short offset           */
typedef signed short	offset_l;	/* long offset            */

/* Union definition of a 16-bit value that can also be */
/* accessed as its component 8-bit values. Useful for  */
/* registers, which change sized based on teh settings */
/* the M and X program status register bits.           */

typedef union {
#ifdef LSB_FIRST
	struct { byte	L,H; } B;
#else
	struct { byte	H,L; } B;
#endif
	word	W;
} dualw;

/* Same as above but for addresses. */

typedef union {
#ifdef LSB_FIRST
	struct { byte	L,H,B,Z; } B;
	struct { word	L,H; } W;
#else
	struct { byte	Z,B,H,L; } B;
	struct { word	H,L; } W;
#endif
	address	A;
} duala;

/* Definitions of the 65816 registers, in case you want	*/
/* to access these from your own routines (such as from	*/
/* a WDM opcode handler routine.			*/

extern dualw	A;	/* Accumulator		     */
extern dualw	D;	/* Direct Page Register      */
extern byte	P;	/* Processor Status Register */
extern int	E;	/* Emulation Mode Flag       */
extern dualw	S;	/* Stack Pointer             */
extern dualw	X;	/* X Index Register          */
extern dualw	Y;	/* Y Index Register          */
extern byte	DB;	/* Data Bank Register        */

/* Current cycle count */

extern unsigned long	cpu_cycle_count;

#ifndef CPU_DISPATCH

extern union {		/* Program Counter	     */
#ifdef LSB_FIRST
	struct { byte L,H,PB,Z; } B;
	struct { word PC,Z; } W;
#else
	struct { byte Z,PB,H,L; } B;
	struct { word Z,PC; } W;
#endif
	address	A;
} PC;

#endif

/* These are the core memory access macros used in the 65816 emulator. */
/* Set these to point to routines which handle your emulated machine's */
/* memory access (generally these routines will check for access to    */
/* memory-mapped I/O and things of that nature.)                       */

#define M_READ(a)	MEM_readMem(a)
#define M_WRITE(a,v)	MEM_writeMem(a,v)

/* Set this macro to your emulator's "update" routine. Your update */
/* routine would probably do things like update hardware sprites,  */
/* and check for user keypresses. CPU_run() calls this routine     */
/* periodically to make sure the rest of your emulator gets time   */
/* to run.                                                         */

/* #define E_UPDATE(v) */

/* Set this macro to your emulator's routine for handling the WDM	*/
/* pseudo-opcode. Useful for trapping certain emulated machine		*/
/* functions and emulating them in fast C code.				*/

#define E_WDM(v)	EMUL_handleWDM(v)

/* Set the 65816 emulator's update period (the number of instructions	*/
/* executed between calls to the E_UPDATE routine.)			*/

void CPU_setUpdatePeriod(int period);

/* Set the 65816 emulator's trace mode to off (0) or on (nonzero) */

void CPU_setTrace(int mode);

/* Send a reset to the 65816 emulator. You should do this at	*/
/* startup before you call CPU_run().				*/

void CPU_reset(void);

/* Send an abort to the 65816 emulator. */

void CPU_abort(void);

/* Send aa non-maskable interrupt to the 65816 emulator */

void CPU_nmi(void);

/* Send a standard (maskable) interrupt to the 65816 emulator */

void CPU_irq(void);

/* This routine never returns; it sits in a loop processing opcodes */
/* until the emulator exits. Periodic calls to the emulator update  */
/* macro are made to allow the rest of the emulator to function.    */

void CPU_run(void);

/* Internal routine called when the mode bits (e/m/x) change */

void CPU_modeSwitch(void);

/* Internal routine to print the next instruction in trace mode */

void CPU_debug(void);
