/* This is the same SKI version returned on my ROM 03, so we'll use it.	*/

#define ADB_VERSION	6

/* Struct for SKI command processing. Command begins execution after we	*/
/* read bytes_to_read bytes, and ends after bytes_to_write bytes are	*/
/* written. Note read = get from user, write = send to user.		*/

typedef struct {
	int	command;		/* command byte */
	int	bytes_to_read;		/* bytes command will read */
	int	bytes_to_write;		/* bytes command will write */
} ski_command;

/* Mega II Mouse switches from INTEN ($C041) */

extern int	adb_m2mouseenable;
extern int	adb_m2mousemvirq;
extern int	adb_m2mouseswirq;

int ADB_init(void);
void ADB_update(void);
void ADB_reset(void);
void ADB_shutdown(void);

byte ADB_readKey(byte);
byte ADB_clearKey(byte);

byte ADB_readMouse(byte);
byte ADB_readModifiers(byte);
byte ADB_readCommand(byte);
byte ADB_readStatus(byte);

byte ADB_readCommandKey(byte);
byte ADB_readOptionKey(byte);

byte ADB_setCommand(byte);
byte ADB_setStatus(byte);
