/*********************************************************************
 *                                                                   *
 *                     XGS : Apple IIGS Emulator                     *
 *                                                                   *
 *        Written and Copyright (C)1996 by Joshua M. Thompson        *
 *                                                                   *
 *  You are free to distribute this code for non-commercial purposes *
 * I ask only that you notify me of any changes you make to the code *
 *     Commercial use is prohibited without my written permission    *
 *                                                                   *
 *********************************************************************/

/*
 * File: slot5.c
 *
 * Slot 5 drive emulation
 */

#include "xgs.h"
#include "disks.h"

xgs_image	*dsk_s5d1_image;
xgs_image	*dsk_s5d2_image;

byte		block_buffer[512];

byte		dsk_slot5_rom[256] = {
	0xA9, 0x20, 0xA9, 0x00, 0xA9, 0x03, 0xA9, 0x01, 0x85, 0x42, 0x64, 0x43, 0x64, 0x44, 0xA9, 0x08,
	0x85, 0x45, 0x64, 0x46, 0x64, 0x47, 0x42, 0xC5, 0xB0, 0x69, 0xA9, 0xC5, 0x8D, 0xF8, 0x07, 0xA9,
	0x05, 0xA2, 0x50, 0x4C, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x42, 0xC5, 0x60, 0x4C, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x93, 0x80,
};

void DSK_handleSlot5()
{
	int		cmd,block,buffer,i;
	xgs_image	*unit;

	cmd = MEM_readMem(0x000042);
	unit = (MEM_readMem(0x000043) & 0x80)? dsk_s5d2_image : dsk_s5d1_image;
	buffer = MEM_readMem(0x000044) | (MEM_readMem(0x000045) << 8);
	block = MEM_readMem(0x000046) | (MEM_readMem(0x000047) << 8);

	if (!unit) {
		A.B.L = 0x028;	/* NO DEVICE CONNECTED */
		P |= 0x01;
		return;
	}

	A.B.L = 0;

	switch(cmd) {
		case 0x00 :	X.B.L = unit->num_blocks & 0xFF;
				Y.B.L = unit->num_blocks >> 8;
				break;
		case 0x01 :	if (block > unit->num_blocks) {
					A.B.L = 0x27;	/* I/O ERROR */
					break;
				}
				fseek(unit->stream,sizeof(xgs_image) + (block * 512),SEEK_SET);
				fread(block_buffer,1,512,unit->stream);
				for (i = 0 ; i < 512 ; i++) {
					MEM_writeMem(buffer+i,block_buffer[i]);
				}
				break;
		case 0x02 :	if (unit->protected) {
					A.B.L = 0x2B;	/* WRITE PROTECTED */
					break;
				}
				if (block > unit->num_blocks) {
					A.B.L = 0x27;	/* I/O ERROR */
					break;
				}
				for (i = 0 ; i < 512 ; i++) {
					block_buffer[i] = MEM_readMem(buffer+i);
				}
				fseek(unit->stream,sizeof(xgs_image) + (block * 512),SEEK_SET);
				fwrite(block_buffer,1,512,unit->stream);
				break;
		case 0x03 :	if (unit->protected) {
					A.B.L = 0x2B;	/* WRITE PROTECTED */
				}
				break;
		default :	A.B.L = 0x01;	/* BAD CALL */
				break;
	}
	if (A.B.L) {
		P |= 0x01;
	} else {
		P &= ~0x01;
	}
}
