/*********************************************************************
 *                                                                   *
 *                     XGS : Apple IIGS Emulator                     *
 *                                                                   *
 *        Written and Copyright (C)1996 by Joshua M. Thompson        *
 *                                                                   *
 *  You are free to distribute this code for non-commercial purposes *
 * I ask only that you notify me of any changes you make to the code *
 *     Commercial use is prohibited without my written permission    *
 *                                                                   *
 *********************************************************************/

/*
 * File: dsk-main.c
 *
 * Disk drive emulation initialization and core routines.
 */

#include "xgs.h"
#include "disks.h"

char	*s5d1_startup = S5D1_DEFAULT;
char	*s5d2_startup = S5D2_DEFAULT;
char	*s6d1_startup = S6D1_DEFAULT;
char	*s6d2_startup = S6D2_DEFAULT;
char	*s7d1_startup = S7D1_DEFAULT;
char	*s7d2_startup = S7D2_DEFAULT;

int DSK_init()
{
	printf("\nInitializing disk emulation system\n");

	printf("    - Loading s5, d1 from file \"%s\": ",s5d1_startup);
	dsk_s5d1_image = DSK_loadImage(s5d1_startup);

	printf("    - Loading s5, d2 from file \"%s\": ",s5d2_startup);
	dsk_s5d2_image = DSK_loadImage(s5d2_startup);

	printf("    - Loading s6, d1 from file \"%s\": ",s6d1_startup);
	dsk_s6d1_image = DSK_loadImage(s6d1_startup);

	printf("    - Loading s6, d2 from file \"%s\": ",s6d2_startup);
	dsk_s6d2_image = DSK_loadImage(s6d2_startup);

	printf("    - Loading s7, d1 from file \"%s\": ",s7d1_startup);
	dsk_s7d1_image = DSK_loadImage(s7d1_startup);

	printf("    - Loading s7, d2 from file \"%s\": ",s7d2_startup);
	dsk_s7d2_image = DSK_loadImage(s7d2_startup);

	return 0;
}

void DSK_update()
{
}

void DSK_reset()
{
}

void DSK_shutdown()
{
	printf("\nShutting down disk emulation system\n");
}

/* Load a disk image from the specified file, and return a pointer to	*/
/* the image data. We also do some sanity checks, like making sure the	*/
/* image is a multiple of 512 bytes (one ProDOS block).			*/

xgs_image *DSK_loadImage(char *filename)
{
#ifndef LSB_FIRST
	word		temp;
#endif
	FILE		*fp;
	xgs_image	*image;

	if ((image = malloc(sizeof(xgs_image))) == NULL) {
		printf("Failed (out of memory)\n");
		return NULL;
	}

	if ((fp = fopen(filename,"r+")) == NULL) {
		printf("Failed (can't open)\n");
		free(image);
		return NULL;
	}

	rewind(fp);
	if (fread(image,1,sizeof(xgs_image),fp) != sizeof(xgs_image)) {
		printf("Failed (can't read header)\n");
		fclose(fp);
		free(image);
		return NULL;
	}

	if (strncmp(image->magic,"XGS!",4)) {
		printf("Failed (bad header)\n");
		fclose(fp);
		free(image);
		return NULL;
	}

	if (image->version != 0x00) {
		printf("Failed (unknown version)\n");
		fclose(fp);
		free(image);
		return NULL;
	}

	if ((image->filename = strdup(filename)) == NULL) {
		printf("Failed (out of memory)\n");
		fclose(fp);
		free(image);
		return NULL;
	}

#ifndef LSB_FIRST
	temp = (image->num_blocks & 0x00FF) << 8;
	temp |= image->num_blocks >> 8;
	image->num_blocks = temp;
#endif

	image->stream = fp;
	printf("Done\n");
	return image;
}
