
/* Generated by Interface Builder */
#import "Controller.h"
#import <appkit/appkit.h>
#import <soundkit/soundkit.h>
#import <stdio.h>
#import <streams/streams.h>

@implementation Controller

- appDidInit:sender
{
    maxvalue = 110;
    [StatsField setIntValue:maxvalue at:0];
    syncbyte = 260;
    [StatsField setIntValue:syncbyte at:7];
    maxtry = 25;
    [StatsField setIntValue:maxtry at:8];
    input = [[Sound alloc] init];
    [input setDelegate:self];
    
    [self reset];
    [ConvertButton setEnabled:NO];
    
    return self;
}

- writeError:(char *)error
{
    [ErrorField setStringValue:error at:0];
    
    return self;
}

- record:sender
{
    int error;
    
    [StatusField setStringValue:"Recording..."];
    [RecordButton setEnabled:NO];
    [StopButton setEnabled:YES];
    [ConvertButton setEnabled:NO];

    error = [input record];
    return self;
}

- stop:sender
{
    int error;
    
    error = [input stop];
    return self;
}

- convert:sender
{
    int count,subcount;
    unsigned char *ptr;
    int value;
    BOOL endofdata;
    int data;
    int min,max;
    int avecount, avetotal;
    int lastvalue;
    BOOL getchecksum;
    int checksum;
    unsigned char c;
    BOOL goodmaxvalue;
    int shift;
    int try;
    char stderrstr[256];
    
    int division;		/* calculated */
    int space = 410;
    maxvalue = [StatsField intValueAt:0];
    syncbyte = [StatsField intValueAt:7];
    maxtry = [StatsField intValueAt:8];
    
    [StatusField setStringValue:"Syncing..."];
    [self writeError:""];
    try = 0;
    goodmaxvalue = NO;
    while (!goodmaxvalue)
    {
    	// Find first click
	[StatsField setIntValue:maxvalue at:0];
	++try;
	count = 0;
	ptr = [input data];
	value = 0;
	while ((count < [input dataSize]) && (abs(value) <= maxvalue))
	{
	    value = 0;
	    value = (int)*ptr;
	    if (value > 128)  value = 256 - (value - 128);
	    value = value - 128;

	    ++count;
	    ++ptr;
	}
	
	// read in <syncbyte> clicks and find the average distance between them
	--count;
	--ptr;
	lastvalue = subcount = 0;
	min = 99999;
	max = 0;
	avetotal = 0;
	avecount = 0;
	while ((count < [input dataSize]) && (avecount < syncbyte))
	{
	    value = 0;
	    value = (int)*ptr;
	    if (value > 128)  value = 256 - (value - 128);
	    value = value - 128;

	    if ((abs(value) > maxvalue) && (lastvalue <= maxvalue))
	    {
		if ((avecount != 0) && (subcount < min)) min = subcount;
		if (subcount > max) max = subcount;
		avetotal += subcount;
		++avecount;
		subcount = 0;
	    }
	    
	    ++count;
	    ++ptr;
	    ++subcount;
	    lastvalue = abs(value);
	}
	division = avetotal / (avecount-1);
	[StatsField setIntValue:division at:1];
	[StatsField setIntValue:min at:2];
	[StatsField setIntValue:max at:3];
	[StatsField setIntValue:try at:4];
	goodmaxvalue = YES;
	if (avecount < syncbyte)
	{
	    [StatsField setIntValue:count at:6];
	    sprintf(stderrstr,"Syncing: syncbyte = %d != %d\n", avecount, syncbyte);
	    [self writeError:stderrstr];
	    goodmaxvalue = NO;
	    --maxvalue;
	}
	else if (min < (division * 0.9))
	{
	    [self writeError:"Syncing: min is not within 10% of division\n"];
	    goodmaxvalue = NO;
	    ++maxvalue;
	    ++maxvalue;
	}
	else if (max > (division * 1.1))
	{
	    [self writeError:"Syncing: max is not within 10% of division\n"];
	    goodmaxvalue = NO;
	    --maxvalue;
	}
	
	if (((maxvalue > 127) || (maxvalue < -127))
	    || (try > maxtry))
	{
	    [self writeError:"Syncing: maxvalue is out of range or tries exceeded maxtry\n"];
	    return [self quit];
	}
	// distance between any sync bits must be within 10% of average.
    }

    // check distance between last sync bit and start bit
    // not really necessary, but is still a good check
    endofdata = NO;
    subcount = 0;
    while ((count < [input dataSize]) && (!endofdata))
    {
	value = 0;
	value = (int)*ptr;
	if (value > 128)  value = 256 - (value - 128);
	value = value - 128;

	if ((abs(value) > maxvalue) && (lastvalue <= maxvalue))
	{
	    endofdata = YES;
	    space = subcount;
	    [StatsField setIntValue:space at:5];
	    [StatsField setIntValue:count at:6];
	}
	
	++count;
	++ptr;
	++subcount;
	lastvalue = abs(value);
    }

    if (((division * 3) < (space*0.9))
	|| ((division * 3) > (space*1.1)))
    {
	[StatsField setIntValue:count at:6];
	[self writeError:"Syncing:space should be a ratio of 3*division\n"];
	return [self quit];
    }
    
    // read in data.
    // data is of the form	7H6H5H4H3H2H1H0HS
    //	where H = 1 (to keep reading in sync -- two 0s in a row can be misread
    //  where 76543210 is the byte (in binary - high to low)
    //  where S = 1 for a normal byte & S = 0 for the last sync and checksum
    [StatusField setStringValue:"Translating..."];
    data = 0;
    count += ((int) (division * 0.9));
    subcount = ((int) (division * 0.9));
    ptr = ptr + ((int) (division * 0.9));
    shift = 0;
    checksum = 0;
    getchecksum = NO;
    while (count < [input dataSize])
    {
	value = 0;
	value = (int)*ptr;
	if (value > 128)  value = 256 - (value - 128);
	value = value - 128;

//	    fprintf(stderr,"[%d]@%d(%d)\n", value,count,ptr);
	if (abs(value) > maxvalue)
	{
//	        avetotal = ((count-subcount) + (division * 0.9));
//	        avecount = ((count-subcount) + (division * 1.1));
//		fprintf(stderr,"[1]	sample = (%d)%d(%d)\n",
//		    avetotal, count, avecount);
	    ++shift;
	    if (shift % 2 == 1)
	    {
		data = data << 1;
		data = data + 1;
	    }
//		count += (division * 1.9) - subcount;
//		ptr = ptr + ((int) ((division * 1.9) - subcount));
//		subcount = (division * 0.9);

	    subcount = ((int) (division * 0.9));
	    count += ((int) (division * 0.9));
	    ptr = ptr + ((int) (division * 0.9));
	}
	if (subcount > (division * 1.1))
	{
//	        avetotal = ((count-subcount) + (division * 0.9));
//	        avecount = ((count-subcount) + (division * 1.1));
//		fprintf(stderr,"[0]	sample = (%d)%d(%d)\n",
//		    avetotal, count, avecount);
	    ++shift;
	    if (shift % 2 == 1)
	    {
		data = data << 1;
		// data = data + 0;
	    }
	    else
	    {
		[StatsField setIntValue:count at:6];
		[self writeError:"Translating:invalid sync bit at current sample.\n"];
		return [self quit];
	    }
	    count += ((int) ((division * 1.9) - subcount));
	    ptr = ptr + ((int) ((division * 1.9) - subcount));
	    subcount = ((int) (division * 0.9));
	}
	
	if (shift > 16)
	{
//		fprintf(stderr,"data = %x (%d)\tsample=%d\t",
//		    data, data>>1, count);
//		fprintf(stderr,"checksum=0x%x\n",checksum);
	    if (getchecksum)
	    {
		data = data >> 1;
		if (checksum != data)
		{
		    [StatsField setIntValue:count at:6];
		    sprintf(stderrstr,"Translating:checksum mismatch: %d != %d\n",
			data, checksum);
		    [self writeError:stderrstr];
		}
		else [self writeError:"Translating:checksum matched -- xfer successful\n"];
		return [self quit];
	    }
	    if (data % 2 == 0)  getchecksum = YES;
	    else
	    {
		data = data >> 1;
		checksum += data;
		checksum = checksum % 256;
		c = (unsigned char) data;
		NXPutc(saveStream, c);
	    }
	    shift = data = 0;
	}
	
	++count;
	++ptr;
	++subcount;
    }
    [self writeError:"Translating:ran out of data"];
    return self;
}

- quit
{
    id savePanel;
    const char *saveName;	/* filename to save into */

    [StatusField setStringValue:"Saving..."];
    savePanel = [SavePanel new];
	
    [savePanel setRequiredFileType:""];
    if ([savePanel runModalForDirectory:NULL file:NULL])
    {
	saveName = [savePanel filename];
	NXSaveToFile(saveStream, saveName);
	NXCloseMemory(saveStream, NX_FREEBUFFER);
    }
    [self reset];
    
    return self;
}

- reset
{
    [RecordButton setEnabled:YES];
    [StopButton setEnabled:NO];
    [ConvertButton setEnabled:YES];
    [StatusField setStringValue:"Ready"];

    saveStream = NXOpenMemory(NULL, 0, NX_WRITEONLY);

    return self;
}

- didRecord:sender
{
    [RecordButton setEnabled:NO];
    [StopButton setEnabled:NO];
    [ConvertButton setEnabled:YES];
    [StatsField setIntValue:maxvalue at:0];
    [StatsField setIntValue:syncbyte at:7];
    [StatsField setIntValue:maxtry at:8];
    [StatusField setStringValue:"Ready"];

    return self;
}

- saveSound:sender
{
    id savePanel;
    char *saveName;	/* filename to save into */

    [StatusField setStringValue:"Saving..."];
    savePanel = [SavePanel new];
	
    [savePanel setRequiredFileType:"snd"];
    if ([savePanel runModalForDirectory:NULL file:NULL])
	saveName = (char *)[savePanel filename];
    else return self;	// aborted out?

    [input writeSoundfile:saveName];
    
    return self;
}

- loadSound:sender
{
    const char *const *file;
    static const char *const fileType[2] = {"snd", NULL};
    id openPanel;
    char fullName[1024];

    openPanel = [[OpenPanel new] allowMultipleFiles:NO];

    /* run the open panel, filtering for out type of document */
    if ([openPanel runModalForTypes:fileType])
    {
	file = [openPanel filenames];
	sprintf(fullName,"%s/%s",[openPanel directory],*file);
	[input readSoundfile:fullName];
	[self reset];
    }
    return self;
}

@end
