;
; Startup code for cc65 (Oric version)
;
; By Debrune Jrme <jede@oric.org> and Ullrich von Bassewitz <uz@cc65.org>
;
; This must be the *first* file on the linker command line
;

	.export		_exit
	.import		initlib, donelib
	.import	     	callmain, zerobss
       	.import	       	__RAM_START__, __RAM_SIZE__, __BSS_LOAD__

        .include        "zeropage.inc"
        .include        "atmos.inc"


; ------------------------------------------------------------------------
; Oric tape header

.segment        "TAPEHDR"

        .byte   $16, $16, $16   ; Sync bytes
        .byte   $24             ; End of header marker

        .byte   $00                             ; $2B0
        .byte   $00                             ; $2AF
        .byte   $80                             ; $2AE Machine code flag
        .byte   $C7                             ; $2AD Autoload flag
        .dbyt   __BSS_LOAD__                    ; $2AB           
        .dbyt   __RAM_START__                   ; $2A9
        .byte   $00                             ; $2A8
        .byte   $00                             ; Zero terminated name

; ------------------------------------------------------------------------
; Place the startup code in a special segment.

.segment       	"STARTUP"

; Save the zero page area we're about to use

	ldx    	#zpspace-1
L1:	lda	sp,x
   	sta	zpsave,x	; Save the zero page locations we need
	dex
       	bpl	L1

; Clear the BSS data

	jsr	zerobss

; Unprotect columns 0 and 1

        lda     STATUS
        sta     stsave
        and     #%11011111
        sta     STATUS

; Save system stuff and setup the stack

       	tsx
       	stx    	spsave       	; save system stk ptr

	lda    	#<(__RAM_START__ + __RAM_SIZE__)
	sta	sp
	lda	#>(__RAM_START__ + __RAM_SIZE__)
       	sta	sp+1   		; Set argument stack ptr

; Call module constructors

	jsr	initlib

; Push arguments and call main()

       	jsr    	callmain

; Call module destructors. This is also the _exit entry.

_exit:	jsr	donelib		; Run module destructors

; Restore system stuff

	ldx	spsave
	txs
        lda     stsave
        sta     STATUS

; Copy back the zero page stuff

       	ldx	#zpspace-1
L2:	lda	zpsave,x
	sta	sp,x
	dex
       	bpl	L2

; Back to BASIC

	rts

; ------------------------------------------------------------------------
; Data

.data

zpsave:	.res	zpspace

.bss
spsave:	.res	1
stsave: .res    1


