/* */
/*	aftp.h */
/* */

#define SIMOS_PRODOS	0
#define SIMOS_DOS		1
#define SIMOS_UNKNOWN	2
#define SIMOS_GCR		3

#define	MODE_BINARY		0
#define MODE_TEXT		1

typedef unsigned char byte;
typedef unsigned short word;
typedef unsigned long dword;

#define BYTES_PER_BLOCK		512
#define BYTES_PER_SECTOR	256
#define SECTORS_PER_TRACK	16
#define BYTES_PER_TRACK		(SECTORS_PER_TRACK * BYTES_PER_SECTOR)
#define TRACKS_PER_DISK		35

typedef	struct _osys *osys;
typedef struct _disk *disk;

struct _osys
{
	int		os_data_size;
	int		(*init)(disk d);
	int		(*dir)(disk d, char *name);
	int		(*get)(disk d, char *name, FILE *fp);
	int		(*put)(disk d, char *name, FILE *fp);
	int		(*del)(disk d, char *name);
	int		(*cd)(disk d, char *name);
	int		(*mkdir)(disk d, char *name);
	int		(*rmdir)(disk d, char *name);
	int		(*name)(char *name, int maxlen);
	int		(*close)(disk d);
};

struct _disk
{
	char *	name;
	FILE *	file;
	osys	os;
	void *	os_data;
	byte	header[13];
	byte	type;
	long	blocks;
	long	data_pos;
	int		use_tracks;
	byte	interleave[SECTORS_PER_TRACK];
	byte	order[SECTORS_PER_TRACK];
	byte	buffer[BYTES_PER_BLOCK];
	int		buffer_dirty;
	long	buffer_block;
	int		buffer_track;
	int		buffer_sector;
	long	buffer_offset1;
	long	buffer_offset2;
};


/*	Globally Accessible Functions... */

extern	int		text_mode;						/* Text or Binary */
extern	int		read_only;						/* Read Only Mode */

extern	struct _osys	os_pro;
extern	struct _osys	os_dos;


/*	Globally Accesible Prototypes... */

disk 	disk_open(char *name, char *mode);
int		disk_read_block(disk d, long block);
int		disk_read_block_zero(disk d, long block);
int		disk_read_sector(disk d, int track, int sector);
int		disk_dirty(disk d);
int		disk_flush(disk d);
byte	disk_byteat(disk d, int offset);
void	disk_byteset(disk d, int offset, byte value);
word	disk_wordat(disk d, int offset);
void	disk_wordset(disk d, int offset, word value);
void	disk_close(disk d);

word	word_at(byte *data);
void	word_set(byte *data, word value);

int 	apptoascii(int c);
int 	asciitoapp(int c);
void *	alloc(int n);


/*	End of File */
