/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.storage.physical;

import com.webcodepro.applecommander.storage.physical.ByteArrayImageLayout;

public abstract class ImageOrder {
    private ByteArrayImageLayout diskImageManager;

    public ImageOrder(ByteArrayImageLayout byteArrayImageLayout) {
        this.setDiskImageManager(byteArrayImageLayout);
    }

    public ByteArrayImageLayout getDiskImageManager() {
        return this.diskImageManager;
    }

    public int getPhysicalSize() {
        return this.diskImageManager.getPhysicalSize();
    }

    public void setDiskImageManager(ByteArrayImageLayout byteArrayImageLayout) {
        this.diskImageManager = byteArrayImageLayout;
    }

    public byte[] readBytes(int n, int n2) {
        return this.diskImageManager.readBytes(n, n2);
    }

    public void writeBytes(int n, byte[] byArray) {
        this.diskImageManager.writeBytes(n, byArray);
    }

    public int getBlocksOnDevice() {
        return this.getPhysicalSize() / 512;
    }

    public abstract String getName();

    public abstract byte[] readBlock(int var1);

    public abstract void writeBlock(int var1, byte[] var2);

    public abstract boolean isBlockDevice();

    public abstract boolean isTrackAndSectorDevice();

    public int getTracksPerDisk() {
        return this.getPhysicalSize() / (this.getSectorsPerTrack() * 256);
    }

    public int getSectorsPerTrack() {
        if (this.isSizeApprox(819200) || this.isSizeApprox(819264)) {
            return 32;
        }
        return 16;
    }

    public abstract byte[] readSector(int var1, int var2) throws IllegalArgumentException;

    public abstract void writeSector(int var1, int var2, byte[] var3) throws IllegalArgumentException;

    public boolean isSizeApprox(int n) {
        return this.getPhysicalSize() >= n && this.getPhysicalSize() <= n + 10;
    }

    public void format() {
        int n = this.diskImageManager.getPhysicalSize();
        this.diskImageManager.setDiskImage(new byte[n]);
    }

    public int getSectorsPerDisk() {
        return this.getTracksPerDisk() * this.getSectorsPerTrack();
    }
}

