/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.storage.os.rdos;

import com.webcodepro.applecommander.storage.DirectoryEntry;
import com.webcodepro.applecommander.storage.DiskFullException;
import com.webcodepro.applecommander.storage.FileEntry;
import com.webcodepro.applecommander.storage.FormattedDisk;
import com.webcodepro.applecommander.storage.StorageBundle;
import com.webcodepro.applecommander.storage.os.rdos.RdosFileEntry;
import com.webcodepro.applecommander.storage.physical.ImageOrder;
import com.webcodepro.applecommander.util.AppleUtil;
import com.webcodepro.applecommander.util.TextBundle;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;

public class RdosFormatDisk
extends FormattedDisk {
    private TextBundle textBundle = StorageBundle.getInstance();
    private static final int[] sectorSkew = new int[]{0, 7, 14, 6, 13, 5, 12, 4, 11, 3, 10, 2, 9, 1, 8, 15};
    public static final int ENTRY_LENGTH = 32;
    public static final int BLOCKS_ON_DISK = 455;
    public static final String[] filetypes = new String[]{"B", "A", "T"};

    public RdosFormatDisk(String string, ImageOrder imageOrder) {
        super(string, imageOrder);
    }

    public static RdosFormatDisk[] create(String string, ImageOrder imageOrder) {
        RdosFormatDisk rdosFormatDisk = new RdosFormatDisk(string, imageOrder);
        rdosFormatDisk.format();
        return new RdosFormatDisk[]{rdosFormatDisk};
    }

    public byte[] readRdosBlock(int n) {
        int n2 = n / 13;
        int n3 = sectorSkew[n % 13];
        return this.readSector(n2, n3);
    }

    public void writeRdosBlock(int n, byte[] byArray) {
        int n2 = n / 13;
        int n3 = sectorSkew[n % 13];
        this.writeSector(n2, n3, byArray);
    }

    public String getDiskName() {
        byte[] byArray = this.readRdosBlock(4);
        return AppleUtil.getString(byArray, 224, 32);
    }

    public List getFiles() {
        ArrayList<RdosFileEntry> arrayList = new ArrayList<RdosFileEntry>();
        for (int i = 13; i < 23; ++i) {
            byte[] byArray = this.readRdosBlock(i);
            for (int j = 0; j < byArray.length; j += 32) {
                byte[] byArray2 = new byte[32];
                System.arraycopy(byArray, j, byArray2, 0, byArray2.length);
                if (AppleUtil.getUnsignedByte(byArray2[0]) == 0) continue;
                RdosFileEntry rdosFileEntry = new RdosFileEntry(byArray2, this);
                arrayList.add(rdosFileEntry);
            }
        }
        return arrayList;
    }

    public FileEntry createFile() throws DiskFullException {
        throw new DiskFullException(this.textBundle.get("FileCreationNotSupported"));
    }

    public boolean canCreateDirectories() {
        return false;
    }

    public boolean canCreateFile() {
        return false;
    }

    public String getFormat() {
        return this.textBundle.get("RdosFormatDisk.Rdos21");
    }

    public int getFreeBlocks() {
        return 455 - this.getUsedBlocks();
    }

    public int getUsedBlocks() {
        int n = 0;
        for (RdosFileEntry rdosFileEntry : this.getFiles()) {
            if (rdosFileEntry.isDeleted()) continue;
            n += rdosFileEntry.getSizeInBlocks();
        }
        return n;
    }

    public int getFreeSpace() {
        return this.getFreeBlocks() * 256;
    }

    public int getUsedSpace() {
        return this.getUsedBlocks() * 256;
    }

    public int[] getBitmapDimensions() {
        return null;
    }

    public int getBitmapLength() {
        return 455;
    }

    public FormattedDisk.DiskUsage getDiskUsage() {
        return new RdosDiskUsage();
    }

    public String[] getBitmapLabels() {
        return new String[]{this.textBundle.get("Block")};
    }

    public List getDiskInformation() {
        List list = super.getDiskInformation();
        list.add((FormattedDisk)this.new FormattedDisk.DiskInformation(this.textBundle.get("TotalBlocks"), 455));
        list.add((FormattedDisk)this.new FormattedDisk.DiskInformation(this.textBundle.get("FreeBlocks"), this.getFreeBlocks()));
        list.add((FormattedDisk)this.new FormattedDisk.DiskInformation(this.textBundle.get("UsedBlocks"), this.getUsedBlocks()));
        return list;
    }

    public List getFileColumnHeaders(int n) {
        ArrayList<FormattedDisk.FileColumnHeader> arrayList = new ArrayList<FormattedDisk.FileColumnHeader>();
        switch (n) {
            case 2: {
                arrayList.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("Type"), 1, 2));
                arrayList.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("Blocks"), 3, 3));
                arrayList.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("Name"), 24, 1));
                arrayList.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("RdosFormatDisk.Size"), 6, 3));
                arrayList.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("RdosFormatDisk.StartingBlock"), 3, 3));
                break;
            }
            case 3: {
                arrayList.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("Type"), 1, 2));
                arrayList.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("Blocks"), 3, 3));
                arrayList.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("Name"), 24, 1));
                arrayList.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("RdosFormatDisk.Size"), 6, 3));
                arrayList.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("RdosFormatDisk.StartingBlock"), 3, 3));
                arrayList.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("RdosFormatDisk.Address"), 5, 3));
                arrayList.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("DeletedQ"), 7, 2));
                break;
            }
            default: {
                arrayList.addAll(super.getFileColumnHeaders(n));
            }
        }
        return arrayList;
    }

    public boolean supportsDeletedFiles() {
        return true;
    }

    public boolean canReadFileData() {
        return true;
    }

    public boolean canWriteFileData() {
        return false;
    }

    public boolean canHaveDirectories() {
        return false;
    }

    public boolean canDeleteFile() {
        return false;
    }

    public byte[] getFileData(FileEntry fileEntry) {
        if (!(fileEntry instanceof RdosFileEntry)) {
            throw new IllegalArgumentException(this.textBundle.get("RdosFormatDisk.IncorrectFileEntryError"));
        }
        RdosFileEntry rdosFileEntry = (RdosFileEntry)fileEntry;
        int n = rdosFileEntry.getStartingBlock();
        byte[] byArray = new byte[rdosFileEntry.getSizeInBlocks() * 256];
        int n2 = 0;
        for (int i = 0; i < rdosFileEntry.getSizeInBlocks(); ++i) {
            byte[] byArray2 = this.readRdosBlock(n + i);
            System.arraycopy(byArray2, 0, byArray, n2, byArray2.length);
            n2 += byArray2.length;
        }
        return byArray;
    }

    public void format() {
        this.getImageOrder().format();
        this.writeBootCode();
        byte[] byArray = this.readSector(0, 13);
        AppleUtil.setString(byArray, 224, this.textBundle.get("RdosFormatDisk.IdentifierText"), 32);
        this.writeSector(0, 13, byArray);
        byArray = new byte[256];
        byArray[0] = 96;
        this.writeSector(1, 9, byArray);
        byte[] byArray2 = this.readRdosBlock(13);
        AppleUtil.setString(byArray2, 0, this.textBundle.get("RdosFormatDisk.InitialSystemFile"), 24);
        AppleUtil.setString(byArray2, 24, "B", 1);
        byArray2[25] = 26;
        AppleUtil.setWordValue(byArray2, 26, 4096);
        AppleUtil.setWordValue(byArray2, 28, 6656);
        AppleUtil.setWordValue(byArray2, 30, 0);
        this.writeRdosBlock(13, byArray2);
    }

    public int getLogicalDiskNumber() {
        return 0;
    }

    public String getSuggestedFilename(String string) {
        int n = Math.min(string.length(), 24);
        return string.toUpperCase().substring(0, n).trim();
    }

    public String getSuggestedFiletype(String string) {
        String string2;
        String string3 = "B";
        int n = string.lastIndexOf(".");
        if (n > 0 && "txt".equalsIgnoreCase(string2 = string.substring(n + 1))) {
            string3 = "T";
        }
        return string3;
    }

    public String[] getFiletypes() {
        return filetypes;
    }

    public boolean needsAddress(String string) {
        return "B".equals(string);
    }

    public boolean supportsDiskMap() {
        return true;
    }

    public void changeImageOrder(ImageOrder imageOrder) {
        AppleUtil.changeImageOrderByTrackAndSector(this.getImageOrder(), imageOrder);
        this.setImageOrder(imageOrder);
    }

    public void setFileData(FileEntry fileEntry, byte[] byArray) throws DiskFullException {
    }

    public DirectoryEntry createDirectory() throws DiskFullException {
        throw new UnsupportedOperationException(this.textBundle.get("DirectoryCreationNotSupported"));
    }

    public DirectoryEntry createDirectory(String string) throws DiskFullException {
        throw new UnsupportedOperationException(this.textBundle.get("DirectoryCreationNotSupported"));
    }

    private class RdosDiskUsage
    implements FormattedDisk.DiskUsage {
        private int location = -1;
        private BitSet bitmap = null;

        private RdosDiskUsage() {
        }

        public boolean hasNext() {
            return this.location == -1 || this.location < 454;
        }

        public void next() {
            if (this.bitmap == null) {
                this.bitmap = new BitSet(455);
                for (int i = 0; i < 455; ++i) {
                    this.bitmap.set(i);
                }
                for (RdosFileEntry rdosFileEntry : RdosFormatDisk.this.getFiles()) {
                    if (rdosFileEntry.isDeleted()) continue;
                    for (int i = 0; i < rdosFileEntry.getSizeInBlocks(); ++i) {
                        this.bitmap.clear(rdosFileEntry.getStartingBlock() + i);
                    }
                }
                this.location = 0;
            } else {
                ++this.location;
            }
        }

        public boolean isFree() {
            return this.bitmap.get(this.location);
        }

        public boolean isUsed() {
            return !this.bitmap.get(this.location);
        }
    }
}

