/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.storage.os.prodos;

import com.webcodepro.applecommander.storage.DirectoryEntry;
import com.webcodepro.applecommander.storage.DiskFullException;
import com.webcodepro.applecommander.storage.FileEntry;
import com.webcodepro.applecommander.storage.FormattedDisk;
import com.webcodepro.applecommander.storage.StorageBundle;
import com.webcodepro.applecommander.storage.os.prodos.ProdosCommonDirectoryHeader;
import com.webcodepro.applecommander.storage.os.prodos.ProdosCommonEntry;
import com.webcodepro.applecommander.storage.os.prodos.ProdosDirectoryEntry;
import com.webcodepro.applecommander.storage.os.prodos.ProdosDiskSizeDoesNotMatchException;
import com.webcodepro.applecommander.storage.os.prodos.ProdosFileEntry;
import com.webcodepro.applecommander.storage.os.prodos.ProdosSubdirectoryHeader;
import com.webcodepro.applecommander.storage.os.prodos.ProdosVolumeDirectoryHeader;
import com.webcodepro.applecommander.storage.physical.ImageOrder;
import com.webcodepro.applecommander.util.AppleUtil;
import com.webcodepro.applecommander.util.TextBundle;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;

public class ProdosFormatDisk
extends FormattedDisk {
    private TextBundle textBundle = StorageBundle.getInstance();
    private static final int NEXT_BLOCK_POINTER = 2;
    private static final int PREV_BLOCK_POINTER = 0;
    private static final int VOLUME_DIRECTORY_BLOCK = 2;
    private static ProdosFileType[] fileTypes;
    private static String[] filetypeStrings;
    private ProdosVolumeDirectoryHeader volumeHeader = new ProdosVolumeDirectoryHeader(this);

    public ProdosFormatDisk(String string, ImageOrder imageOrder) {
        super(string, imageOrder);
        this.initialize();
    }

    protected void initialize() {
        if (fileTypes != null) {
            return;
        }
        fileTypes = new ProdosFileType[256];
        InputStream inputStream = this.getClass().getResourceAsStream("ProdosFileTypes.properties");
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
            for (int i = 0; i < 256; ++i) {
                String string = AppleUtil.getFormattedByte(i).toLowerCase();
                String string2 = (String)properties.get("filetype." + string);
                if (string2 == null || string2.length() == 0) {
                    string2 = "$" + string.toUpperCase();
                }
                boolean bl = Boolean.valueOf((String)properties.get("filetype." + string + ".address"));
                boolean bl2 = Boolean.valueOf((String)properties.get("filetype." + string + ".compile"));
                ProdosFormatDisk.fileTypes[i] = new ProdosFileType((byte)i, string2, bl, bl2);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static ProdosFormatDisk[] create(String string, String string2, ImageOrder imageOrder) {
        ProdosFormatDisk prodosFormatDisk = new ProdosFormatDisk(string, imageOrder);
        prodosFormatDisk.format();
        prodosFormatDisk.setDiskName(string2);
        return new ProdosFormatDisk[]{prodosFormatDisk};
    }

    public String getFormat() {
        return this.textBundle.get("Prodos");
    }

    public FileEntry createFile() throws DiskFullException {
        return this.createFile(this.volumeHeader);
    }

    public FileEntry createFile(ProdosCommonDirectoryHeader prodosCommonDirectoryHeader) throws DiskFullException {
        int n;
        int n2 = n = prodosCommonDirectoryHeader.getFileEntryBlock();
        while (n != 0) {
            Object object;
            int n3;
            byte[] byArray = this.readBlock(n);
            int n4 = 4;
            while (n4 + 39 < 512) {
                n3 = AppleUtil.getUnsignedByte(byArray[n4]);
                if ((n3 & 0xF0) == 0) {
                    object = new ProdosFileEntry(this, n, n4);
                    ((ProdosFileEntry)object).setKeyPointer(0);
                    ((ProdosCommonEntry)object).setCreationDate(new Date());
                    ((ProdosCommonEntry)object).setProdosVersion(0);
                    ((ProdosCommonEntry)object).setMinimumProdosVersion(0);
                    ((ProdosCommonEntry)object).setCanDestroy(true);
                    ((ProdosCommonEntry)object).setCanRead(true);
                    ((ProdosCommonEntry)object).setCanRename(true);
                    ((ProdosCommonEntry)object).setCanWrite(true);
                    ((ProdosCommonEntry)object).setSeedlingFile();
                    ((ProdosFileEntry)object).setHeaderPointer(n2);
                    ((ProdosFileEntry)object).setFilename(this.textBundle.get("ProdosFormatDisk.Blank"));
                    prodosCommonDirectoryHeader.incrementFileCount();
                    return object;
                }
                n4 += 39;
            }
            n3 = AppleUtil.getWordValue(byArray, 2);
            if (n3 == 0 && prodosCommonDirectoryHeader instanceof ProdosSubdirectoryHeader) {
                object = this.readVolumeBitMap();
                n3 = this.findFreeBlock((byte[])object);
                this.setBlockUsed((byte[])object, n3);
                this.writeVolumeBitMap((byte[])object);
                byte[] byArray2 = this.readBlock(n);
                AppleUtil.setWordValue(byArray2, 2, n3);
                this.writeBlock(n, byArray2);
                byte[] byArray3 = new byte[512];
                AppleUtil.setWordValue(byArray3, 0, n);
                this.writeBlock(n3, byArray3);
                ProdosSubdirectoryHeader prodosSubdirectoryHeader = (ProdosSubdirectoryHeader)prodosCommonDirectoryHeader;
                int n5 = prodosSubdirectoryHeader.getProdosDirectoryEntry().getBlocksUsed();
                prodosSubdirectoryHeader.getProdosDirectoryEntry().setBlocksUsed(++n5);
                prodosSubdirectoryHeader.getProdosDirectoryEntry().setEofPosition(n5 * 512);
            }
            n = n3;
        }
        throw new DiskFullException(this.textBundle.get("ProdosFormatDisk.UnableToAllocateSpaceError"));
    }

    public List getFiles() {
        return this.getFiles(2);
    }

    protected List getFiles(int n) {
        ArrayList<ProdosFileEntry> arrayList = new ArrayList<ProdosFileEntry>();
        while (n != 0) {
            byte[] byArray = this.readBlock(n);
            int n2 = 4;
            while (n2 + 39 < 512) {
                ProdosCommonEntry prodosCommonEntry = new ProdosCommonEntry(this, n, n2);
                if (!(prodosCommonEntry.isVolumeHeader() || prodosCommonEntry.isSubdirectoryHeader() || prodosCommonEntry.isEmpty())) {
                    ProdosFileEntry prodosFileEntry = new ProdosFileEntry(this, n, n2);
                    if (prodosFileEntry.isDirectory()) {
                        int n3 = prodosFileEntry.getKeyPointer();
                        ProdosDirectoryEntry prodosDirectoryEntry = new ProdosDirectoryEntry(this, n, n2, new ProdosSubdirectoryHeader(this, n3));
                        arrayList.add(prodosDirectoryEntry);
                    } else {
                        arrayList.add(prodosFileEntry);
                    }
                }
                n2 += 39;
            }
            n = AppleUtil.getWordValue(byArray, 2);
        }
        return arrayList;
    }

    public int getFreeSpace() {
        return this.getFreeBlocks() * 512;
    }

    public int getFreeBlocks() {
        int n = 0;
        int n2 = (this.volumeHeader.getTotalBlocks() + 4095) / 4096;
        int n3 = this.volumeHeader.getBitMapPointer();
        for (int i = 0; i < n2; ++i) {
            byte[] byArray = this.readBlock(n3 + i);
            for (int j = 0; j < byArray.length; ++j) {
                n += AppleUtil.getBitCount(byArray[j]);
            }
        }
        return n;
    }

    public int getUsedSpace() {
        return this.getUsedBlocks() * 512;
    }

    public int getUsedBlocks() {
        return this.volumeHeader.getTotalBlocks() - this.getFreeBlocks();
    }

    public boolean canCreateDirectories() {
        return true;
    }

    public boolean canCreateFile() {
        return true;
    }

    public String getDiskName() {
        return "/" + this.volumeHeader.getVolumeName() + "/";
    }

    public void setDiskName(String string) {
        this.volumeHeader.setVolumeName(string);
    }

    public int[] getBitmapDimensions() {
        return null;
    }

    public int getBitmapLength() {
        return this.volumeHeader.getTotalBlocks();
    }

    public FormattedDisk.DiskUsage getDiskUsage() {
        return new ProdosDiskUsage();
    }

    public String[] getBitmapLabels() {
        return new String[]{this.textBundle.get("Block")};
    }

    public List getDiskInformation() {
        List list = super.getDiskInformation();
        list.add((FormattedDisk)this.new FormattedDisk.DiskInformation(this.textBundle.get("TotalBlocks"), this.volumeHeader.getTotalBlocks()));
        list.add((FormattedDisk)this.new FormattedDisk.DiskInformation(this.textBundle.get("FreeBlocks"), this.getFreeBlocks()));
        list.add((FormattedDisk)this.new FormattedDisk.DiskInformation(this.textBundle.get("UsedBlocks"), this.getUsedBlocks()));
        list.add((FormattedDisk)this.new FormattedDisk.DiskInformation(this.textBundle.get("ProdosFormatDisk.VolumeAccess"), (this.volumeHeader.canDestroy() ? this.textBundle.get("Destroy") : "") + (this.volumeHeader.canRead() ? this.textBundle.get("Read") : "") + (this.volumeHeader.canRename() ? this.textBundle.get("Rename") : "") + (this.volumeHeader.canWrite() ? this.textBundle.get("Write") : "")));
        list.add((FormattedDisk)this.new FormattedDisk.DiskInformation(this.textBundle.get("ProdosFormatDisk.BitmapBlockNumber"), this.volumeHeader.getBitMapPointer()));
        list.add((FormattedDisk)this.new FormattedDisk.DiskInformation(this.textBundle.get("ProdosFormatDisk.CreationDate"), this.volumeHeader.getCreationDate()));
        list.add((FormattedDisk)this.new FormattedDisk.DiskInformation(this.textBundle.get("ProdosFormatDisk.FileEntriesPerBlock"), this.volumeHeader.getEntriesPerBlock()));
        list.add((FormattedDisk)this.new FormattedDisk.DiskInformation(this.textBundle.get("ProdosFormatDisk.FileEntryLength"), this.volumeHeader.getEntryLength()));
        list.add((FormattedDisk)this.new FormattedDisk.DiskInformation(this.textBundle.get("ProdosFormatDisk.ActiveFilesInRootDirectory"), this.volumeHeader.getFileCount()));
        list.add((FormattedDisk)this.new FormattedDisk.DiskInformation(this.textBundle.get("ProdosFormatDisk.MinimumVersionProdos"), this.volumeHeader.getMinimumProdosVersion()));
        list.add((FormattedDisk)this.new FormattedDisk.DiskInformation(this.textBundle.get("ProdosFormatDisk.CreationVersionProdos"), this.volumeHeader.getProdosVersion()));
        list.add((FormattedDisk)this.new FormattedDisk.DiskInformation(this.textBundle.get("ProdosFormatDisk.VolumeName"), this.volumeHeader.getVolumeName()));
        return list;
    }

    public List getFileColumnHeaders(int n) {
        ArrayList<FormattedDisk.FileColumnHeader> arrayList = new ArrayList<FormattedDisk.FileColumnHeader>();
        switch (n) {
            case 2: {
                arrayList.add(new FormattedDisk.FileColumnHeader(" ", 1, 2));
                arrayList.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("Name"), 15, 1));
                arrayList.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("Filetype"), 8, 2));
                arrayList.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("Blocks"), 3, 3));
                arrayList.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("Modified"), 10, 2));
                arrayList.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("ProdosFormatDisk.Created"), 10, 2));
                arrayList.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("ProdosFormatDisk.Length"), 10, 3));
                arrayList.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("ProdosFormatDisk.AuxType"), 8, 1));
                break;
            }
            case 3: {
                arrayList.add(new FormattedDisk.FileColumnHeader(" ", 1, 2));
                arrayList.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("Name"), 15, 1));
                arrayList.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("DeletedQ"), 7, 2));
                arrayList.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("ProdosFormatDisk.Permissions"), 8, 1));
                arrayList.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("Filetype"), 8, 2));
                arrayList.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("ProdosFormatDisk.DirectoryQ"), 9, 2));
                arrayList.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("Blocks"), 3, 3));
                arrayList.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("Modified"), 10, 2));
                arrayList.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("ProdosFormatDisk.Created"), 10, 2));
                arrayList.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("ProdosFormatDisk.Length"), 10, 3));
                arrayList.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("ProdosFormatDisk.AuxType"), 8, 1));
                arrayList.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("ProdosFormatDisk.DirectoryHeader"), 5, 3));
                arrayList.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("ProdosFormatDisk.KeyBlock"), 5, 3));
                arrayList.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("ProdosFormatDisk.KeyType"), 8, 1));
                arrayList.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("ProdosFormatDisk.Changed"), 5, 2));
                arrayList.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("ProdosFormatDisk.MinimumProdosVersion"), 2, 2));
                arrayList.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("ProdosFormatDisk.ProdosVersion"), 2, 2));
                break;
            }
            default: {
                arrayList.addAll(super.getFileColumnHeaders(n));
            }
        }
        return arrayList;
    }

    public boolean supportsDeletedFiles() {
        return true;
    }

    public boolean canReadFileData() {
        return true;
    }

    public boolean canHaveDirectories() {
        return true;
    }

    public boolean canWriteFileData() {
        return true;
    }

    public boolean canDeleteFile() {
        return true;
    }

    public byte[] getFileData(FileEntry fileEntry) {
        if (!(fileEntry instanceof ProdosFileEntry)) {
            throw new IllegalArgumentException(this.textBundle.get("ProdosFormatDisk.MustHaveEntry"));
        }
        ProdosFileEntry prodosFileEntry = (ProdosFileEntry)fileEntry;
        byte[] byArray = new byte[prodosFileEntry.getEofPosition()];
        if (prodosFileEntry.isSeedlingFile()) {
            byte[] byArray2 = this.readBlock(prodosFileEntry.getKeyPointer());
            System.arraycopy(byArray2, 0, byArray, 0, prodosFileEntry.getEofPosition());
        } else if (prodosFileEntry.isSaplingFile()) {
            byte[] byArray3 = this.readBlock(prodosFileEntry.getKeyPointer());
            this.getIndexBlockData(byArray, byArray3, 0);
        } else if (prodosFileEntry.isTreeFile()) {
            byte[] byArray4 = this.readBlock(prodosFileEntry.getKeyPointer());
            int n = 0;
            for (int i = 0; i < 256; ++i) {
                int n2 = AppleUtil.getWordValue(byArray4[i], byArray4[i + 256]);
                if (n2 <= 0) continue;
                byte[] byArray5 = this.readBlock(n2);
                n = this.getIndexBlockData(byArray, byArray5, n);
            }
        } else {
            throw new IllegalArgumentException(this.textBundle.get("ProdosFormatDisk.UnknownStorageType"));
        }
        return byArray;
    }

    protected void freeBlocks(ProdosFileEntry prodosFileEntry) {
        byte[] byArray = this.readVolumeBitMap();
        int n = prodosFileEntry.getKeyPointer();
        if (n == 0) {
            return;
        }
        if (prodosFileEntry.isGEOSFile()) {
            this.setBlockFree(byArray, prodosFileEntry.getAuxiliaryType());
        }
        this.setBlockFree(byArray, n);
        if (prodosFileEntry.isSaplingFile()) {
            this.freeBlocksInIndex(byArray, n, false);
        } else if (prodosFileEntry.isTreeFile()) {
            byte[] byArray2 = this.readBlock(n);
            for (int i = 0; i < 256; ++i) {
                int n2;
                if (prodosFileEntry.isGEOSFile() && (!prodosFileEntry.isGEOSFile() || i >= 254) || (n2 = AppleUtil.getWordValue(byArray2[i], byArray2[i + 256])) <= 0) continue;
                this.freeBlocksInIndex(byArray, n2, prodosFileEntry.isGEOSFile());
            }
        }
        this.writeVolumeBitMap(byArray);
    }

    private void freeBlocksInIndex(byte[] byArray, int n, boolean bl) {
        this.setBlockFree(byArray, n);
        byte[] byArray2 = this.readBlock(n);
        for (int i = 0; i < 256; ++i) {
            int n2;
            if (bl && (!bl || i >= 254) || (n2 = AppleUtil.getWordValue(byArray2[i], byArray2[i + 256])) <= 0) continue;
            this.setBlockFree(byArray, n2);
        }
    }

    protected int getIndexBlockData(byte[] byArray, byte[] byArray2, int n) {
        for (int i = 0; i < 256; ++i) {
            int n2 = AppleUtil.getWordValue(byArray2[i], byArray2[i + 256]);
            byte[] byArray3 = this.readBlock(n2);
            if (n + byArray3.length > byArray.length) {
                int n3 = byArray.length - n;
                if (n2 != 0) {
                    System.arraycopy(byArray3, 0, byArray, n, n3);
                }
                n += n3;
                break;
            }
            if (n2 != 0) {
                System.arraycopy(byArray3, 0, byArray, n, byArray3.length);
            }
            n += byArray3.length;
        }
        return n;
    }

    protected void setFileData(ProdosFileEntry prodosFileEntry, byte[] byArray) throws DiskFullException {
        if (prodosFileEntry.isGEOSFile()) {
            this.setGEOSFileData(prodosFileEntry, byArray);
        } else {
            int n;
            int n2 = (byArray.length + 512 - 1) / 512;
            if (byArray.length == 0) {
                n2 = 1;
            }
            if ((n = n2) > 1) {
                n += (n2 - 1) / 256 + 1;
                if (n2 > 256) {
                    ++n;
                }
            }
            if (n > this.getFreeBlocks() + prodosFileEntry.getBlocksUsed()) {
                throw new DiskFullException(this.textBundle.format("ProdosFormatDisk.NotEnoughSpaceOnDiskError", n, this.getFreeBlocks()));
            }
            this.freeBlocks(prodosFileEntry);
            byte[] byArray2 = this.readVolumeBitMap();
            int n3 = prodosFileEntry.getKeyPointer();
            if (n3 == 0) {
                n3 = this.findFreeBlock(byArray2);
            }
            int n4 = 0;
            byte[] byArray3 = null;
            int n5 = 0;
            byte[] byArray4 = new byte[512];
            int n6 = 0;
            for (int i = 0; i < byArray.length || byArray.length == 0 && i == 0; i += 512) {
                byte by;
                byte by2;
                int n7;
                if (n6 > 0) {
                    n3 = this.findFreeBlock(byArray2);
                }
                this.setBlockUsed(byArray2, n3);
                ++n6;
                byte[] byArray5 = new byte[512];
                int n8 = Math.min(512, byArray.length - i);
                System.arraycopy(byArray, i, byArray5, 0, n8);
                this.writeBlock(n3, byArray5);
                if (n2 <= 1) continue;
                if (i > 0 && i / 512 % 256 == 0) {
                    if (n5 == 0) {
                        n5 = this.findFreeBlock(byArray2);
                        this.setBlockUsed(byArray2, n5);
                        ++n6;
                    }
                    this.writeBlock(n4, byArray3);
                    byArray3 = null;
                    n4 = 0;
                }
                if (byArray3 == null) {
                    n4 = this.findFreeBlock(byArray2);
                    byArray3 = new byte[512];
                    this.setBlockUsed(byArray2, n4);
                    ++n6;
                    n7 = i / 131072;
                    by2 = (byte)(n4 % 256);
                    by = (byte)(n4 / 256);
                    byArray4[n7] = by2;
                    byArray4[n7 + 256] = by;
                }
                n7 = i / 512 % 256;
                by2 = (byte)(n3 % 256);
                by = (byte)(n3 / 256);
                byArray3[n7] = by2;
                byArray3[n7 + 256] = by;
            }
            if (n2 == 1) {
                prodosFileEntry.setKeyPointer(n3);
                prodosFileEntry.setSeedlingFile();
            } else if (n2 <= 256) {
                this.writeBlock(n4, byArray3);
                prodosFileEntry.setKeyPointer(n4);
                prodosFileEntry.setSaplingFile();
            } else {
                this.writeBlock(n4, byArray3);
                this.writeBlock(n5, byArray4);
                prodosFileEntry.setKeyPointer(n5);
                prodosFileEntry.setTreeFile();
            }
            prodosFileEntry.setBlocksUsed(n6);
            prodosFileEntry.setEofPosition(byArray.length);
            prodosFileEntry.setLastModificationDate(new Date());
            this.writeVolumeBitMap(byArray2);
        }
    }

    protected void setFileData(ProdosFileEntry prodosFileEntry, byte[] byArray, byte[] byArray2) throws DiskFullException {
        byte by;
        byte by2;
        int n;
        int n2;
        byte[] byArray3;
        int n3;
        int n4 = (byArray.length + 512 - 1) / 512 + (byArray2.length + 512 - 1) / 512;
        int n5 = n4;
        if (n5 > 1) {
            n5 += (n4 - 1) / 256 + 1;
            if (n4 > 256) {
                ++n5;
            }
        }
        if (n5 > this.getFreeBlocks() + prodosFileEntry.getBlocksUsed()) {
            throw new DiskFullException(this.textBundle.format("ProdosFormatDisk.NotEnoughSpaceOnDiskError", n5, this.getFreeBlocks()));
        }
        this.freeBlocks(prodosFileEntry);
        byte[] byArray4 = this.readVolumeBitMap();
        int n6 = prodosFileEntry.getKeyPointer();
        if (n6 == 0) {
            n6 = this.findFreeBlock(byArray4);
        }
        int n7 = 0;
        int n8 = this.findFreeBlock(byArray4);
        this.setBlockUsed(byArray4, n8);
        byte[] byArray5 = new byte[512];
        int n9 = 0;
        byte[] byArray6 = null;
        int n10 = 0;
        byte[] byArray7 = new byte[512];
        n4 = (byArray.length + 512 - 1) / 512;
        for (n3 = 0; n3 < byArray.length; n3 += 512) {
            n6 = this.findFreeBlock(byArray4);
            this.setBlockUsed(byArray4, n6);
            ++n7;
            byArray3 = new byte[512];
            n2 = Math.min(512, byArray.length - n3);
            System.arraycopy(byArray, n3, byArray3, 0, n2);
            this.writeBlock(n6, byArray3);
            if (n4 <= 1) continue;
            if (n3 > 0 && n3 / 512 % 256 == 0) {
                if (n10 == 0) {
                    n10 = this.findFreeBlock(byArray4);
                    this.setBlockUsed(byArray4, n10);
                    ++n7;
                }
                this.writeBlock(n9, byArray6);
                byArray6 = null;
                n9 = 0;
            }
            if (byArray6 == null) {
                n9 = this.findFreeBlock(byArray4);
                byArray6 = new byte[512];
                this.setBlockUsed(byArray4, n9);
                ++n7;
                n = n3 / 131072;
                by2 = (byte)(n9 % 256);
                by = (byte)(n9 / 256);
                byArray7[n] = by2;
                byArray7[n + 256] = by;
            }
            n = n3 / 512 % 256;
            by2 = (byte)(n6 % 256);
            by = (byte)(n6 / 256);
            byArray6[n] = by2;
            byArray6[n + 256] = by;
        }
        AppleUtil.setWordValue(byArray5, 3, n4);
        AppleUtil.set3ByteValue(byArray5, 5, byArray.length);
        if (n4 == 1) {
            byArray5[0] = 1;
            AppleUtil.setWordValue(byArray5, 1, n6);
        } else if (n4 <= 256) {
            this.writeBlock(n9, byArray6);
            AppleUtil.setWordValue(byArray5, 1, n9);
            byArray5[0] = 2;
        } else {
            this.writeBlock(n9, byArray6);
            this.writeBlock(n10, byArray7);
            AppleUtil.setWordValue(byArray5, 1, n10);
            byArray5[0] = 3;
        }
        ++n7;
        n9 = 0;
        byArray6 = null;
        n10 = 0;
        n4 = (byArray2.length + 512 - 1) / 512;
        for (n3 = 0; n3 < byArray2.length; n3 += 512) {
            if (n7 > 0) {
                n6 = this.findFreeBlock(byArray4);
            }
            this.setBlockUsed(byArray4, n6);
            ++n7;
            byArray3 = new byte[512];
            n2 = Math.min(512, byArray2.length - n3);
            System.arraycopy(byArray2, n3, byArray3, 0, n2);
            this.writeBlock(n6, byArray3);
            if (n4 <= 1) continue;
            if (n3 > 0 && n3 / 512 % 256 == 0) {
                if (n10 == 0) {
                    n10 = this.findFreeBlock(byArray4);
                    this.setBlockUsed(byArray4, n10);
                    ++n7;
                }
                this.writeBlock(n9, byArray6);
                byArray6 = null;
                n9 = 0;
            }
            if (byArray6 == null) {
                n9 = this.findFreeBlock(byArray4);
                byArray6 = new byte[512];
                this.setBlockUsed(byArray4, n9);
                ++n7;
                n = n3 / 131072;
                by2 = (byte)(n9 % 256);
                by = (byte)(n9 / 256);
                byArray7[n] = by2;
                byArray7[n + 256] = by;
            }
            n = n3 / 512 % 256;
            by2 = (byte)(n6 % 256);
            by = (byte)(n6 / 256);
            byArray6[n] = by2;
            byArray6[n + 256] = by;
        }
        AppleUtil.setWordValue(byArray5, 259, n4);
        AppleUtil.set3ByteValue(byArray5, 261, byArray2.length);
        if (n4 == 1) {
            byArray5[256] = 1;
            AppleUtil.setWordValue(byArray5, 257, n6);
        } else if (n4 <= 256) {
            this.writeBlock(n9, byArray6);
            AppleUtil.setWordValue(byArray5, 257, n9);
            byArray5[256] = 2;
        } else {
            this.writeBlock(n9, byArray6);
            this.writeBlock(n10, byArray7);
            AppleUtil.setWordValue(byArray5, 257, n10);
            byArray5[256] = 3;
        }
        this.writeBlock(n8, byArray5);
        prodosFileEntry.setKeyPointer(n8);
        prodosFileEntry.setBlocksUsed(n7);
        prodosFileEntry.setEofPosition(byArray.length + byArray2.length);
        prodosFileEntry.setLastModificationDate(new Date());
        this.writeVolumeBitMap(byArray4);
    }

    protected void setGEOSFileData(ProdosFileEntry prodosFileEntry, byte[] byArray) throws DiskFullException {
        int n;
        int n2 = n = (byArray.length - 1) / 512;
        n2 += (n - 1) / 254 + 1;
        if (n > 254) {
            ++n2;
        }
        if (n2 > this.getFreeBlocks() + prodosFileEntry.getBlocksUsed()) {
            throw new DiskFullException(this.textBundle.format("ProdosFormatDisk.NotEnoughSpaceOnDiskError", n2, this.getFreeBlocks()));
        }
        this.freeBlocks(prodosFileEntry);
        byte[] byArray2 = this.readVolumeBitMap();
        int n3 = this.findFreeBlock(byArray2);
        byte[] byArray3 = new byte[512];
        this.setBlockUsed(byArray2, n3);
        System.arraycopy(byArray, 0, byArray3, 0, 512);
        this.writeBlock(n3, byArray3);
        prodosFileEntry.setAddress(n3);
        if (AppleUtil.getUnsignedByte(byArray[384]) >> 4 == 2) {
            this.setGEOSSaplingData(byArray2, prodosFileEntry, byArray);
        } else {
            this.setGEOSTreeData(byArray2, prodosFileEntry, byArray);
        }
        prodosFileEntry.setGEOSMeta(byArray3);
    }

    protected void setGEOSSaplingData(byte[] byArray, ProdosFileEntry prodosFileEntry, byte[] byArray2) throws DiskFullException {
        int n = this.findFreeBlock(byArray);
        this.setBlockUsed(byArray, n);
        byte[] byArray3 = new byte[512];
        int n2 = 0;
        int n3 = 1;
        for (int i = 512; i < byArray2.length; i += 512) {
            n2 = this.findFreeBlock(byArray);
            this.setBlockUsed(byArray, n2);
            ++n3;
            byte[] byArray4 = new byte[512];
            int n4 = Math.min(512, byArray2.length - i);
            System.arraycopy(byArray2, i, byArray4, 0, n4);
            this.writeBlock(n2, byArray4);
            int n5 = (i - 512) / 512 % 256;
            byte by = (byte)(n2 % 256);
            byte by2 = (byte)(n2 / 256);
            byArray3[n5] = by;
            byArray3[n5 + 256] = by2;
        }
        byArray3[255] = (byte)((byArray2.length - 512) % 256);
        byArray3[511] = (byte)((byArray2.length - 512) / 256);
        this.writeBlock(n, byArray3);
        prodosFileEntry.setKeyPointer(n);
        prodosFileEntry.setSaplingFile();
        prodosFileEntry.setBlocksUsed(n3);
        prodosFileEntry.setEofPosition(byArray2.length - 512);
        prodosFileEntry.setLastModificationDate(new Date());
        this.writeVolumeBitMap(byArray);
    }

    protected void setGEOSTreeData(byte[] byArray, ProdosFileEntry prodosFileEntry, byte[] byArray2) throws DiskFullException {
        int n = this.findFreeBlock(byArray);
        this.setBlockUsed(byArray, n);
        byte[] byArray3 = new byte[512];
        int n2 = 512;
        int n3 = 2;
        int n4 = 0;
        for (int i = 0; i < 254; ++i) {
            if (byArray2[256 + i] != 255 && n2 < byArray2.length) {
                int n5;
                byte[] byArray4 = new byte[512];
                System.arraycopy(byArray2, n2, byArray4, 0, 512);
                n2 += 512;
                int n6 = AppleUtil.getUnsignedByte(byArray4[255]) + AppleUtil.getUnsignedByte(byArray4[511]) * 256;
                int n7 = this.findFreeBlock(byArray);
                this.setBlockUsed(byArray, n7);
                ++n3;
                byte[] byArray5 = new byte[512];
                int n8 = 0;
                int n9 = n2;
                while (n2 < n9 + n6) {
                    n8 = this.findFreeBlock(byArray);
                    this.setBlockUsed(byArray, n8);
                    ++n3;
                    byte[] byArray6 = new byte[512];
                    n5 = Math.min(512, n6 - n2 + n9);
                    System.arraycopy(byArray2, n2, byArray6, 0, n5);
                    this.writeBlock(n8, byArray6);
                    n4 += n5;
                    int n10 = (n2 - n9) / 512 % 256;
                    byte by = (byte)(n8 % 256);
                    byte by2 = (byte)(n8 / 256);
                    byArray5[n10] = by;
                    byArray5[n10 + 256] = by2;
                    n2 += 512;
                }
                byArray5[255] = (byte)(n6 & 0xFF);
                byArray5[511] = (byte)((n6 & 0xFF00) >> 8);
                byArray5[510] = (byte)((n6 & 0xFF0000) >> 16);
                this.writeBlock(n7, byArray5);
                byte by = (byte)(n7 % 256);
                n5 = (byte)(n7 / 256);
                byArray3[i] = by;
                byArray3[i + 256] = n5;
                continue;
            }
            if (byArray2[256 + i] != 255) continue;
            byArray3[i] = -1;
            byArray3[i + 256] = -1;
        }
        byArray3[255] = (byte)(n4 & 0xFF);
        byArray3[511] = (byte)((n4 & 0xFF00) >> 8);
        byArray3[510] = (byte)((n4 & 0xFF0000) >> 16);
        this.writeBlock(n, byArray3);
        prodosFileEntry.setKeyPointer(n);
        prodosFileEntry.setTreeFile();
        prodosFileEntry.setBlocksUsed(n3);
        prodosFileEntry.setEofPosition(n4);
        prodosFileEntry.setLastModificationDate(new Date());
        this.writeVolumeBitMap(byArray);
    }

    protected int findFreeBlock(byte[] byArray) throws DiskFullException {
        int n = this.getBitmapLength();
        for (int i = 1; i < n; ++i) {
            if (!this.isBlockFree(byArray, i)) continue;
            if ((i + 1) * 512 < this.getPhysicalSize()) {
                return i;
            }
            throw new ProdosDiskSizeDoesNotMatchException(this.textBundle.get("ProdosFormatDisk.ProdosDiskSizeDoesNotMatchError"));
        }
        throw new DiskFullException(this.textBundle.get("ProdosFormatDisk.NoFreeBlockAvailableError"));
    }

    public byte[] readVolumeBitMap() {
        int n = this.volumeHeader.getBitMapPointer();
        int n2 = this.volumeHeader.getTotalBlocks();
        int n3 = n2 / 4096 + 1;
        byte[] byArray = new byte[n3 * 512];
        for (int i = 0; i < n3; ++i) {
            System.arraycopy(this.readBlock(n + i), 0, byArray, i * 512, 512);
        }
        return byArray;
    }

    public void writeVolumeBitMap(byte[] byArray) {
        int n = this.volumeHeader.getBitMapPointer();
        int n2 = this.volumeHeader.getTotalBlocks();
        int n3 = n2 / 4096 + 1;
        if (byArray.length != n3 * 512) {
            throw new IllegalArgumentException(this.textBundle.get("ProdosFormatDisk.UnexpectedVolumeBitMapSizeError"));
        }
        byte[] byArray2 = new byte[512];
        for (int i = 0; i < n3; ++i) {
            System.arraycopy(byArray, i * 512, byArray2, 0, 512);
            this.writeBlock(n + i, byArray2);
        }
    }

    public boolean isBlockFree(byte[] byArray, int n) {
        int n2 = n / 8;
        int n3 = 7 - n % 8;
        boolean bl = AppleUtil.isBitSet(byArray[n2], n3);
        return bl;
    }

    public void setBlockFree(byte[] byArray, int n) {
        int n2 = n / 8;
        int n3 = 7 - n % 8;
        byArray[n2] = AppleUtil.setBit(byArray[n2], n3);
    }

    public boolean isBlockUsed(byte[] byArray, int n) {
        return !this.isBlockFree(byArray, n);
    }

    public void setBlockUsed(byte[] byArray, int n) {
        int n2 = n / 8;
        int n3 = 7 - n % 8;
        byArray[n2] = AppleUtil.clearBit(byArray[n2], n3);
    }

    public void format() {
        int n;
        this.getImageOrder().format();
        this.writeBootCode();
        String string = this.volumeHeader.getVolumeName();
        int n2 = this.getPhysicalSize() / 512;
        int n3 = n2 / 4096 + 7;
        byte[] byArray = new byte[512];
        for (int i = 2; i < 6; ++i) {
            n = i < 5 ? i + 1 : 0;
            int n4 = i > 2 ? i - 1 : 0;
            AppleUtil.setWordValue(byArray, 0, n4);
            AppleUtil.setWordValue(byArray, 2, n);
            this.writeBlock(i, byArray);
        }
        this.volumeHeader.setVolumeHeader();
        this.volumeHeader.setVolumeName(string);
        this.volumeHeader.setCreationDate(new Date());
        this.volumeHeader.setProdosVersion(0);
        this.volumeHeader.setMinimumProdosVersion(0);
        this.volumeHeader.setHasChanged(true);
        this.volumeHeader.setCanDestroy(true);
        this.volumeHeader.setCanRead(true);
        this.volumeHeader.setCanRename(true);
        this.volumeHeader.setCanWrite(true);
        this.volumeHeader.setEntryLength();
        this.volumeHeader.setEntriesPerBlock();
        this.volumeHeader.setFileCount(0);
        this.volumeHeader.setBitMapPointer(6);
        this.volumeHeader.setTotalBlocks(n2);
        byte[] byArray2 = this.readVolumeBitMap();
        for (n = 0; n < n2; ++n) {
            if (n < n3) {
                this.setBlockUsed(byArray2, n);
                continue;
            }
            this.setBlockFree(byArray2, n);
        }
        this.writeVolumeBitMap(byArray2);
    }

    public int getLogicalDiskNumber() {
        return 0;
    }

    public String getSuggestedFilename(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (!Character.isLetter(string.charAt(0))) {
            stringBuffer.append('A');
        }
        for (int i = 0; stringBuffer.length() < 15 && i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!Character.isLetterOrDigit(c) && c != '.') continue;
            stringBuffer.append(c);
        }
        return stringBuffer.toString().toUpperCase().trim();
    }

    public String getSuggestedFiletype(String string) {
        String string2;
        ProdosFileType prodosFileType;
        String string3 = "BIN";
        int n = string.lastIndexOf(".");
        if (n > 0 && (prodosFileType = this.findFileType(string2 = string.substring(n + 1))) != null) {
            string3 = prodosFileType.getString();
        }
        return string3;
    }

    public String getFiletype(int n) {
        ProdosFileType prodosFileType = fileTypes[n];
        return prodosFileType.getString();
    }

    public byte getFiletype(String string) {
        ProdosFileType prodosFileType = this.findFileType(string);
        if (prodosFileType != null) {
            return prodosFileType.getType();
        }
        return 0;
    }

    public ProdosFileType findFileType(String string) {
        for (int i = 0; i < fileTypes.length; ++i) {
            if (!string.equalsIgnoreCase(fileTypes[i].getString())) continue;
            return fileTypes[i];
        }
        return null;
    }

    public String[] getFiletypes() {
        if (filetypeStrings == null) {
            filetypeStrings = new String[fileTypes.length];
            for (int i = 0; i < fileTypes.length; ++i) {
                ProdosFormatDisk.filetypeStrings[i] = fileTypes[i].getString();
            }
        }
        return filetypeStrings;
    }

    public boolean needsAddress(String string) {
        ProdosFileType prodosFileType = this.findFileType(string);
        if (prodosFileType != null) {
            return prodosFileType.needsAddress();
        }
        return false;
    }

    public boolean canCompile(String string) {
        ProdosFileType prodosFileType = this.findFileType(string);
        if (prodosFileType != null) {
            return prodosFileType.canCompile();
        }
        return false;
    }

    public boolean supportsDiskMap() {
        return true;
    }

    public void changeImageOrder(ImageOrder imageOrder) {
        AppleUtil.changeImageOrderByBlock(this.getImageOrder(), imageOrder);
        this.setImageOrder(imageOrder);
    }

    public void setFileData(FileEntry fileEntry, byte[] byArray) throws DiskFullException {
        this.setFileData((ProdosFileEntry)fileEntry, byArray);
    }

    protected ProdosVolumeDirectoryHeader getVolumeHeader() {
        return this.volumeHeader;
    }

    public DirectoryEntry createDirectory(String string) throws DiskFullException {
        return this.createDirectory(this.getVolumeHeader(), string);
    }

    public DirectoryEntry createDirectory(ProdosCommonDirectoryHeader prodosCommonDirectoryHeader, String string) throws DiskFullException {
        int n = prodosCommonDirectoryHeader.getFileEntryBlock();
        while (n != 0) {
            byte[] byArray;
            byte[] byArray2;
            int n2;
            byte[] byArray3 = this.readBlock(n);
            int n3 = 0;
            int n4 = 4;
            while (n4 + 39 < 512) {
                n2 = AppleUtil.getUnsignedByte(byArray3[n4]);
                if ((n2 & 0xF0) == 0) {
                    byArray2 = this.readVolumeBitMap();
                    int n5 = this.findFreeBlock(byArray2);
                    this.setBlockUsed(byArray2, n5);
                    byArray = new byte[512];
                    for (int i = 0; i < 512; ++i) {
                        byArray[i] = 0;
                    }
                    this.writeBlock(n5, byArray);
                    this.writeVolumeBitMap(byArray2);
                    ProdosSubdirectoryHeader prodosSubdirectoryHeader = new ProdosSubdirectoryHeader(this, n5);
                    ProdosFileEntry prodosFileEntry = (ProdosFileEntry)this.createFile(prodosSubdirectoryHeader);
                    prodosFileEntry.setFilename(string);
                    prodosSubdirectoryHeader.setHousekeeping();
                    prodosSubdirectoryHeader.setCreationDate(new Date());
                    prodosSubdirectoryHeader.setParentPointer(n);
                    prodosSubdirectoryHeader.setParentEntry(n3);
                    prodosSubdirectoryHeader.setParentEntryLength(39);
                    ProdosDirectoryEntry prodosDirectoryEntry = new ProdosDirectoryEntry(this, n, n4, prodosSubdirectoryHeader);
                    prodosDirectoryEntry.setBlocksUsed(1);
                    prodosDirectoryEntry.setEofPosition(512);
                    prodosDirectoryEntry.setKeyPointer(n5);
                    prodosDirectoryEntry.setCreationDate(new Date());
                    prodosDirectoryEntry.setLastModificationDate(new Date());
                    prodosDirectoryEntry.setProdosVersion(0);
                    prodosDirectoryEntry.setMinimumProdosVersion(0);
                    prodosDirectoryEntry.setCanDestroy(true);
                    prodosDirectoryEntry.setCanRead(true);
                    prodosDirectoryEntry.setCanRename(true);
                    prodosDirectoryEntry.setCanWrite(true);
                    prodosDirectoryEntry.setSubdirectory();
                    prodosDirectoryEntry.setHeaderPointer(n);
                    prodosDirectoryEntry.setFilename(string);
                    prodosDirectoryEntry.setFiletype(15L);
                    prodosCommonDirectoryHeader.incrementFileCount();
                    return prodosDirectoryEntry;
                }
                n4 += 39;
                ++n3;
            }
            n2 = AppleUtil.getWordValue(byArray3, 2);
            if (n2 == 0 && prodosCommonDirectoryHeader instanceof ProdosSubdirectoryHeader) {
                byArray2 = this.readVolumeBitMap();
                n2 = this.findFreeBlock(byArray2);
                this.setBlockUsed(byArray2, n2);
                this.writeVolumeBitMap(byArray2);
                byte[] byArray4 = this.readBlock(n);
                AppleUtil.setWordValue(byArray4, 2, n2);
                this.writeBlock(n, byArray4);
                byArray = new byte[512];
                AppleUtil.setWordValue(byArray, 0, n);
                this.writeBlock(n2, byArray);
                ProdosSubdirectoryHeader prodosSubdirectoryHeader = (ProdosSubdirectoryHeader)prodosCommonDirectoryHeader;
                int n6 = prodosSubdirectoryHeader.getProdosDirectoryEntry().getBlocksUsed();
                prodosSubdirectoryHeader.getProdosDirectoryEntry().setBlocksUsed(++n6);
                prodosSubdirectoryHeader.getProdosDirectoryEntry().setEofPosition(n6 * 512);
            }
            n = n2;
        }
        throw new DiskFullException(this.textBundle.get("ProdosFormatDisk.UnableToAllocateSpaceError"));
    }

    private class ProdosDiskUsage
    implements FormattedDisk.DiskUsage {
        private int location = -1;
        private transient byte[] data = null;

        private ProdosDiskUsage() {
        }

        public boolean hasNext() {
            return this.location == -1 || this.location < ProdosFormatDisk.this.getVolumeHeader().getTotalBlocks() - 1;
        }

        public void next() {
            ++this.location;
        }

        public boolean isFree() {
            if (this.location == -1) {
                throw new IllegalArgumentException(StorageBundle.getInstance().get("ProdosFormatDisk.InvalidDimensionError"));
            }
            if (this.data == null) {
                this.data = ProdosFormatDisk.this.readVolumeBitMap();
            }
            return ProdosFormatDisk.this.isBlockFree(this.data, this.location);
        }

        public boolean isUsed() {
            return !this.isFree();
        }
    }

    private class ProdosFileType {
        private byte type;
        private String string;
        private boolean addressRequired;
        private boolean canCompile;

        public ProdosFileType(byte by, String string, boolean bl, boolean bl2) {
            this.type = by;
            this.string = string;
            this.addressRequired = bl;
            this.canCompile = bl2;
        }

        public byte getType() {
            return this.type;
        }

        public String getString() {
            return this.string;
        }

        public boolean needsAddress() {
            return this.addressRequired;
        }

        public boolean canCompile() {
            return this.canCompile;
        }
    }
}

