/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.ui.swt.wizard.exportfile;

import com.webcodepro.applecommander.ui.UiBundle;
import com.webcodepro.applecommander.ui.swt.wizard.WizardPane;
import com.webcodepro.applecommander.ui.swt.wizard.exportfile.ExportWizard;
import com.webcodepro.applecommander.util.TextBundle;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ExportFileDestinationPane
extends WizardPane {
    private TextBundle textBundle = UiBundle.getInstance();
    private Composite parent;
    private Object layoutData;
    private Composite control;
    private ExportWizard wizard;
    private Text directoryText;

    public ExportFileDestinationPane(Composite composite, ExportWizard exportWizard, Object object) {
        this.parent = composite;
        this.wizard = exportWizard;
        this.layoutData = object;
    }

    public WizardPane getNextPane() {
        return null;
    }

    public void open() {
        this.control = new Composite(this.parent, 0);
        this.control.setLayoutData(this.layoutData);
        this.wizard.enableNextButton(false);
        this.wizard.enableFinishButton(true);
        RowLayout rowLayout = new RowLayout(512);
        rowLayout.justify = true;
        rowLayout.marginBottom = 5;
        rowLayout.marginLeft = 5;
        rowLayout.marginRight = 5;
        rowLayout.marginTop = 5;
        rowLayout.spacing = 3;
        this.control.setLayout((Layout)rowLayout);
        Label label = new Label(this.control, 64);
        label.setText(this.textBundle.get("ExportFilePrompt"));
        this.directoryText = new Text(this.control, 2112);
        if (this.wizard.getDirectory() != null) {
            this.directoryText.setText(this.wizard.getDirectory());
        }
        this.directoryText.setLayoutData((Object)new RowData(this.parent.getSize().x - 30, -1));
        this.directoryText.setBackground(new Color((Device)this.control.getDisplay(), 255, 255, 255));
        this.directoryText.setFocus();
        this.directoryText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                Text text = (Text)modifyEvent.getSource();
                ExportFileDestinationPane.this.getWizard().setDirectory(text.getText());
            }
        });
        Button button = new Button(this.control, 8);
        button.setText(this.textBundle.get("BrowseButton"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DirectoryDialog directoryDialog = new DirectoryDialog(ExportFileDestinationPane.this.getShell());
                directoryDialog.setFilterPath(ExportFileDestinationPane.this.getDirectoryText().getText());
                directoryDialog.setMessage(UiBundle.getInstance().get("ExportFileDirectoryPrompt"));
                String string = directoryDialog.open();
                if (string != null) {
                    ExportFileDestinationPane.this.getDirectoryText().setText(string);
                }
            }
        });
    }

    public void dispose() {
        this.directoryText.dispose();
        this.control.dispose();
        this.control = null;
    }

    protected ExportWizard getWizard() {
        return this.wizard;
    }

    protected Shell getShell() {
        return this.control.getShell();
    }

    protected Text getDirectoryText() {
        return this.directoryText;
    }
}

