/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.ui.swt;

import com.webcodepro.applecommander.storage.FileEntry;
import com.webcodepro.applecommander.storage.FileFilter;
import com.webcodepro.applecommander.ui.UiBundle;
import com.webcodepro.applecommander.ui.swt.filteradapter.ApplesoftFilterAdapter;
import com.webcodepro.applecommander.ui.swt.filteradapter.FilterAdapter;
import com.webcodepro.applecommander.ui.swt.filteradapter.GraphicsFilterAdapter;
import com.webcodepro.applecommander.ui.swt.filteradapter.HexFilterAdapter;
import com.webcodepro.applecommander.ui.swt.filteradapter.RawDumpFilterAdapter;
import com.webcodepro.applecommander.ui.swt.filteradapter.TextFilterAdapter;
import com.webcodepro.applecommander.ui.swt.util.ImageManager;
import com.webcodepro.applecommander.ui.swt.util.SwtUtil;
import com.webcodepro.applecommander.ui.swt.util.contentadapter.ContentTypeAdapter;
import com.webcodepro.applecommander.util.TextBundle;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class FileViewerWindow {
    private static final char CTRL_A = '\u0001';
    private static final char CTRL_P = '\u0010';
    private static final char CTRL_C = '\u0003';
    private TextBundle textBundle = UiBundle.getInstance();
    private Shell parentShell = this.shell;
    private ImageManager imageManager;
    private Shell shell;
    private FileEntry fileEntry;
    private FileFilter nativeFilter;
    private ScrolledComposite content;
    private ToolBar toolBar;
    private ToolItem nativeToolItem;
    private ToolItem hexDumpToolItem;
    private ToolItem rawDumpToolItem;
    private ToolItem copyToolItem;
    private Font courier;
    private Color black;
    private Color blue;
    private Color green;
    private ContentTypeAdapter contentTypeAdapter;
    private Map nativeFilterAdapterMap;
    private FilterAdapter nativeFilterAdapter;
    private FilterAdapter hexFilterAdapter;
    private FilterAdapter rawDumpFilterAdapter;
    static /* synthetic */ Class class$com$webcodepro$applecommander$storage$filters$ApplesoftFileFilter;
    static /* synthetic */ Class class$com$webcodepro$applecommander$storage$filters$AppleWorksDataBaseFileFilter;
    static /* synthetic */ Class class$com$webcodepro$applecommander$storage$filters$AppleWorksSpreadSheetFileFilter;
    static /* synthetic */ Class class$com$webcodepro$applecommander$storage$filters$AppleWorksWordProcessorFileFilter;
    static /* synthetic */ Class class$com$webcodepro$applecommander$storage$filters$AssemblySourceFileFilter;
    static /* synthetic */ Class class$com$webcodepro$applecommander$storage$filters$GraphicsFileFilter;
    static /* synthetic */ Class class$com$webcodepro$applecommander$storage$filters$IntegerBasicFileFilter;
    static /* synthetic */ Class class$com$webcodepro$applecommander$storage$filters$PascalTextFileFilter;
    static /* synthetic */ Class class$com$webcodepro$applecommander$storage$filters$TextFileFilter;

    public FileViewerWindow(Shell shell, FileEntry fileEntry, ImageManager imageManager) {
        this(shell, fileEntry, imageManager, fileEntry.getSuggestedFilter());
    }

    public FileViewerWindow(Shell shell, FileEntry fileEntry, ImageManager imageManager, FileFilter fileFilter) {
        this.fileEntry = fileEntry;
        this.imageManager = imageManager;
        this.nativeFilter = fileFilter;
        this.createFilterAdapterMap();
    }

    public void open() {
        this.shell = new Shell(this.parentShell, 1264);
        this.shell.setLayout((Layout)new FillLayout());
        this.shell.setImage(this.imageManager.get("diskicon.gif"));
        this.shell.setText(this.textBundle.format("FileViewerWindow.Title", this.fileEntry.getFilename()));
        this.shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                FileViewerWindow.this.dispose(disposeEvent);
            }
        });
        Composite composite = new Composite((Composite)this.shell, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        composite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(768);
        this.createToolBar(composite, gridData);
        this.content = new ScrolledComposite(composite, 2816);
        gridData = new GridData(1808);
        this.content.setLayoutData((Object)gridData);
        this.content.addListener(2, this.createToolbarCommandHandler());
        this.courier = new Font((Device)this.shell.getDisplay(), "Courier", 10, 0);
        this.black = new Color((Device)this.shell.getDisplay(), 0, 0, 0);
        this.blue = new Color((Device)this.shell.getDisplay(), 0, 0, 192);
        this.green = new Color((Device)this.shell.getDisplay(), 0, 192, 0);
        this.nativeFilterAdapter.display();
        this.shell.open();
        SwtUtil.setupPagingInformation(this.content);
    }

    protected void createFilterAdapterMap() {
        this.nativeFilterAdapterMap = new HashMap();
        this.nativeFilterAdapterMap.put(class$com$webcodepro$applecommander$storage$filters$ApplesoftFileFilter == null ? (class$com$webcodepro$applecommander$storage$filters$ApplesoftFileFilter = FileViewerWindow.class$("com.webcodepro.applecommander.storage.filters.ApplesoftFileFilter")) : class$com$webcodepro$applecommander$storage$filters$ApplesoftFileFilter, new ApplesoftFilterAdapter(this, this.textBundle.get("FileViewerWindow.ApplesoftButton"), this.textBundle.get("FileViewerWindow.ApplesoftTooltip"), this.imageManager.get("appleicon.gif")));
        this.nativeFilterAdapterMap.put(class$com$webcodepro$applecommander$storage$filters$AppleWorksDataBaseFileFilter == null ? (class$com$webcodepro$applecommander$storage$filters$AppleWorksDataBaseFileFilter = FileViewerWindow.class$("com.webcodepro.applecommander.storage.filters.AppleWorksDataBaseFileFilter")) : class$com$webcodepro$applecommander$storage$filters$AppleWorksDataBaseFileFilter, new TextFilterAdapter(this, this.textBundle.get("FileViewerWindow.DatabaseButton"), this.textBundle.get("FileViewerWindow.DatabaseTooltip"), this.imageManager.get("database.gif")));
        this.nativeFilterAdapterMap.put(class$com$webcodepro$applecommander$storage$filters$AppleWorksSpreadSheetFileFilter == null ? (class$com$webcodepro$applecommander$storage$filters$AppleWorksSpreadSheetFileFilter = FileViewerWindow.class$("com.webcodepro.applecommander.storage.filters.AppleWorksSpreadSheetFileFilter")) : class$com$webcodepro$applecommander$storage$filters$AppleWorksSpreadSheetFileFilter, new TextFilterAdapter(this, this.textBundle.get("FileViewerWindow.SpreadsheetButton"), this.textBundle.get("FileViewerWindow.SpreadsheetTooltip"), this.imageManager.get("spreadsheet.gif")));
        this.nativeFilterAdapterMap.put(class$com$webcodepro$applecommander$storage$filters$AppleWorksWordProcessorFileFilter == null ? (class$com$webcodepro$applecommander$storage$filters$AppleWorksWordProcessorFileFilter = FileViewerWindow.class$("com.webcodepro.applecommander.storage.filters.AppleWorksWordProcessorFileFilter")) : class$com$webcodepro$applecommander$storage$filters$AppleWorksWordProcessorFileFilter, new TextFilterAdapter(this, this.textBundle.get("FileViewerWindow.WordprocessorButton"), this.textBundle.get("FileViewerWindow.WordprocessorTooltip"), this.imageManager.get("wordprocessor.gif")));
        this.nativeFilterAdapterMap.put(class$com$webcodepro$applecommander$storage$filters$AssemblySourceFileFilter == null ? (class$com$webcodepro$applecommander$storage$filters$AssemblySourceFileFilter = FileViewerWindow.class$("com.webcodepro.applecommander.storage.filters.AssemblySourceFileFilter")) : class$com$webcodepro$applecommander$storage$filters$AssemblySourceFileFilter, new TextFilterAdapter(this, this.textBundle.get("FileViewerWindow.AssemblyButton"), this.textBundle.get("FileViewerWindow.AssemblyTooltip"), this.imageManager.get("text.gif")));
        this.nativeFilterAdapterMap.put(class$com$webcodepro$applecommander$storage$filters$GraphicsFileFilter == null ? (class$com$webcodepro$applecommander$storage$filters$GraphicsFileFilter = FileViewerWindow.class$("com.webcodepro.applecommander.storage.filters.GraphicsFileFilter")) : class$com$webcodepro$applecommander$storage$filters$GraphicsFileFilter, new GraphicsFilterAdapter(this, this.textBundle.get("FileViewerWindow.ImageButton"), this.textBundle.get("FileViewerWindow.ImageTooltip"), this.imageManager.get("image.gif")));
        this.nativeFilterAdapterMap.put(class$com$webcodepro$applecommander$storage$filters$IntegerBasicFileFilter == null ? (class$com$webcodepro$applecommander$storage$filters$IntegerBasicFileFilter = FileViewerWindow.class$("com.webcodepro.applecommander.storage.filters.IntegerBasicFileFilter")) : class$com$webcodepro$applecommander$storage$filters$IntegerBasicFileFilter, new TextFilterAdapter(this, this.textBundle.get("FileViewerWindow.IntegerBasicButton"), this.textBundle.get("FileViewerWindow.IntegerBasicTooltip"), this.imageManager.get("appleicon.gif")));
        this.nativeFilterAdapterMap.put(class$com$webcodepro$applecommander$storage$filters$PascalTextFileFilter == null ? (class$com$webcodepro$applecommander$storage$filters$PascalTextFileFilter = FileViewerWindow.class$("com.webcodepro.applecommander.storage.filters.PascalTextFileFilter")) : class$com$webcodepro$applecommander$storage$filters$PascalTextFileFilter, new TextFilterAdapter(this, this.textBundle.get("FileViewerWindow.PascalTextButton"), this.textBundle.get("FileViewerWindow.PascalTextTooltip"), this.imageManager.get("text.gif")));
        this.nativeFilterAdapterMap.put(class$com$webcodepro$applecommander$storage$filters$TextFileFilter == null ? (class$com$webcodepro$applecommander$storage$filters$TextFileFilter = FileViewerWindow.class$("com.webcodepro.applecommander.storage.filters.TextFileFilter")) : class$com$webcodepro$applecommander$storage$filters$TextFileFilter, new TextFilterAdapter(this, this.textBundle.get("FileViewerWindow.TextButton"), this.textBundle.get("FileViewerWindow.TextTooltip"), this.imageManager.get("text.gif")));
    }

    protected void dispose(DisposeEvent disposeEvent) {
        this.courier.dispose();
        this.black.dispose();
        this.blue.dispose();
        this.green.dispose();
        if (this.nativeFilterAdapter != null) {
            this.nativeFilterAdapter.dispose();
        }
        this.hexFilterAdapter.dispose();
        this.rawDumpFilterAdapter.dispose();
        System.gc();
    }

    private void createToolBar(Composite composite, Object object) {
        this.toolBar = new ToolBar(composite, 0x800000);
        this.toolBar.addListener(2, this.createToolbarCommandHandler());
        if (object != null) {
            this.toolBar.setLayoutData(object);
        }
        if (this.nativeFilter != null) {
            this.nativeFilterAdapter = (FilterAdapter)this.nativeFilterAdapterMap.get(this.nativeFilter.getClass());
            if (this.nativeFilterAdapter != null) {
                this.nativeToolItem = this.nativeFilterAdapter.create(this.toolBar);
                this.nativeToolItem.setSelection(true);
            }
        }
        this.hexDumpToolItem = this.createHexDumpToolItem();
        if (this.nativeFilterAdapter == null) {
            this.hexDumpToolItem.setSelection(true);
            this.nativeFilterAdapter = this.hexFilterAdapter;
        }
        this.rawDumpToolItem = this.createRawDumpToolItem();
        new ToolItem(this.toolBar, 2);
        this.copyToolItem = this.createCopyToolItem();
        new ToolItem(this.toolBar, 2);
        this.createPrintToolItem();
        this.toolBar.pack();
    }

    protected ToolItem createHexDumpToolItem() {
        this.hexFilterAdapter = new HexFilterAdapter(this, this.textBundle.get("FileViewerWindow.HexDumpButton"), this.textBundle.get("FileViewerWindow.HexDumpTooltip"), this.imageManager.get("hex.gif"));
        this.hexFilterAdapter.setHexSelected();
        ToolItem toolItem = this.hexFilterAdapter.create(this.toolBar);
        return toolItem;
    }

    protected ToolItem createRawDumpToolItem() {
        this.rawDumpFilterAdapter = new RawDumpFilterAdapter(this, this.textBundle.get("FileViewerWindow.RawDumpButton"), this.textBundle.get("FileViewerWindow.RawDumpTooltip"), this.imageManager.get("raw.gif"));
        this.rawDumpFilterAdapter.setDumpSelected();
        ToolItem toolItem = this.rawDumpFilterAdapter.create(this.toolBar);
        return toolItem;
    }

    protected ToolItem createCopyToolItem() {
        ToolItem toolItem = new ToolItem(this.toolBar, 8);
        toolItem.setImage(this.imageManager.get("copy.gif"));
        toolItem.setText(this.textBundle.get("FileViewerWindow.CopyButton"));
        toolItem.setToolTipText(this.textBundle.get("FileViewerWindow.CopyTooltip"));
        toolItem.setEnabled(true);
        toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FileViewerWindow.this.getContentTypeAdapter().copy();
            }
        });
        return toolItem;
    }

    protected ToolItem createPrintToolItem() {
        ToolItem toolItem = new ToolItem(this.toolBar, 8);
        toolItem.setImage(this.imageManager.get("print.gif"));
        toolItem.setText(this.textBundle.get("PrintButton"));
        toolItem.setToolTipText(this.textBundle.get("FileViewerWindow.PrintTooltip"));
        toolItem.setEnabled(true);
        toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FileViewerWindow.this.getContentTypeAdapter().print();
            }
        });
        return toolItem;
    }

    public Listener createToolbarCommandHandler() {
        return new Listener(){

            public void handleEvent(Event event) {
                if (event.type == 2) {
                    if ((event.stateMask & 0x40000) != 0) {
                        switch (event.character) {
                            case '\u0003': {
                                FileViewerWindow.this.getContentTypeAdapter().copy();
                                break;
                            }
                            case '\u0001': {
                                FileViewerWindow.this.getContentTypeAdapter().selectAll();
                                break;
                            }
                            case '\u0010': {
                                FileViewerWindow.this.getContentTypeAdapter().print();
                            }
                        }
                    } else if ((event.stateMask & 0x10000) == 0) {
                        switch (event.keyCode) {
                            case 0x100000B: {
                                FileViewerWindow.this.getNativeFilterAdapter().display();
                                FileViewerWindow.this.setFilterToolItemSelection(true, false, false);
                                break;
                            }
                            case 0x100000C: {
                                FileViewerWindow.this.getHexFilterAdapter().display();
                                FileViewerWindow.this.setFilterToolItemSelection(false, true, false);
                                break;
                            }
                            case 0x100000D: {
                                FileViewerWindow.this.getRawDumpFilterAdapter().display();
                                FileViewerWindow.this.setFilterToolItemSelection(false, false, true);
                            }
                        }
                    }
                }
            }
        };
    }

    public FileFilter getFileFilter() {
        return this.nativeFilter;
    }

    public FileEntry getFileEntry() {
        return this.fileEntry;
    }

    public ToolItem getCopyToolItem() {
        return this.copyToolItem;
    }

    public ScrolledComposite getComposite() {
        return this.content;
    }

    public void setContentTypeAdapter(ContentTypeAdapter contentTypeAdapter) {
        this.contentTypeAdapter = contentTypeAdapter;
    }

    public Font getCourierFont() {
        return this.courier;
    }

    public Color getBlackColor() {
        return this.black;
    }

    public Color getGreenColor() {
        return this.green;
    }

    public Color getBlueColor() {
        return this.blue;
    }

    public void setFilterToolItemSelection(boolean bl, boolean bl2, boolean bl3) {
        if (this.nativeToolItem != null) {
            this.nativeToolItem.setSelection(bl);
        }
        this.hexDumpToolItem.setSelection(bl2);
        this.rawDumpToolItem.setSelection(bl3);
    }

    protected ContentTypeAdapter getContentTypeAdapter() {
        return this.contentTypeAdapter;
    }

    protected FilterAdapter getHexFilterAdapter() {
        return this.hexFilterAdapter;
    }

    protected FilterAdapter getNativeFilterAdapter() {
        return this.nativeFilterAdapter;
    }

    protected FilterAdapter getRawDumpFilterAdapter() {
        return this.rawDumpFilterAdapter;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

