/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.ui.swt;

import com.webcodepro.applecommander.storage.FormattedDisk;
import com.webcodepro.applecommander.ui.UiBundle;
import com.webcodepro.applecommander.ui.swt.DiskExplorerTab;
import com.webcodepro.applecommander.ui.swt.DiskInfoTab;
import com.webcodepro.applecommander.ui.swt.DiskMapTab;
import com.webcodepro.applecommander.ui.swt.util.ImageManager;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class DiskWindow {
    private Shell parentShell;
    private ImageManager imageManager;
    private Shell shell;
    private FormattedDisk[] disks;
    private DiskInfoTab diskInfoTab;
    private DiskMapTab[] diskMapTabs;

    public DiskWindow(Shell shell, FormattedDisk[] formattedDiskArray, ImageManager imageManager) {
        this.parentShell = this.shell;
        this.disks = formattedDiskArray;
        this.imageManager = imageManager;
    }

    public void open() {
        this.shell = new Shell(this.parentShell, 1264);
        this.shell.setLayout((Layout)new FillLayout());
        this.shell.setImage(this.imageManager.get("diskicon.gif"));
        this.setStandardWindowTitle();
        this.shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                DiskWindow.this.dispose(disposeEvent);
            }
        });
        CTabFolder cTabFolder = new CTabFolder((Composite)this.shell, 1024);
        new DiskExplorerTab(cTabFolder, this.disks, this.imageManager, this);
        this.diskMapTabs = new DiskMapTab[this.disks.length];
        for (int i = 0; i < this.disks.length; ++i) {
            if (!this.disks[i].supportsDiskMap()) continue;
            this.diskMapTabs[i] = new DiskMapTab(cTabFolder, this.disks[i]);
        }
        this.diskInfoTab = new DiskInfoTab(cTabFolder, this.disks);
        cTabFolder.setSelection(cTabFolder.getItems()[0]);
        this.shell.open();
    }

    public void setStandardWindowTitle() {
        this.shell.setText(UiBundle.getInstance().format("DiskWindow.Title", this.disks[0].getFilename()));
    }

    protected void dispose(DisposeEvent disposeEvent) {
        for (int i = 0; i < this.diskMapTabs.length; ++i) {
            if (this.diskMapTabs[i] == null) continue;
            this.diskMapTabs[i].dispose();
        }
        this.diskInfoTab.dispose();
        this.disks = null;
        this.diskMapTabs = null;
        this.diskInfoTab = null;
        System.gc();
    }
}

