/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.storage.os.pascal;

import com.webcodepro.applecommander.storage.DiskFullException;
import com.webcodepro.applecommander.storage.FileEntry;
import com.webcodepro.applecommander.storage.FileFilter;
import com.webcodepro.applecommander.storage.FormattedDisk;
import com.webcodepro.applecommander.storage.StorageBundle;
import com.webcodepro.applecommander.storage.filters.BinaryFileFilter;
import com.webcodepro.applecommander.storage.filters.GraphicsFileFilter;
import com.webcodepro.applecommander.storage.filters.PascalTextFileFilter;
import com.webcodepro.applecommander.storage.filters.TextFileFilter;
import com.webcodepro.applecommander.storage.os.pascal.PascalFormatDisk;
import com.webcodepro.applecommander.util.AppleUtil;
import com.webcodepro.applecommander.util.TextBundle;
import java.io.ByteArrayOutputStream;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class PascalFileEntry
implements FileEntry {
    private TextBundle textBundle = StorageBundle.getInstance();
    private byte[] fileEntry;
    private PascalFormatDisk disk;
    private int index = 0;
    private boolean deleted = false;

    public PascalFileEntry(byte[] byArray, PascalFormatDisk pascalFormatDisk) {
        this.fileEntry = byArray;
        this.disk = pascalFormatDisk;
    }

    public int getFirstBlock() {
        return AppleUtil.getWordValue(this.fileEntry, 0);
    }

    public void setFirstBlock(int n) {
        AppleUtil.setWordValue(this.fileEntry, 0, n);
    }

    public int getLastBlock() {
        return AppleUtil.getWordValue(this.fileEntry, 2);
    }

    public void setLastBlock(int n) {
        AppleUtil.setWordValue(this.fileEntry, 2, n);
    }

    public String getFilename() {
        return AppleUtil.getPascalString(this.fileEntry, 6);
    }

    public void setFilename(String string) {
        AppleUtil.setPascalString(this.fileEntry, 6, string.toUpperCase(), 15);
    }

    public int getMaximumFilenameLength() {
        return 15;
    }

    public String getFiletype() {
        String[] stringArray = this.disk.getFiletypes();
        int n = this.fileEntry[4] & 0xF;
        if (n == 0 || n > stringArray.length) {
            return this.textBundle.format("PascalFileEntry.UnknownFiletype", n);
        }
        return stringArray[n - 1];
    }

    public void setFiletype(String string) {
        if ("bad".equalsIgnoreCase(string)) {
            AppleUtil.setWordValue(this.fileEntry, 4, 1);
        } else if ("code".equalsIgnoreCase(string)) {
            AppleUtil.setWordValue(this.fileEntry, 4, 2);
        } else if ("text".equalsIgnoreCase(string)) {
            AppleUtil.setWordValue(this.fileEntry, 4, 3);
        } else if ("info".equalsIgnoreCase(string)) {
            AppleUtil.setWordValue(this.fileEntry, 4, 4);
        } else if ("data".equalsIgnoreCase(string)) {
            AppleUtil.setWordValue(this.fileEntry, 4, 5);
        } else if ("graf".equalsIgnoreCase(string)) {
            AppleUtil.setWordValue(this.fileEntry, 4, 6);
        } else if ("foto".equalsIgnoreCase(string)) {
            AppleUtil.setWordValue(this.fileEntry, 4, 7);
        } else {
            AppleUtil.setWordValue(this.fileEntry, 4, 0);
        }
    }

    public boolean isLocked() {
        return false;
    }

    public void setLocked(boolean bl) {
    }

    public int getBytesUsedInLastBlock() {
        return AppleUtil.getWordValue(this.fileEntry, 22);
    }

    public void setBytesUsedInLastBlock(int n) {
        AppleUtil.setWordValue(this.fileEntry, 22, n);
    }

    public int getSize() {
        int n = this.getBlocksUsed() - 1;
        return n * 512 + this.getBytesUsedInLastBlock();
    }

    public int getBlocksUsed() {
        return AppleUtil.getWordValue(this.fileEntry, 2) - AppleUtil.getWordValue(this.fileEntry, 0);
    }

    public boolean isDirectory() {
        return false;
    }

    public List getFiles() {
        return null;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void delete() {
        int n = 0;
        String string = this.getFilename();
        List list = this.disk.getDirectory();
        int n2 = list.size();
        for (int i = 1; i < n2; ++i) {
            String string2 = ((PascalFileEntry)list.get(i)).getFilename();
            if (!string.equals(string2)) continue;
            n = i;
        }
        if (n != 0) {
            list.remove(n);
            PascalFileEntry pascalFileEntry = (PascalFileEntry)list.get(0);
            pascalFileEntry.setFileCount(n2 - 2);
            list.set(0, pascalFileEntry);
            this.disk.putDirectory(list);
            this.deleted = true;
        }
    }

    public Date getModificationDate() {
        return AppleUtil.getPascalDate(this.fileEntry, 24);
    }

    public void setModificationDate(Date date) {
        AppleUtil.setPascalDate(this.fileEntry, 24, date);
    }

    public List getFileColumnData(int n) {
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.textBundle.get("PascalFileEntry.PascalDateFormat"));
        ArrayList<String> arrayList = new ArrayList<String>();
        switch (n) {
            case 2: {
                arrayList.add(simpleDateFormat.format(this.getModificationDate()));
                numberFormat.setMinimumIntegerDigits(3);
                arrayList.add(numberFormat.format(this.getBlocksUsed()));
                arrayList.add(this.getFiletype());
                arrayList.add(this.getFilename());
                break;
            }
            case 3: {
                arrayList.add(simpleDateFormat.format(this.getModificationDate()));
                numberFormat.setMinimumIntegerDigits(3);
                arrayList.add(numberFormat.format(this.getBlocksUsed()));
                numberFormat.setMinimumIntegerDigits(1);
                arrayList.add(numberFormat.format(this.getBytesUsedInLastBlock()));
                arrayList.add(numberFormat.format(this.getSize()));
                arrayList.add(this.getFiletype());
                arrayList.add(this.getFilename());
                numberFormat.setMinimumIntegerDigits(3);
                arrayList.add(numberFormat.format(this.getFirstBlock()));
                arrayList.add(numberFormat.format(this.getLastBlock() - 1));
                break;
            }
            default: {
                arrayList.add(this.getFilename());
                arrayList.add(this.getFiletype());
                arrayList.add(numberFormat.format(this.getSize()));
                arrayList.add(this.isLocked() ? this.textBundle.get("Locked") : "");
            }
        }
        return arrayList;
    }

    public byte[] getFileData() {
        return this.disk.getFileData(this);
    }

    private byte[] filterText(byte[] byArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length);
        int n = 0;
        while (n < byArray.length) {
            byte by = byArray[n];
            if (by == 13 || by == 10) {
                byteArrayOutputStream.write(13);
                if (by == 13 && ++n < byArray.length && byArray[n] == 10) {
                    ++n;
                }
                int n2 = 32;
                while (n < byArray.length && byArray[n] == 32) {
                    n2 = (byte)(n2 + 1);
                    ++n;
                }
                if (n2 <= 32) continue;
                byteArrayOutputStream.write(16);
                byteArrayOutputStream.write(n2);
                continue;
            }
            byteArrayOutputStream.write(by);
            ++n;
        }
        return byteArrayOutputStream.toByteArray();
    }

    private void storageError(String string) throws DiskFullException {
        if (this.index > 0) {
            List list = this.disk.getDirectory();
            int n = list.size();
            list.remove(this.index);
            PascalFileEntry pascalFileEntry = (PascalFileEntry)list.get(0);
            pascalFileEntry.setFileCount(n - 2);
            list.set(0, pascalFileEntry);
            this.disk.putDirectory(list);
            throw new DiskFullException(string);
        }
    }

    private int findEOL(byte[] byArray, int n) throws DiskFullException {
        for (int i = n + 1022; i > n; --i) {
            if (byArray[i] != 13) continue;
            return i;
        }
        this.storageError(this.textBundle.get("PascalFileEntry.LineLengthError"));
        return 0;
    }

    public void setFileData(byte[] byArray) throws DiskFullException {
        Object object;
        int n = this.getFirstBlock();
        int n2 = this.getLastBlock();
        if (this.fileEntry[4] == 3) {
            byArray = this.filterText(byArray);
            object = new byte[1024];
            int n3 = 0;
            int n4 = 0;
            this.disk.writeBlock(n, (byte[])object);
            ++n4;
            while (n3 + 1023 < byArray.length) {
                if (n4 * 2 > n2 - n - 2) {
                    this.storageError(this.textBundle.get("PascalFileEntry.NotEnoughRoom"));
                }
                int n5 = this.findEOL(byArray, n3);
                System.arraycopy(byArray, n3, object, 0, n5 - n3 + 1);
                this.disk.writeBlock(n + n4 * 2, (byte[])object);
                ++n4;
                Arrays.fill((byte[])object, (byte)0);
                n3 = n5 + 1;
            }
            if (n3 < byArray.length) {
                System.arraycopy(byArray, n3, object, 0, byArray.length - n3);
                this.disk.writeBlock(n + n4 * 2, (byte[])object);
                ++n4;
            }
            this.setLastBlock(n + n4 * 2);
            this.setBytesUsedInLastBlock(512);
        } else {
            if (byArray.length > (n2 - n) * 512) {
                this.storageError(this.textBundle.get("PascalFileEntry.NotEnoughRoom"));
            }
            object = new byte[512];
            int n6 = byArray.length / 512;
            int n7 = byArray.length % 512;
            for (int i = 0; i < n6; ++i) {
                System.arraycopy(byArray, i * 512, object, 0, 512);
                this.disk.writeBlock(n + i, (byte[])object);
            }
            if (n7 > 0) {
                Arrays.fill((byte[])object, (byte)0);
                System.arraycopy(byArray, n6 * 512, object, 0, n7);
                this.disk.writeBlock(n + n6, (byte[])object);
                this.setLastBlock(n + n6 + 1);
                this.setBytesUsedInLastBlock(n7);
            } else {
                this.setLastBlock(n + n6);
                this.setBytesUsedInLastBlock(512);
            }
        }
        if (this.index > 0) {
            object = this.disk.getDirectory();
            object.set(this.index, this);
            this.disk.putDirectory((List)object);
        }
    }

    public FileFilter getSuggestedFilter() {
        if ("TEXT".equals(this.getFiletype())) {
            if (this.getFilename().toLowerCase().endsWith(".text")) {
                return new PascalTextFileFilter();
            }
            return new TextFileFilter();
        }
        if ("DATA".equals(this.getFiletype()) && this.getSize() >= 8184 && this.getSize() <= 8192) {
            GraphicsFileFilter graphicsFileFilter = new GraphicsFileFilter();
            graphicsFileFilter.setMode(2);
            return graphicsFileFilter;
        }
        return new BinaryFileFilter();
    }

    public FormattedDisk getFormattedDisk() {
        return this.disk;
    }

    public byte[] toBytes() {
        return this.fileEntry;
    }

    public boolean needsAddress() {
        return false;
    }

    public void setAddress(int n) {
    }

    public boolean canCompile() {
        return false;
    }

    public void setEntryIndex(int n) {
        this.index = n;
    }

    public void setFileCount(int n) {
        AppleUtil.setWordValue(this.fileEntry, 16, n);
    }
}

