/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.storage.os.dos33;

import com.webcodepro.applecommander.storage.DirectoryEntry;
import com.webcodepro.applecommander.storage.DiskFullException;
import com.webcodepro.applecommander.storage.FileEntry;
import com.webcodepro.applecommander.storage.FormattedDisk;
import com.webcodepro.applecommander.storage.StorageBundle;
import com.webcodepro.applecommander.storage.os.dos33.DosFileEntry;
import com.webcodepro.applecommander.storage.physical.ImageOrder;
import com.webcodepro.applecommander.util.AppleUtil;
import com.webcodepro.applecommander.util.TextBundle;
import java.util.ArrayList;
import java.util.List;

public class DosFormatDisk
extends FormattedDisk {
    private TextBundle textBundle = StorageBundle.getInstance();
    public static final int TRACK_LOCATION_INDEX = 0;
    public static final int SECTOR_LOCATION_INDEX = 1;
    public static final int CATALOG_TRACK = 17;
    public static final int VTOC_SECTOR = 0;
    public static final int TRACK_SECTOR_PAIRS = 122;
    private static final String[] filetypes = new String[]{"T", "A", "I", "B", "S", "R", "a", "b"};

    public DosFormatDisk(String string, ImageOrder imageOrder) {
        super(string, imageOrder);
    }

    public static DosFormatDisk[] create(String string, ImageOrder imageOrder) {
        DosFormatDisk dosFormatDisk = new DosFormatDisk(string, imageOrder);
        dosFormatDisk.format();
        return new DosFormatDisk[]{dosFormatDisk};
    }

    public String getFormat() {
        return this.textBundle.get("Dos33");
    }

    public List getFiles() {
        ArrayList<DosFileEntry> arrayList = new ArrayList<DosFileEntry>();
        byte[] byArray = this.readVtoc();
        int n = AppleUtil.getUnsignedByte(byArray[1]);
        int n2 = AppleUtil.getUnsignedByte(byArray[2]);
        while (n != 0) {
            byte[] byArray2 = this.readSector(n, n2);
            for (int i = 11; i < 255; i += 35) {
                if (byArray2[i] == 0) continue;
                arrayList.add(new DosFileEntry(this, n, n2, i));
            }
            n = byArray2[1];
            n2 = byArray2[2];
        }
        return arrayList;
    }

    public FileEntry createFile() throws DiskFullException {
        byte[] byArray = this.readVtoc();
        int n = AppleUtil.getUnsignedByte(byArray[1]);
        int n2 = AppleUtil.getUnsignedByte(byArray[2]);
        while (n2 != 0) {
            byte[] byArray2 = this.readSector(n, n2);
            for (int i = 11; i < 255; i += 35) {
                int n3 = AppleUtil.getUnsignedByte(byArray2[i]);
                if (n3 != 0 && n3 != 255) continue;
                return new DosFileEntry(this, n, n2, i);
            }
            n = byArray2[1];
            n2 = byArray2[2];
        }
        throw new DiskFullException(this.textBundle.get("DosFormatDisk.NoMoreSpaceError"));
    }

    public boolean canCreateDirectories() {
        return false;
    }

    public boolean canCreateFile() {
        return true;
    }

    public int getFreeSpace() {
        return this.getFreeSectors() * 256;
    }

    public int getFreeSectors() {
        byte[] byArray = this.readVtoc();
        int n = 0;
        for (int i = 56; i < 255; ++i) {
            byte by = byArray[i];
            n += AppleUtil.getBitCount(by);
        }
        return n;
    }

    public int getUsedSpace() {
        return this.getUsedSectors() * 256;
    }

    public int getUsedSectors() {
        return this.getTotalSectors() - this.getFreeSectors();
    }

    public int getTotalSectors() {
        int n = this.getTracks();
        int n2 = this.getSectors();
        return n * n2;
    }

    public String getDiskName() {
        int n = AppleUtil.getUnsignedByte(this.readVtoc()[6]);
        return this.textBundle.format("DosFormatDisk.DiskVolume", n);
    }

    protected byte[] readVtoc() {
        return this.readSector(17, 0);
    }

    protected void writeVtoc(byte[] byArray) {
        this.writeSector(17, 0, byArray);
    }

    public FormattedDisk.DiskUsage getDiskUsage() {
        return new DosDiskUsage();
    }

    public int getTracks() {
        byte[] byArray = this.readVtoc();
        return AppleUtil.getUnsignedByte(byArray[52]);
    }

    public int getSectors() {
        byte[] byArray = this.readVtoc();
        return AppleUtil.getUnsignedByte(byArray[53]);
    }

    public int[] getBitmapDimensions() {
        int n = this.getTracks();
        int n2 = this.getSectors();
        return new int[]{n, n2};
    }

    public int getBitmapLength() {
        return this.getTotalSectors();
    }

    public String[] getBitmapLabels() {
        return new String[]{this.textBundle.get("DosFormatDisk.Track"), this.textBundle.get("DosFormatDisk.Sector")};
    }

    public List getDiskInformation() {
        List list = super.getDiskInformation();
        list.add((FormattedDisk)this.new FormattedDisk.DiskInformation(this.textBundle.get("DosFormatDisk.TotalSectors"), this.getTotalSectors()));
        list.add((FormattedDisk)this.new FormattedDisk.DiskInformation(this.textBundle.get("DosFormatDisk.FreeSectors"), this.getFreeSectors()));
        list.add((FormattedDisk)this.new FormattedDisk.DiskInformation(this.textBundle.get("DosFormatDisk.UsedSectors"), this.getUsedSectors()));
        list.add((FormattedDisk)this.new FormattedDisk.DiskInformation(this.textBundle.get("DosFormatDisk.TracksOnDisk"), this.getTracks()));
        list.add((FormattedDisk)this.new FormattedDisk.DiskInformation(this.textBundle.get("DosFormatDisk.SectorsOnDisk"), this.getSectors()));
        return list;
    }

    public List getFileColumnHeaders(int n) {
        ArrayList<FormattedDisk.FileColumnHeader> arrayList = new ArrayList<FormattedDisk.FileColumnHeader>();
        switch (n) {
            case 2: {
                arrayList.add(new FormattedDisk.FileColumnHeader(" ", 1, 2));
                arrayList.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("DosFormatDisk.Type"), 1, 2));
                arrayList.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("DosFormatDisk.SizeInSectors"), 3, 3));
                arrayList.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("Name"), 30, 1));
                break;
            }
            case 3: {
                arrayList.add(new FormattedDisk.FileColumnHeader(" ", 1, 2));
                arrayList.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("DosFormatDisk.Type"), 1, 2));
                arrayList.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("Name"), 30, 1));
                arrayList.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("SizeInBytes"), 6, 3));
                arrayList.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("DosFormatDisk.SizeInSectors"), 3, 3));
                arrayList.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("DeletedQ"), 7, 2));
                arrayList.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("DosFormatDisk.TrackAndSectorList"), 7, 2));
                break;
            }
            default: {
                arrayList.addAll(super.getFileColumnHeaders(n));
            }
        }
        return arrayList;
    }

    public boolean supportsDeletedFiles() {
        return true;
    }

    public boolean canReadFileData() {
        return true;
    }

    public boolean canWriteFileData() {
        return true;
    }

    public boolean canHaveDirectories() {
        return false;
    }

    public boolean canDeleteFile() {
        return true;
    }

    public byte[] getFileData(FileEntry fileEntry) {
        if (!(fileEntry instanceof DosFileEntry)) {
            throw new IllegalArgumentException(this.textBundle.get("DosFormatDisk.InvalidFileEntryError"));
        }
        DosFileEntry dosFileEntry = (DosFileEntry)fileEntry;
        int n = dosFileEntry.getSectorsUsed();
        byte[] byArray = null;
        if (n <= 0) {
            byArray = new byte[]{};
            return byArray;
        }
        byArray = new byte[(dosFileEntry.getSectorsUsed() - 1) * 256];
        int n2 = dosFileEntry.getTrack();
        int n3 = dosFileEntry.getSector();
        int n4 = 0;
        while (n2 != 0) {
            int n5;
            byte[] byArray2 = this.readSector(n2, n3);
            n2 = AppleUtil.getUnsignedByte(byArray2[1]);
            n3 = AppleUtil.getUnsignedByte(byArray2[2]);
            for (int i = 12; i < 256 && (n5 = AppleUtil.getUnsignedByte(byArray2[i])) != 0; i += 2) {
                int n6 = AppleUtil.getUnsignedByte(byArray2[i + 1]);
                byte[] byArray3 = this.readSector(n5, n6);
                System.arraycopy(byArray3, 0, byArray, n4, byArray3.length);
                n4 += byArray3.length;
            }
        }
        return byArray;
    }

    public void setFileData(FileEntry fileEntry, byte[] byArray) throws DiskFullException {
        this.setFileData((DosFileEntry)fileEntry, byArray);
    }

    protected void setFileData(DosFileEntry dosFileEntry, byte[] byArray) throws DiskFullException {
        int n = (byArray.length + 256 - 1) / 256;
        int n2 = n + (n + 122 - 1) / 122;
        if (n2 > this.getFreeSectors() + dosFileEntry.getSectorsUsed()) {
            throw new DiskFullException(this.textBundle.format("DosFormatDisk.NotEnoughSectorsError", n2, this.getFreeSectors()));
        }
        this.freeSectors(dosFileEntry);
        byte[] byArray2 = this.readVtoc();
        int n3 = dosFileEntry.getTrack();
        int n4 = dosFileEntry.getSector();
        if (n3 == 0 || n3 == 255) {
            n3 = 1;
            n4 = 0;
            while (!this.isSectorFree(n3, n4, byArray2)) {
                if (++n4 < this.getSectors()) continue;
                ++n3;
                n4 = 0;
            }
            dosFileEntry.setTrack(n3);
            dosFileEntry.setSector(n4);
        }
        this.setSectorUsed(n3, n4, byArray2);
        byte[] byArray3 = new byte[256];
        int n5 = 0;
        int n6 = 12;
        int n7 = 0;
        int n8 = 1;
        int n9 = 0;
        while (n5 < byArray.length) {
            while (!this.isSectorFree(n8, n9, byArray2)) {
                if (++n9 < this.getSectors()) continue;
                ++n8;
                n9 = 0;
            }
            this.setSectorUsed(n8, n9, byArray2);
            if (n6 >= 256) {
                byArray3[1] = (byte)n8;
                byArray3[2] = (byte)n9;
                this.writeSector(n3, n4, byArray3);
                byArray3 = new byte[256];
                n6 = 12;
                n3 = n8;
                n4 = n9;
            } else {
                byArray3[n6] = (byte)n8;
                byArray3[n6 + 1] = (byte)n9;
                n6 += 2;
                byte[] byArray4 = new byte[256];
                int n10 = Math.min(256, byArray.length - n5);
                System.arraycopy(byArray, n5, byArray4, 0, n10);
                this.writeSector(n8, n9, byArray4);
                n5 += 256;
            }
            ++n7;
        }
        this.writeSector(n3, n4, byArray3);
        dosFileEntry.setSectorsUsed(++n7);
        this.writeVtoc(byArray2);
    }

    protected void freeSectors(DosFileEntry dosFileEntry) {
        byte[] byArray = this.readVtoc();
        int n = dosFileEntry.getTrack();
        if (n == 255) {
            return;
        }
        int n2 = dosFileEntry.getSector();
        while (n != 0) {
            int n3;
            this.setSectorFree(n, n2, byArray);
            byte[] byArray2 = this.readSector(n, n2);
            n = AppleUtil.getUnsignedByte(byArray2[1]);
            n2 = AppleUtil.getUnsignedByte(byArray2[2]);
            for (int i = 12; i < 256 && (n3 = AppleUtil.getUnsignedByte(byArray2[i])) != 0; i += 2) {
                int n4 = AppleUtil.getUnsignedByte(byArray2[i + 1]);
                this.setSectorFree(n3, n4, byArray);
            }
        }
        this.writeVtoc(byArray);
    }

    public void format() {
        this.getImageOrder().format();
        this.format(15, 35, 16);
    }

    protected void format(int n, int n2, int n3) {
        int n4;
        this.writeBootCode();
        byte[] byArray = new byte[256];
        for (n4 = n; n4 > 0; --n4) {
            if (n4 > 1) {
                byArray[1] = 17;
                byArray[2] = (byte)(n4 - 1);
            } else {
                byArray[1] = 0;
                byArray[2] = 0;
            }
            this.writeSector(17, n4, byArray);
        }
        byArray[1] = 17;
        byArray[2] = (byte)n;
        byArray[3] = 3;
        byArray[6] = -2;
        byArray[39] = 122;
        byArray[48] = 18;
        byArray[49] = 1;
        byArray[52] = (byte)n2;
        byArray[53] = (byte)n3;
        byArray[55] = 1;
        for (n4 = 0; n4 < n2; ++n4) {
            for (int i = 0; i < n3; ++i) {
                if (n4 == 0 || n4 == 17) {
                    this.setSectorUsed(n4, i, byArray);
                    continue;
                }
                this.setSectorFree(n4, i, byArray);
            }
        }
        this.writeVtoc(byArray);
    }

    public boolean isSectorFree(int n, int n2, byte[] byArray) {
        this.checkRange(n, n2);
        byte by = byArray[this.getFreeMapByte(n, n2)];
        return AppleUtil.isBitSet(by, this.getFreeMapBit(n2));
    }

    public boolean isSectorUsed(int n, int n2, byte[] byArray) {
        return !this.isSectorFree(n, n2, byArray);
    }

    public void setSectorFree(int n, int n2, byte[] byArray) {
        this.checkRange(n, n2);
        int n3 = this.getFreeMapByte(n, n2);
        byte by = byArray[n3];
        byArray[n3] = by = AppleUtil.setBit(by, this.getFreeMapBit(n2));
    }

    public void setSectorUsed(int n, int n2, byte[] byArray) {
        this.checkRange(n, n2);
        int n3 = this.getFreeMapByte(n, n2);
        byte by = byArray[n3];
        byArray[n3] = by = AppleUtil.clearBit(by, this.getFreeMapBit(n2));
    }

    protected int getFreeMapByte(int n, int n2) {
        int n3 = n * 4;
        int n4 = 1 - ((n2 & 8) >> 3);
        return 56 + n3 + n4;
    }

    protected int getFreeMapBit(int n) {
        int n2 = n & 7;
        return n2;
    }

    protected void checkRange(int n, int n2) {
        if (n > 50 || n2 > 32) {
            throw new IllegalArgumentException(this.textBundle.format("DosFormatDisk.InvalidTrackAndSectorCombinationError", n, n2));
        }
    }

    public int getLogicalDiskNumber() {
        return 0;
    }

    public String getSuggestedFilename(String string) {
        int n = Math.min(string.length(), 30);
        return string.toUpperCase().substring(0, n).trim();
    }

    public String getSuggestedFiletype(String string) {
        String string2;
        String string3 = "B";
        int n = string.lastIndexOf(".");
        if (n > 0 && "txt".equalsIgnoreCase(string2 = string.substring(n + 1))) {
            string3 = "T";
        }
        return string3;
    }

    public String[] getFiletypes() {
        return filetypes;
    }

    public boolean needsAddress(String string) {
        return "B".equals(string);
    }

    public boolean supportsDiskMap() {
        return true;
    }

    public void changeImageOrder(ImageOrder imageOrder) {
        AppleUtil.changeImageOrderByTrackAndSector(this.getImageOrder(), imageOrder);
        this.setImageOrder(imageOrder);
    }

    public DirectoryEntry createDirectory() throws DiskFullException {
        throw new UnsupportedOperationException(this.textBundle.get("DirectoryCreationNotSupported"));
    }

    private class DosDiskUsage
    implements FormattedDisk.DiskUsage {
        private int[] location = null;

        private DosDiskUsage() {
        }

        public boolean hasNext() {
            return this.location == null || this.location[0] < DosFormatDisk.this.getTracks() && this.location[1] < DosFormatDisk.this.getSectors();
        }

        public void next() {
            if (this.location == null) {
                this.location = new int[2];
            } else {
                this.location[1] = this.location[1] + 1;
                if (this.location[1] >= DosFormatDisk.this.getSectors()) {
                    this.location[1] = 0;
                    this.location[0] = this.location[0] + 1;
                }
            }
        }

        public boolean isFree() {
            if (this.location == null || this.location.length != 2) {
                throw new IllegalArgumentException(StorageBundle.getInstance().get("DosFormatDisk.InvalidDimensionError"));
            }
            return DosFormatDisk.this.isSectorFree(this.location[0], this.location[1], DosFormatDisk.this.readVtoc());
        }

        public boolean isUsed() {
            return !this.isFree();
        }
    }
}

