/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.util;

import com.webcodepro.applecommander.storage.FileEntry;
import com.webcodepro.applecommander.util.AppleUtil;
import com.webcodepro.applecommander.util.ApplesoftToken;

public class ApplesoftTokenizer {
    private static String[] tokens = new String[]{" END ", " FOR ", " NEXT ", " DATA ", " INPUT ", " DEL ", " DIM ", " READ ", " GR ", " TEXT ", " PR# ", " IN# ", " CALL ", " PLOT ", " HLIN ", " VLIN ", " HGR2 ", " HGR ", " HCOLOR= ", " HPLOT ", " DRAW ", " XDRAW ", " HTAB ", " HOME ", " ROT= ", " SCALE= ", " SHLOAD ", " TRACE ", " NOTRACE ", " NORMAL ", " INVERSE ", " FLASH ", " COLOR= ", " POP ", " VTAB ", " HIMEM: ", " LOMEM: ", " ONERR ", " RESUME ", " RECALL ", " STORE ", " SPEED= ", " LET ", " GOTO ", " RUN ", " IF ", " RESTORE ", " & ", " GOSUB ", " RETURN ", " REM ", " STOP ", " ON ", " WAIT ", " LOAD ", " SAVE ", " DEF ", " POKE ", " PRINT ", " CONT ", " LIST ", " CLEAR ", " GET ", " NEW ", " TAB( ", " TO ", " FN ", " SPC( ", "  THEN ", " AT ", "  NOT ", "  STEP ", " +", " -", " *", "/", " ^", "  AND ", "  OR ", " >", " = ", " <", " SGN", " INT", " ABS", " USR", " FRE", " SCRN( ", " PDL", " POS", " SQR", " RND", " LOG", " EXP", " COS", " SIN", " TAN", " ATN", " PEEK", " LEN", " STR$", " VAL", " ASC", " CHR$", " LEFT$", " RIGHT$", " MID$ "};
    private byte[] fileData;
    private int offset;
    private int nextAddress = -1;

    public ApplesoftTokenizer(FileEntry fileEntry) {
        this(fileEntry.getFileData());
    }

    public ApplesoftTokenizer(byte[] byArray) {
        this.fileData = byArray;
    }

    public boolean hasMoreTokens() {
        return this.offset < this.fileData.length;
    }

    public ApplesoftToken getNextToken() {
        if (this.hasMoreTokens()) {
            byte by;
            if (this.nextAddress == -1) {
                this.nextAddress = AppleUtil.getWordValue(this.fileData, this.offset);
                this.offset += 2;
                if (this.nextAddress == 0) {
                    this.offset = this.fileData.length;
                    return null;
                }
                int n = AppleUtil.getWordValue(this.fileData, this.offset);
                this.offset += 2;
                return new ApplesoftToken(n);
            }
            if ((by = this.fileData[this.offset++]) == 0) {
                this.nextAddress = -1;
                return this.getNextToken();
            }
            if ((by & 0x80) != 0) {
                int n = AppleUtil.getUnsignedByte(by) - 128;
                if (n >= tokens.length) {
                    return new ApplesoftToken(by, "<UNKNOWN TOKEN>");
                }
                return new ApplesoftToken(by, tokens[n]);
            }
            if (by == 58 || by == 59 || by == 44 || by == 94 || by == 43 || by == 45 || by == 42 || by == 47) {
                return new ApplesoftToken(new String(new byte[]{by}));
            }
            StringBuffer stringBuffer = new StringBuffer();
            while (true) {
                char c;
                if ((c = (char)by) < ' ') {
                    stringBuffer.append("<CTRL-");
                    stringBuffer.append((char)(64 + c));
                    stringBuffer.append('>');
                } else {
                    stringBuffer.append(c);
                }
                by = this.fileData[this.offset];
                if ((by & 0x80) != 0 || by == 0 || by == 58 || by == 44 || by == 59) break;
                ++this.offset;
            }
            return new ApplesoftToken(stringBuffer.toString());
        }
        return null;
    }
}

