/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.ui.swt.wizard.diskimage;

import com.webcodepro.applecommander.ui.UiBundle;
import com.webcodepro.applecommander.ui.swt.wizard.WizardPane;
import com.webcodepro.applecommander.ui.swt.wizard.diskimage.DiskImageNamePane;
import com.webcodepro.applecommander.ui.swt.wizard.diskimage.DiskImageSizePane;
import com.webcodepro.applecommander.ui.swt.wizard.diskimage.DiskImageWizard;
import com.webcodepro.applecommander.util.TextBundle;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class DiskImageFormatPane
extends WizardPane {
    private TextBundle textBundle = UiBundle.getInstance();
    private DiskImageWizard wizard;
    private Composite control;
    private Composite parent;

    public DiskImageFormatPane(Composite composite, DiskImageWizard diskImageWizard) {
        this.parent = composite;
        this.wizard = diskImageWizard;
    }

    public WizardPane getNextPane() {
        switch (this.wizard.getFormat()) {
            case 1: 
            case 5: 
            case 7: {
                this.wizard.setOrder(1);
                this.wizard.setSize(143360);
                return new DiskImageNamePane(this.parent, this.wizard);
            }
            case 2: {
                this.wizard.setOrder(1);
                this.wizard.setSize(819264);
                return new DiskImageNamePane(this.parent, this.wizard);
            }
            case 6: {
                this.wizard.setOrder(2);
                this.wizard.setSize(819264);
                return new DiskImageNamePane(this.parent, this.wizard);
            }
            case 3: 
            case 4: {
                this.wizard.setOrder(2);
                return new DiskImageSizePane(this.parent, this.wizard);
            }
        }
        return null;
    }

    public void open() {
        this.control = new Composite(this.parent, 0);
        this.wizard.enableNextButton(true);
        this.wizard.enableFinishButton(false);
        RowLayout rowLayout = new RowLayout(512);
        rowLayout.justify = true;
        rowLayout.marginBottom = 5;
        rowLayout.marginLeft = 5;
        rowLayout.marginRight = 5;
        rowLayout.marginTop = 5;
        rowLayout.spacing = 3;
        this.control.setLayout((Layout)rowLayout);
        Label label = new Label(this.control, 64);
        label.setText(this.textBundle.get("DiskImageFormatPrompt"));
        RowLayout rowLayout2 = new RowLayout(512);
        rowLayout2.justify = true;
        rowLayout2.spacing = 3;
        Composite composite = new Composite(this.control, 0);
        composite.setLayout((Layout)rowLayout2);
        this.createRadioButton(composite, this.textBundle.get("Dos"), 1, this.textBundle.get("DiskImageFormatDosTooltip"));
        this.createRadioButton(composite, this.textBundle.get("Unidos"), 2, this.textBundle.get("DiskImageFormatUnidosTooltip"));
        this.createRadioButton(composite, this.textBundle.get("Ozdos"), 6, this.textBundle.get("DiskImageFormatOzdosTooltip"));
        this.createRadioButton(composite, this.textBundle.get("Prodos"), 3, this.textBundle.get("DiskImageFormatProdosTooltip"));
        this.createRadioButton(composite, this.textBundle.get("Pascal"), 4, this.textBundle.get("DiskImageFormatPascalTooltip"));
        this.createRadioButton(composite, this.textBundle.get("Rdos"), 5, this.textBundle.get("DiskImageFormatRdosTooltip"));
        this.createRadioButton(composite, this.textBundle.get("Cpm"), 7, this.textBundle.get("DiskImageFormatCpmTooltip"));
        this.control.pack();
    }

    protected void createRadioButton(Composite composite, String string, final int n, String string2) {
        Button button = new Button(composite, 16);
        button.setText(string);
        button.setSelection(this.wizard.getFormat() == n);
        button.setToolTipText(string2);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DiskImageFormatPane.this.getWizard().setFormat(n);
            }
        });
    }

    public void dispose() {
        this.control.dispose();
    }

    protected DiskImageWizard getWizard() {
        return this.wizard;
    }
}

