/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.ui.swt;

import com.webcodepro.applecommander.storage.Disk;
import com.webcodepro.applecommander.storage.FormattedDisk;
import com.webcodepro.applecommander.ui.UiBundle;
import com.webcodepro.applecommander.ui.UserPreferences;
import com.webcodepro.applecommander.ui.swt.DiskWindow;
import com.webcodepro.applecommander.ui.swt.util.ImageCanvas;
import com.webcodepro.applecommander.ui.swt.util.ImageManager;
import com.webcodepro.applecommander.ui.swt.wizard.comparedisks.CompareDisksWizard;
import com.webcodepro.applecommander.ui.swt.wizard.diskimage.DiskImageWizard;
import com.webcodepro.applecommander.util.TextBundle;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class SwtAppleCommander
implements Listener {
    private Shell shell;
    private ToolBar toolBar;
    private UserPreferences userPreferences = UserPreferences.getInstance();
    private TextBundle textBundle = UiBundle.getInstance();
    private ImageCanvas imageCanvas;
    private static ImageManager imageManager;

    public static void main(String[] stringArray) {
        new SwtAppleCommander().launch();
    }

    public void launch() {
        Display display = new Display();
        this.launch(display);
    }

    public void launch(Display display) {
        imageManager = new ImageManager(display);
        SwtAppleCommander swtAppleCommander = new SwtAppleCommander();
        Shell shell = swtAppleCommander.open(display);
        shell.forceActive();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        UserPreferences.getInstance().save();
    }

    protected Shell open(Display display) {
        Display.setAppName((String)this.textBundle.get("SwtAppleCommander.AppleCommander"));
        this.shell = new Shell(display, 2272);
        this.shell.setText(this.textBundle.get("SwtAppleCommander.AppleCommander"));
        this.shell.setImage(imageManager.get("diskicon.gif"));
        this.shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                SwtAppleCommander.this.dispose(disposeEvent);
            }
        });
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 5;
        gridLayout.marginWidth = 5;
        this.shell.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        this.createToolBar(this.shell, gridData);
        gridData = new GridData();
        Image image = imageManager.get("AppleCommanderLogo.gif");
        gridData.widthHint = image.getImageData().width;
        gridData.heightHint = image.getImageData().height;
        this.imageCanvas = new ImageCanvas((Composite)this.shell, 2048, image, gridData);
        this.imageCanvas.addListener(2, this);
        this.imageCanvas.setFocus();
        this.shell.pack();
        this.shell.open();
        return this.shell;
    }

    protected void dispose(DisposeEvent disposeEvent) {
        this.imageCanvas.dispose();
        this.toolBar.dispose();
        imageManager.dispose();
    }

    protected void openFile() {
        FileDialog fileDialog = new FileDialog(this.shell, 4096);
        Disk.FilenameFilter[] filenameFilterArray = Disk.getFilenameFilters();
        String[] stringArray = new String[filenameFilterArray.length];
        String[] stringArray2 = new String[filenameFilterArray.length];
        for (int i = 0; i < filenameFilterArray.length; ++i) {
            stringArray[i] = filenameFilterArray[i].getNames();
            stringArray2[i] = filenameFilterArray[i].getExtensions();
        }
        fileDialog.setFilterNames(stringArray);
        fileDialog.setFilterExtensions(stringArray2);
        fileDialog.setFilterPath(this.userPreferences.getDiskImageDirectory());
        String string = fileDialog.open();
        if (string != null) {
            this.userPreferences.setDiskImageDirectory(fileDialog.getFilterPath());
            try {
                Disk disk = new Disk(string);
                FormattedDisk[] formattedDiskArray = disk.getFormattedDisks();
                if (formattedDiskArray != null) {
                    DiskWindow diskWindow = new DiskWindow(this.shell, formattedDiskArray, imageManager);
                    diskWindow.open();
                } else {
                    this.showUnrecognizedDiskFormatMessage(string);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.showUnrecognizedDiskFormatMessage(string);
            }
        }
    }

    protected void showUnrecognizedDiskFormatMessage(String string) {
        Shell shell = this.shell;
        MessageBox messageBox = new MessageBox(shell, 33);
        messageBox.setText(this.textBundle.get("SwtAppleCommander.UnrecognizedFormatTitle"));
        messageBox.setMessage(this.textBundle.format("SwtAppleCommander.UnrecognizedFormatMessage", string));
        messageBox.open();
    }

    protected void createDiskImage() {
        DiskImageWizard diskImageWizard = new DiskImageWizard(this.shell, imageManager);
        diskImageWizard.open();
        if (diskImageWizard.isWizardCompleted()) {
            FormattedDisk[] formattedDiskArray = diskImageWizard.getFormattedDisks();
            DiskWindow diskWindow = new DiskWindow(this.shell, formattedDiskArray, imageManager);
            diskWindow.open();
        }
    }

    private void createToolBar(Shell shell, Object object) {
        this.toolBar = new ToolBar((Composite)shell, 0x800000);
        if (object != null) {
            this.toolBar.setLayoutData(object);
        }
        ToolItem toolItem = new ToolItem(this.toolBar, 8);
        toolItem.setImage(imageManager.get("opendisk.gif"));
        toolItem.setText(this.textBundle.get("OpenButton"));
        toolItem.setSelection(false);
        toolItem.setToolTipText(this.textBundle.get("SwtAppleCommander.OpenDiskImageTooltip"));
        toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SwtAppleCommander.this.openFile();
            }
        });
        toolItem = new ToolItem(this.toolBar, 2);
        toolItem = new ToolItem(this.toolBar, 8);
        toolItem.setImage(imageManager.get("newdisk.gif"));
        toolItem.setText(this.textBundle.get("CreateButton"));
        toolItem.setToolTipText(this.textBundle.get("SwtAppleCommander.CreateDiskImageTooltip"));
        toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SwtAppleCommander.this.createDiskImage();
            }
        });
        toolItem = new ToolItem(this.toolBar, 2);
        toolItem = new ToolItem(this.toolBar, 8);
        toolItem.setImage(imageManager.get("comparedisks.gif"));
        toolItem.setText(this.textBundle.get("CompareButton"));
        toolItem.setToolTipText(this.textBundle.get("SwtAppleCommander.CompareDiskImageTooltip"));
        toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SwtAppleCommander.this.compareDiskImages();
            }
        });
        toolItem = new ToolItem(this.toolBar, 2);
        toolItem = new ToolItem(this.toolBar, 8);
        toolItem.setImage(imageManager.get("about.gif"));
        toolItem.setText(this.textBundle.get("AboutButton"));
        toolItem.setToolTipText(this.textBundle.get("SwtAppleCommander.AboutTooltip"));
        toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SwtAppleCommander.this.showAboutAppleCommander();
            }
        });
        toolItem = new ToolItem(this.toolBar, 2);
        this.toolBar.pack();
    }

    public void showAboutAppleCommander() {
        Shell shell = this.shell;
        MessageBox messageBox = new MessageBox(shell, 34);
        messageBox.setText(this.textBundle.get("SwtAppleCommander.AboutTitle"));
        messageBox.setMessage(this.textBundle.format("SwtAppleCommander.AboutMessage", new Object[]{"1.3.5.9", this.textBundle.get("Copyright")}));
        messageBox.open();
    }

    public void handleEvent(Event event) {
        if (event.type == 2 && (event.stateMask & 0x40000) != 0) {
            switch (event.character) {
                case '\u0001': {
                    this.showAboutAppleCommander();
                    break;
                }
                case '\u0003': {
                    this.createDiskImage();
                    break;
                }
                case '\u000f': {
                    this.openFile();
                    break;
                }
                case '\u0005': {
                    this.compareDiskImages();
                }
            }
        }
    }

    public void compareDiskImages() {
        CompareDisksWizard compareDisksWizard = new CompareDisksWizard(this.shell, imageManager);
        compareDisksWizard.open();
    }
}

