/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.util;

import com.webcodepro.applecommander.storage.FormattedDisk;
import com.webcodepro.applecommander.storage.physical.ImageOrder;
import com.webcodepro.applecommander.util.TextBundle;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;

public class AppleUtil {
    private static TextBundle textBundle = TextBundle.getInstance();
    private static final int BYTES_PER_LINE = 16;
    private static final int APPLE_SPACE = 32;
    private static byte[] masks = new byte[]{1, 2, 4, 8, 16, 32, 64, -128};
    private static char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static int getWordValue(byte[] byArray, int n) {
        if (n + 1 > byArray.length) {
            return 0;
        }
        return AppleUtil.getWordValue(byArray[n], byArray[n + 1]);
    }

    public static int getWordValue(byte by, byte by2) {
        return AppleUtil.getUnsignedByte(by) + AppleUtil.getUnsignedByte(by2) * 256;
    }

    public static int getSignedWordValue(byte[] byArray, int n) {
        int n2 = byArray[n + 1] * 256;
        return n2 + AppleUtil.getUnsignedByte(byArray[n]);
    }

    public static void setWordValue(byte[] byArray, int n, int n2) {
        byArray[n] = (byte)(n2 % 256);
        byArray[n + 1] = (byte)(n2 / 256);
    }

    public static int get3ByteValue(byte[] byArray, int n) {
        if (n + 2 > byArray.length) {
            return 0;
        }
        return AppleUtil.getUnsignedByte(byArray[n]) + AppleUtil.getUnsignedByte(byArray[n + 1]) * 256 + AppleUtil.getUnsignedByte(byArray[n + 2]) * 65536;
    }

    public static void set3ByteValue(byte[] byArray, int n, int n2) {
        byArray[n] = (byte)(n2 & 0xFF);
        byArray[n + 1] = (byte)((n2 & 0xFF00) >> 8);
        byArray[n + 2] = (byte)((n2 & 0xFF0000) >> 16);
    }

    public static int getUnsignedByte(byte by) {
        return by & 0xFF;
    }

    public static int getUnsignedByte(byte[] byArray, int n) {
        if (n + 1 > byArray.length) {
            return 0;
        }
        return AppleUtil.getUnsignedByte(byArray[n]);
    }

    public static int getBitCount(byte by) {
        int n = 0;
        for (int i = 0; i < 8; ++i) {
            if (!AppleUtil.isBitSet(by, i)) continue;
            ++n;
        }
        return n;
    }

    public static boolean isBitSet(byte by, int n) {
        return (by & masks[n]) != 0;
    }

    public static byte setBit(byte by, int n) {
        return (byte)((by | masks[n]) & 0xFF);
    }

    public static byte clearBit(byte by, int n) {
        return (byte)(by & ~masks[n] & 0xFF);
    }

    public static String getString(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[n2];
        for (int i = 0; i < n2; ++i) {
            byte by = byArray[n + i];
            byArray2[i] = by = (byte)(by & 0x7F);
        }
        return new String(byArray2);
    }

    public static void setString(byte[] byArray, int n, String string, int n2) {
        AppleUtil.setString(byArray, n, string, n2, true);
    }

    public static void setString(byte[] byArray, int n, String string, int n2, boolean bl) {
        for (int i = 0; i < n2; ++i) {
            int n3 = 32;
            if (i < string.length()) {
                n3 = string.charAt(i);
            }
            byArray[n + i] = (byte)(n3 | (bl ? 128 : 0));
        }
    }

    public static void setString(byte[] byArray, int n, String string) {
        AppleUtil.setString(byArray, n, string, string.length());
    }

    public static String getPascalString(byte[] byArray, int n) {
        int n2 = AppleUtil.getUnsignedByte(byArray[n]);
        return AppleUtil.getString(byArray, n + 1, n2);
    }

    public static void setPascalString(byte[] byArray, int n, String string, int n2) {
        int n3 = Math.min(string.length(), n2);
        byArray[n] = (byte)(n3 & 0xFF);
        AppleUtil.setString(byArray, n + 1, string, n3, false);
    }

    public static Date getPascalDate(byte[] byArray, int n) {
        int n2 = AppleUtil.getWordValue(byArray, n);
        int n3 = n2 & 0xE;
        int n4 = (n2 & 0x1F0) >> 4;
        int n5 = (n2 & 0xFE00) >> 9;
        if (n5 < 50) {
            n5 += 2000;
        }
        if (n5 < 100) {
            n5 += 1900;
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar(n5, n3, n4);
        return gregorianCalendar.getTime();
    }

    public static void setPascalDate(byte[] byArray, int n, Date date) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        int n2 = gregorianCalendar.get(2) + 1;
        int n3 = gregorianCalendar.get(5);
        int n4 = gregorianCalendar.get(1) % 100;
        int n5 = n2 & 0xF | n3 << 4 & 0x1F0 | n4 << 9 & 0xFE00;
        AppleUtil.setWordValue(byArray, n, n5);
    }

    public static String getProdosString(byte[] byArray, int n) {
        int n2 = AppleUtil.getUnsignedByte(byArray[n]) & 0xF;
        return AppleUtil.getString(byArray, n + 1, n2);
    }

    public static void setProdosString(byte[] byArray, int n, String string, int n2) {
        int n3 = Math.min(string.length(), n2);
        byArray[n] = (byte)(byArray[n] & 0xF0 | n3 & 0xF);
        AppleUtil.setString(byArray, n + 1, string, n3, false);
    }

    public static String getFormattedByte(int n) {
        int n2 = n & 0xF;
        int n3 = (n & 0xF0) >> 4;
        StringBuffer stringBuffer = new StringBuffer(2);
        stringBuffer.append(hexDigits[n3]);
        stringBuffer.append(hexDigits[n2]);
        return stringBuffer.toString();
    }

    public static String getFormattedWord(int n) {
        return AppleUtil.getFormattedByte((n & 0xFF00) >> 8) + AppleUtil.getFormattedByte(n & 0xFF);
    }

    public static String getFormatted3ByteAddress(int n) {
        return AppleUtil.getFormattedByte((n & 0xFF0000) >> 16) + AppleUtil.getFormattedWord(n & 0xFFFF);
    }

    public static int convertFormattedWord(String string) {
        if (string == null) {
            return 0;
        }
        int n = 0;
        string = string.toUpperCase();
        block0: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            for (int j = 0; j < hexDigits.length; ++j) {
                if (c != hexDigits[j]) continue;
                n <<= 4;
                n += j;
                continue block0;
            }
        }
        return n;
    }

    public static Date getProdosDate(byte[] byArray, int n) {
        int n2 = AppleUtil.getWordValue(byArray, n);
        if (n2 == 0) {
            return null;
        }
        int n3 = AppleUtil.getWordValue(byArray, n + 2);
        int n4 = n2 & 0x1F;
        int n5 = ((n2 & 0x1E0) >> 5) - 1;
        int n6 = (n2 & 0xFE00) >> 9;
        int n7 = n3 & 0x3F;
        int n8 = (n3 & 0x1F00) >> 8;
        if (n6 < 50) {
            n6 += 2000;
        }
        if (n6 < 100) {
            n6 += 1900;
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar(n6, n5, n4, n8, n7);
        return gregorianCalendar.getTime();
    }

    public static void setProdosDate(byte[] byArray, int n, Date date) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        if (date != null) {
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTime(date);
            n2 = gregorianCalendar.get(5);
            n3 = gregorianCalendar.get(2) + 1;
            n4 = gregorianCalendar.get(1);
            n5 = gregorianCalendar.get(12);
            n6 = gregorianCalendar.get(11);
            n4 = n4 >= 2000 ? (n4 -= 2000) : (n4 -= 1900);
        }
        int n7 = (n4 & 0x7F) << 9 | (n3 & 0xF) << 5 | n2 & 0x1F;
        int n8 = (n6 & 0x1F) << 8 | n5 & 0x3F;
        AppleUtil.setWordValue(byArray, n, n7);
        AppleUtil.setWordValue(byArray, n + 2, n8);
    }

    public static String getNiceFilename(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\\' || c == '/' || c == '?' || c == '*' || c == ':' || c == '\"' || c == '<' || c == '>' || c == '|') continue;
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static byte[] unpackBytes(byte[] byArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length * 2);
        int n = 0;
        byte[] byArray2 = new byte[4];
        block10: while (n < byArray.length) {
            byte by = byArray[n++];
            int n2 = (by & 0x3F) + 1;
            switch (by & 0xC0) {
                case 0: {
                    int n3;
                    for (n3 = 0; n3 < n2; ++n3) {
                        byteArrayOutputStream.write(byArray[n++]);
                    }
                    continue block10;
                }
                case 64: {
                    int n3;
                    byte by2 = byArray[n++];
                    for (n3 = 0; n3 < n2; ++n3) {
                        byteArrayOutputStream.write(by2);
                    }
                    continue block10;
                }
                case 128: {
                    int n3;
                    for (n3 = 0; n3 < 4; ++n3) {
                        byArray2[n3] = byArray[n++];
                    }
                    for (n3 = 0; n3 < n2; ++n3) {
                        try {
                            byteArrayOutputStream.write(byArray2);
                            continue;
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    continue block10;
                }
                case 192: {
                    int n3;
                    byte by2 = byArray[n++];
                    for (n3 = 0; n3 < 4; ++n3) {
                        byArray2[n3] = by2;
                    }
                    for (n3 = 0; n3 < n2; ++n3) {
                        try {
                            byteArrayOutputStream.write(byArray2);
                            continue;
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    break;
                }
            }
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static double getSaneNumber(byte[] byArray, int n) {
        long l = 0L;
        for (int i = 8; i > 0; --i) {
            l <<= 8;
            l += (long)AppleUtil.getUnsignedByte(byArray[n + i - 1]);
        }
        return Double.longBitsToDouble(l);
    }

    public static byte[] getApplesoftFloat(double d) {
        long l = Double.doubleToRawLongBits(Math.abs(d));
        long l2 = 0xFF0000000000000L;
        long l3 = 0x820000000000000L;
        long l4 = 0L;
        if (d < 0.0) {
            l4 = 0x80000000000000L;
        }
        long l5 = 0xFFFFFFFF00000L;
        long l6 = (l & l2) + l3 << 4 | l4 | (l & l5) << 3;
        long l7 = -72057594037927936L;
        long l8 = 0xFF000000000000L;
        long l9 = 0xFF0000000000L;
        long l10 = 0xFF00000000L;
        long l11 = 0xFF000000L;
        return new byte[]{(byte)((l6 & l7) >> 56 & 0xFFL), (byte)((l6 & l8) >> 48 & 0xFFL), (byte)((l6 & l9) >> 40 & 0xFFL), (byte)((l6 & l10) >> 32 & 0xFFL), (byte)((l6 & l11) >> 24 & 0xFFL)};
    }

    public static String getHexDump(byte[] byArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);
        printWriter.println(textBundle.get("AppleUtil.HexDumpLine1"));
        printWriter.println(textBundle.get("AppleUtil.HexDumpLine2"));
        for (int i = 0; i < byArray.length; i += 16) {
            int n;
            int n2;
            printWriter.print("$");
            printWriter.print(AppleUtil.getFormatted3ByteAddress(i));
            printWriter.print("  ");
            for (n2 = 0; n2 < 16; ++n2) {
                if (n2 == 8) {
                    printWriter.print(' ');
                }
                printWriter.print((n = i + n2) < byArray.length ? AppleUtil.getFormattedByte(byArray[n]) : "..");
                printWriter.print(' ');
            }
            printWriter.print(' ');
            for (n2 = 0; n2 < 16; ++n2) {
                if (n2 == 8) {
                    printWriter.print(' ');
                }
                if ((n = i + n2) < byArray.length) {
                    char c = (char)(byArray[n] & 0x7F);
                    if ((byte)c >= 32) {
                        printWriter.print(c);
                        continue;
                    }
                    printWriter.print('.');
                    continue;
                }
                printWriter.print(' ');
            }
            printWriter.println();
        }
        printWriter.println(textBundle.get("AppleUtil.HexDumpEndMessage"));
        printWriter.flush();
        printWriter.close();
        return byteArrayOutputStream.toString();
    }

    public static void changeImageOrderByTrackAndSector(ImageOrder imageOrder, ImageOrder imageOrder2) {
        if (!AppleUtil.sameSectorsPerDisk(imageOrder, imageOrder2)) {
            throw new IllegalArgumentException(textBundle.get("AppleUtil.CannotChangeImageOrder"));
        }
        for (int i = 0; i < imageOrder.getTracksPerDisk(); ++i) {
            for (int j = 0; j < imageOrder.getSectorsPerTrack(); ++j) {
                byte[] byArray = imageOrder.readSector(i, j);
                imageOrder2.writeSector(i, j, byArray);
            }
        }
    }

    protected static boolean sameSectorsPerDisk(ImageOrder imageOrder, ImageOrder imageOrder2) {
        return imageOrder.getSectorsPerDisk() == imageOrder2.getSectorsPerDisk();
    }

    public static boolean disksEqualByTrackAndSector(FormattedDisk formattedDisk, FormattedDisk formattedDisk2) {
        ImageOrder imageOrder;
        ImageOrder imageOrder2 = formattedDisk.getImageOrder();
        if (!AppleUtil.sameSectorsPerDisk(imageOrder2, imageOrder = formattedDisk2.getImageOrder())) {
            throw new IllegalArgumentException(textBundle.get("AppleUtil.CannotCompareDisks"));
        }
        for (int i = 0; i < imageOrder2.getTracksPerDisk(); ++i) {
            for (int j = 0; j < imageOrder2.getSectorsPerTrack(); ++j) {
                byte[] byArray;
                byte[] byArray2 = imageOrder2.readSector(i, j);
                if (Arrays.equals(byArray2, byArray = imageOrder.readSector(i, j))) continue;
                return false;
            }
        }
        return true;
    }

    public static void changeImageOrderByBlock(ImageOrder imageOrder, ImageOrder imageOrder2) {
        if (!AppleUtil.sameBlocksPerDisk(imageOrder, imageOrder2)) {
            throw new IllegalArgumentException(textBundle.get("AppleUtil.CannotChangeImageOrder"));
        }
        for (int i = 0; i < imageOrder.getBlocksOnDevice(); ++i) {
            byte[] byArray = imageOrder.readBlock(i);
            imageOrder2.writeBlock(i, byArray);
        }
    }

    protected static boolean sameBlocksPerDisk(ImageOrder imageOrder, ImageOrder imageOrder2) {
        return imageOrder.getBlocksOnDevice() == imageOrder2.getBlocksOnDevice();
    }

    public static boolean disksEqualByBlock(FormattedDisk formattedDisk, FormattedDisk formattedDisk2) {
        ImageOrder imageOrder;
        ImageOrder imageOrder2 = formattedDisk.getImageOrder();
        if (!AppleUtil.sameBlocksPerDisk(imageOrder2, imageOrder = formattedDisk2.getImageOrder())) {
            throw new IllegalArgumentException(textBundle.get("AppleUtil.CannotCompareDisks"));
        }
        for (int i = 0; i < imageOrder2.getBlocksOnDevice(); ++i) {
            byte[] byArray;
            byte[] byArray2 = imageOrder2.readBlock(i);
            if (Arrays.equals(byArray2, byArray = imageOrder.readBlock(i))) continue;
            return false;
        }
        return true;
    }
}

