/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.ui;

import com.webcodepro.applecommander.ui.UiBundle;
import com.webcodepro.applecommander.util.Host;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;

public class UserPreferences {
    private static final String FILENAME = "AppleCommander.preferences";
    private static final String IMAGE_DIRECTORY = "imageDirectory";
    private static final String EXPORT_DIRECTORY = "exportDirectory";
    private static final String COMPILE_DIRECTORY = "compileDirectory";
    private static final String SAVE_DIRECTORY = "saveDirectory";
    private static final String IMPORT_DIRECTORY = "importDirectory";
    private static UserPreferences instance;
    private Properties properties = new Properties();

    private UserPreferences() {
    }

    public static UserPreferences getInstance() {
        if (instance == null) {
            instance = new UserPreferences();
            instance.load();
        }
        return instance;
    }

    private void load() {
        try {
            FileInputStream fileInputStream = new FileInputStream(Host.getPrefDir() + FILENAME);
            this.properties.load(fileInputStream);
            fileInputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void save() {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(Host.getPrefDir() + FILENAME);
            this.properties.store(fileOutputStream, UiBundle.getInstance().get("UserPreferencesComment"));
            fileOutputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getDiskImageDirectory() {
        return this.properties.getProperty(IMAGE_DIRECTORY);
    }

    public String getExportDirectory() {
        return this.properties.getProperty(EXPORT_DIRECTORY);
    }

    public String getCompileDirectory() {
        return this.properties.getProperty(COMPILE_DIRECTORY);
    }

    public String getSaveDirectory() {
        return this.properties.getProperty(SAVE_DIRECTORY);
    }

    public String getImportDirectory() {
        return this.properties.getProperty(IMPORT_DIRECTORY);
    }

    public void setDiskImageDirectory(String string) {
        this.properties.setProperty(IMAGE_DIRECTORY, string);
    }

    public void setExportDirectory(String string) {
        this.properties.setProperty(EXPORT_DIRECTORY, string);
    }

    public void setCompileDirectory(String string) {
        this.properties.setProperty(COMPILE_DIRECTORY, string);
    }

    public void setSaveDirectory(String string) {
        this.properties.setProperty(SAVE_DIRECTORY, string);
    }

    public void setImportDirectory(String string) {
        this.properties.setProperty(IMPORT_DIRECTORY, string);
    }
}

