/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.storage.os.prodos;

import com.webcodepro.applecommander.storage.DiskFullException;
import com.webcodepro.applecommander.storage.FileEntry;
import com.webcodepro.applecommander.storage.FileFilter;
import com.webcodepro.applecommander.storage.StorageBundle;
import com.webcodepro.applecommander.storage.filters.AppleWorksDataBaseFileFilter;
import com.webcodepro.applecommander.storage.filters.AppleWorksSpreadSheetFileFilter;
import com.webcodepro.applecommander.storage.filters.AppleWorksWordProcessorFileFilter;
import com.webcodepro.applecommander.storage.filters.ApplesoftFileFilter;
import com.webcodepro.applecommander.storage.filters.AssemblySourceFileFilter;
import com.webcodepro.applecommander.storage.filters.BinaryFileFilter;
import com.webcodepro.applecommander.storage.filters.BusinessBASICFileFilter;
import com.webcodepro.applecommander.storage.filters.GraphicsFileFilter;
import com.webcodepro.applecommander.storage.filters.IntegerBasicFileFilter;
import com.webcodepro.applecommander.storage.filters.TextFileFilter;
import com.webcodepro.applecommander.storage.os.prodos.ProdosCommonEntry;
import com.webcodepro.applecommander.storage.os.prodos.ProdosFormatDisk;
import com.webcodepro.applecommander.util.AppleUtil;
import com.webcodepro.applecommander.util.TextBundle;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ProdosFileEntry
extends ProdosCommonEntry
implements FileEntry {
    private TextBundle textBundle = StorageBundle.getInstance();

    public ProdosFileEntry(ProdosFormatDisk prodosFormatDisk, int n, int n2) {
        super(prodosFormatDisk, n, n2);
    }

    public String getFilename() {
        int n;
        String string;
        if (this.isDeleted()) {
            string = AppleUtil.getString(this.readFileEntry(), 1, 15);
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < string.length() && (n = string.charAt(i)) != 0; ++i) {
                stringBuffer.append((char)n);
            }
            string = stringBuffer.toString();
        } else {
            string = AppleUtil.getProdosString(this.readFileEntry(), 0);
        }
        if (this.isAppleWorksFile()) {
            int n2 = this.getAuxiliaryType();
            StringBuffer stringBuffer = new StringBuffer(string);
            for (n = 0; n < 16 && n < string.length(); ++n) {
                boolean bl = n < 8 ? AppleUtil.isBitSet((byte)n2, 7 - n) : AppleUtil.isBitSet((byte)(n2 >> 8), 7 - n % 8);
                if (!bl) continue;
                char c = stringBuffer.charAt(n);
                if (c == '.') {
                    stringBuffer.setCharAt(n, ' ');
                    continue;
                }
                stringBuffer.setCharAt(n, Character.toLowerCase(c));
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    public int getMaximumFilenameLength() {
        return 15;
    }

    public void setFilename(String string) {
        byte[] byArray = this.readFileEntry();
        if (this.isDeleted()) {
            AppleUtil.setString(byArray, 1, string.toUpperCase(), 15);
        } else {
            AppleUtil.setProdosString(byArray, 0, string.toUpperCase(), 15);
        }
        if (this.isAppleWorksFile()) {
            byte by = 0;
            byte by2 = 0;
            for (int i = 0; i < string.length(); ++i) {
                if (!Character.isLowerCase(string.charAt(i))) continue;
                if (i < 8) {
                    by = AppleUtil.setBit(by, 7 - i);
                    continue;
                }
                if (i >= 16) continue;
                by2 = AppleUtil.setBit(by2, 7 - i % 8);
            }
            this.setAuxiliaryType(byArray, by, by2);
        }
        this.writeFileEntry(byArray);
    }

    public String getFiletype() {
        int n = this.getFiletypeByte();
        return this.getDisk().getFiletype(n);
    }

    public int getFiletypeByte() {
        return AppleUtil.getUnsignedByte(this.readFileEntry()[16]);
    }

    public void setFiletype(String string) {
        byte[] byArray = this.readFileEntry();
        byArray[16] = this.getDisk().getFiletype(string);
        this.writeFileEntry(byArray);
    }

    public boolean isAppleWorksFile() {
        int n = AppleUtil.getUnsignedByte(this.readFileEntry()[16]);
        return n == 25 || n == 26 || n == 27;
    }

    public int getKeyPointer() {
        return AppleUtil.getWordValue(this.readFileEntry(), 17);
    }

    public void setKeyPointer(int n) {
        byte[] byArray = this.readFileEntry();
        AppleUtil.setWordValue(byArray, 17, n);
        this.writeFileEntry(byArray);
    }

    public int getBlocksUsed() {
        return AppleUtil.getWordValue(this.readFileEntry(), 19);
    }

    public void setBlocksUsed(int n) {
        byte[] byArray = this.readFileEntry();
        AppleUtil.setWordValue(byArray, 19, n);
        this.writeFileEntry(byArray);
    }

    public int getEofPosition() {
        return AppleUtil.get3ByteValue(this.readFileEntry(), 21);
    }

    public void setEofPosition(int n) {
        byte[] byArray = this.readFileEntry();
        AppleUtil.set3ByteValue(byArray, 21, n);
        this.writeFileEntry(byArray);
    }

    public int getAuxiliaryType() {
        return AppleUtil.getWordValue(this.readFileEntry(), 31);
    }

    public void setAuxiliaryType(byte[] byArray, byte by, byte by2) {
        byArray[31] = by;
        byArray[32] = by2;
    }

    public void setAuxiliaryType(byte[] byArray, int n) {
        this.setAuxiliaryType(byArray, (byte)(n % 256), (byte)(n / 256));
    }

    public Date getLastModificationDate() {
        return AppleUtil.getProdosDate(this.readFileEntry(), 33);
    }

    public void setLastModificationDate(Date date) {
        byte[] byArray = this.readFileEntry();
        AppleUtil.setProdosDate(byArray, 33, date);
        this.writeFileEntry(byArray);
    }

    public int getHeaderPointer() {
        return AppleUtil.getWordValue(this.readFileEntry(), 37);
    }

    public void setHeaderPointer(int n) {
        byte[] byArray = this.readFileEntry();
        AppleUtil.setWordValue(byArray, 37, n);
        this.writeFileEntry(byArray);
    }

    public boolean isLocked() {
        return !this.canDestroy() && !this.canRename() && !this.canWrite();
    }

    public void setLocked(boolean bl) {
        this.setCanDestroy(!bl);
        this.setCanRename(!bl);
        this.setCanWrite(!bl);
    }

    public int getSize() {
        return this.getEofPosition();
    }

    public boolean isDirectory() {
        return this.getStorageType() == 13;
    }

    public boolean isDeleted() {
        return this.getStorageType() == 0;
    }

    public void delete() {
        this.getDisk().freeBlocks(this);
        int n = this.getHeaderPointer();
        byte[] byArray = this.getDisk().readBlock(n);
        int n2 = AppleUtil.getWordValue(byArray, 37);
        if (n2 != 0) {
            --n2;
        }
        AppleUtil.setWordValue(byArray, 37, n2);
        this.getDisk().writeBlock(n, byArray);
        byArray = this.readFileEntry();
        byArray[0] = 0;
        this.writeFileEntry(byArray);
    }

    public List getFileColumnData(int n) {
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.textBundle.get("DateFormat"));
        ArrayList<String> arrayList = new ArrayList<String>();
        switch (n) {
            case 2: {
                arrayList.add(this.isLocked() ? "*" : " ");
                arrayList.add(this.getFilename());
                arrayList.add(this.getFiletype());
                numberFormat.setMinimumIntegerDigits(3);
                arrayList.add(numberFormat.format(this.getBlocksUsed()));
                arrayList.add(this.getLastModificationDate() == null ? this.textBundle.get("ProdosFileEntry.NullDate") : simpleDateFormat.format(this.getLastModificationDate()));
                arrayList.add(this.getCreationDate() == null ? this.textBundle.get("ProdosFileEntry.NullDate") : simpleDateFormat.format(this.getCreationDate()));
                numberFormat.setMinimumIntegerDigits(1);
                arrayList.add(numberFormat.format(this.getEofPosition()));
                if ("TXT".equals(this.getFiletype()) && this.getAuxiliaryType() > 0) {
                    numberFormat.setMinimumIntegerDigits(1);
                    arrayList.add("L=" + numberFormat.format(this.getAuxiliaryType()).trim());
                    break;
                }
                if (("BIN".equals(this.getFiletype()) || "BAS".equals(this.getFiletype()) || "VAR".equals(this.getFiletype()) || "SYS".equals(this.getFiletype())) && this.getAuxiliaryType() > 0) {
                    arrayList.add("A=$" + AppleUtil.getFormattedWord(this.getAuxiliaryType()));
                    break;
                }
                arrayList.add("");
                break;
            }
            case 3: {
                arrayList.add(this.isLocked() ? "*" : " ");
                arrayList.add(this.getFilename());
                arrayList.add(this.isDeleted() ? this.textBundle.get("Deleted") : "");
                String string = "";
                if (this.canDestroy()) {
                    string = string + this.textBundle.get("Destroy");
                }
                if (this.canRead()) {
                    string = string + this.textBundle.get("Read");
                }
                if (this.canRename()) {
                    string = string + this.textBundle.get("Rename");
                }
                if (this.canWrite()) {
                    string = string + this.textBundle.get("Write");
                }
                arrayList.add(string);
                arrayList.add(this.getFiletype());
                arrayList.add(this.isDirectory() ? this.textBundle.get("ProdosFileEntry.Directory") : "");
                numberFormat.setMinimumIntegerDigits(3);
                arrayList.add(numberFormat.format(this.getBlocksUsed()));
                arrayList.add(this.getLastModificationDate() == null ? this.textBundle.get("ProdosFileEntry.NullDate") : simpleDateFormat.format(this.getLastModificationDate()));
                arrayList.add(this.getCreationDate() == null ? this.textBundle.get("ProdosFileEntry.NullDate") : simpleDateFormat.format(this.getCreationDate()));
                numberFormat.setMinimumIntegerDigits(1);
                arrayList.add(numberFormat.format(this.getEofPosition()));
                if ("TXT".equals(this.getFiletype()) && this.getAuxiliaryType() > 0) {
                    numberFormat.setMinimumIntegerDigits(1);
                    arrayList.add("L=" + numberFormat.format(this.getAuxiliaryType()).trim());
                } else if (("BIN".equals(this.getFiletype()) || "BAS".equals(this.getFiletype()) || "VAR".equals(this.getFiletype()) || "SYS".equals(this.getFiletype())) && this.getAuxiliaryType() > 0) {
                    arrayList.add("A=$" + AppleUtil.getFormattedWord(this.getAuxiliaryType()));
                } else {
                    arrayList.add("$" + AppleUtil.getFormattedWord(this.getAuxiliaryType()));
                }
                arrayList.add(AppleUtil.getFormattedWord(this.getHeaderPointer()));
                arrayList.add(AppleUtil.getFormattedWord(this.getKeyPointer()));
                arrayList.add(this.isSaplingFile() ? this.textBundle.get("ProdosFileEntry.Sapling") : (this.isSeedlingFile() ? this.textBundle.get("ProdosFileEntry.Seedling") : (this.isTreeFile() ? this.textBundle.get("ProdosFileEntry.Tree") : this.textBundle.format("ProdosFileEntry.UnknownFileType", this.getFileTypeString()))));
                arrayList.add(this.hasChanged() ? this.textBundle.get("ProdosFileEntry.Changed") : "");
                numberFormat.setMinimumIntegerDigits(1);
                arrayList.add(numberFormat.format(this.getMinimumProdosVersion()));
                arrayList.add(numberFormat.format(this.getProdosVersion()));
                break;
            }
            default: {
                arrayList.add(this.getFilename());
                arrayList.add(this.getFiletype());
                arrayList.add(numberFormat.format(this.getSize()));
                arrayList.add(this.isLocked() ? this.textBundle.get("Locked") : "");
            }
        }
        return arrayList;
    }

    public String getFileTypeString() {
        return "$" + AppleUtil.getFormattedByte(this.getStorageType());
    }

    public byte[] getFileData() {
        return this.getDisk().getFileData(this);
    }

    public void setFileData(byte[] byArray) throws DiskFullException {
        this.getDisk().setFileData(this, byArray);
    }

    public FileFilter getSuggestedFilter() {
        int n = this.getFiletypeByte();
        int n2 = this.getAuxiliaryType();
        int n3 = this.getSize();
        switch (n) {
            case 4: {
                if (this.getFilename().endsWith(".S")) {
                    return new AssemblySourceFileFilter();
                }
                return new TextFileFilter();
            }
            case 9: {
                return new BusinessBASICFileFilter();
            }
            case 176: {
                return new TextFileFilter();
            }
            case 25: {
                return new AppleWorksDataBaseFileFilter();
            }
            case 26: {
                return new AppleWorksWordProcessorFileFilter();
            }
            case 27: {
                return new AppleWorksSpreadSheetFileFilter();
            }
            case 252: {
                return new ApplesoftFileFilter();
            }
            case 250: {
                return new IntegerBasicFileFilter();
            }
            case 192: {
                if (n2 != 1) break;
                GraphicsFileFilter graphicsFileFilter = new GraphicsFileFilter();
                graphicsFileFilter.setMode(5);
                return graphicsFileFilter;
            }
            case 193: {
                if (n2 == 0 || n2 == 2 && n3 == 32768) {
                    GraphicsFileFilter graphicsFileFilter = new GraphicsFileFilter();
                    graphicsFileFilter.setMode(5);
                    return graphicsFileFilter;
                }
                if (n2 != 2 || n3 != 38400) break;
                GraphicsFileFilter graphicsFileFilter = new GraphicsFileFilter();
                graphicsFileFilter.setMode(6);
                return graphicsFileFilter;
            }
            case 6: {
                if (n3 >= 8184 && n3 <= 8192) {
                    GraphicsFileFilter graphicsFileFilter = new GraphicsFileFilter();
                    graphicsFileFilter.setMode(2);
                    return graphicsFileFilter;
                }
                if (n3 < 16376 || n3 > 16384) break;
                GraphicsFileFilter graphicsFileFilter = new GraphicsFileFilter();
                graphicsFileFilter.setMode(4);
                return graphicsFileFilter;
            }
            case 202: {
                GraphicsFileFilter graphicsFileFilter = new GraphicsFileFilter();
                graphicsFileFilter.setMode(7);
                return graphicsFileFilter;
            }
        }
        return new BinaryFileFilter();
    }

    public boolean needsAddress() {
        return this.getDisk().needsAddress(this.getFiletype());
    }

    public void setAddress(int n) {
        byte[] byArray = this.readFileEntry();
        this.setAuxiliaryType(byArray, n);
        this.writeFileEntry(byArray);
    }

    public boolean canCompile() {
        return this.getDisk().canCompile(this.getFiletype());
    }
}

