**********************************************************
*                                                        *
* APPLECOMMANDER boot code.                              *
* Copyright (c) 2002, Rob Greene                         *
*                                                        *
* This code is published under the GPL license.  See the *
* AppleCommander site for license information.           *
*                                                        *
**********************************************************

 ORG $800
*
* Zero page variables.  Used by Apple ][ ROM routines
* as well as this code.
*
XEND = $2C
ADDR = $26
*
* Keyboard switches
*
KEYBOARD = $C000
KEYCLEAR = $C010
*
* Disk ][ interface locations
*
MOTOROFF = $C088
*
* General Apple ][ ROM locations
*
TEXT = $FB2F
HOME = $FC58
GR = $FB40
COLOR = $F864
HLIN = $F819
PRINT = $FDF0
REBOOT = $FAA6
CALCADDR = $F847
DELAY = $FCA8
*
* Image offset locations (from upper-left).
* Note that, due to space, the XOFFSET isn't
* currently used - but, because of the rotating
* image, it doesn't really matter!
*
XOFFSET = 14
YOFFSET = 13
*
* The boot rom (probably $C600) uses the first byte
* to indicate the number of sectors to load.  Normally
* this is just one sector, so this program is constrained
* to 256 bytes - just in case of compatibility problems.
*
 DFB 1
*
* General setup.
*
 LDA MOTOROFF,X
 JSR TEXT
 JSR HOME
 JSR GR
*
* Draw the AppleCommander logo (well, sorta).
* DATA1 and DATA2 contain 4 values - the color value,
* the xstart (start of line), xend (end of line), as
* well as the Y position.
*
 LDX #DATA2-DATA1
:LOGO LDA DATA1-1,X
 LSR
 LSR
 LSR
 LSR
 JSR COLOR
 LDA DATA2-1,X
 LSR
 LSR
 LSR
 LSR
 STA XEND
 LDA DATA1-1,X
 AND #$F
 TAY
 LDA DATA2-1,X
 AND #$F
 CLC
 ADC #YOFFSET
 JSR HLIN
 DEX
 BNE :LOGO
*
* Display AppleCommander message.
*
:TEXT LDA MESSAGE,X
 BEQ :WAIT
 JSR PRINT
 INX
 BNE :TEXT
*
* Check for a keypress
*
:WAIT LDA KEYBOARD
 BPL :SETUP
 STA KEYCLEAR
 JMP REBOOT
*
* Rotate the screen (isn't that retro)!
*
:SETUP LDX #19
:ROTATE TXA
 JSR CALCADDR
 LDY #0
 LDA (ADDR),Y
 PHA
:SHIFT INY
 LDA (ADDR),Y
 DEY
 STA (ADDR),Y
 INY
 CPY #39
 BNE :SHIFT
 PLA
 STA (ADDR),Y
 DEX
 BPL :ROTATE
*
* Introduce a pause between rotations.
*
:KEYLOOP LDA #$08
 JSR DELAY
 DEX
 BNE :KEYLOOP
 BEQ :WAIT
*
* The image data codes the upper nybble with one
* value and the lower nybble with the second value
* in an effort to conserve space.  Thus, 17 HLINs
* are stored in 34 bytes instead of 68.
*
* DATA1 consists of color and x1 (start) position.
*
DATA1 HEX C8C7C6C3C8C2 ; green
 HEX D1D1 ; yellow
 HEX 9090 ; orange
 HEX 1010 ; red
 HEX 3131 ; purple
 HEX 626368 ; blue
*
* DATA2 consists of x2 (end) and y position.
*
DATA2 HEX 90817253B3C4
 HEX D5D6
 HEX C7B8
 HEX B9CA
 HEX DBDC
 HEX CD5EBE
*
* Text message to display at bottom of screen.
*
MESSAGE ASC "THIS DISK CREATED WITH APPLECOMMANDER"8D
 ASC "VISIT APPLECOMMANDER.SF.NET"8D
 ASC " "8D
 ASC "INSERT ANOTHER DISK AND PRESS ANY KEY"00

