/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.storage.physical;

import com.webcodepro.applecommander.storage.physical.ByteArrayImageLayout;
import com.webcodepro.applecommander.storage.physical.ImageOrder;

public class ProdosOrder
extends ImageOrder {
    private static final int[] blockInterleave = new int[]{0, 7, 6, 6, 5, 5, 4, 4, 3, 3, 2, 2, 1, 1, 0, 7};
    private static final int[] blockOffsets = new int[]{0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 1};

    public ProdosOrder(ByteArrayImageLayout byteArrayImageLayout) {
        super(byteArrayImageLayout);
    }

    public boolean isBlockDevice() {
        return true;
    }

    public boolean isTrackAndSectorDevice() {
        return false;
    }

    public byte[] readBlock(int n) {
        return this.readBytes(n * 512, 512);
    }

    public void writeBlock(int n, byte[] byArray) {
        this.writeBytes(n * 512, byArray);
    }

    public byte[] readSector(int n, int n2) throws IllegalArgumentException {
        int n3 = n * 8 + blockInterleave[n2];
        byte[] byArray = this.readBlock(n3);
        int n4 = blockOffsets[n2];
        byte[] byArray2 = new byte[256];
        System.arraycopy(byArray, n4 * 256, byArray2, 0, 256);
        return byArray2;
    }

    public void writeSector(int n, int n2, byte[] byArray) throws IllegalArgumentException {
        int n3 = n * 8 + blockInterleave[n2];
        byte[] byArray2 = this.readBlock(n3);
        int n4 = blockOffsets[n2];
        System.arraycopy(byArray, 0, byArray2, n4 * 256, byArray.length);
        this.writeBlock(n3, byArray2);
    }
}

