/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.ui.swt.filteradapter;

import com.webcodepro.applecommander.ui.swt.FileViewerWindow;
import com.webcodepro.applecommander.ui.swt.filteradapter.FilterAdapter;
import com.webcodepro.applecommander.ui.swt.util.contentadapter.StyledTextAdapter;
import com.webcodepro.applecommander.util.ApplesoftToken;
import com.webcodepro.applecommander.util.ApplesoftTokenizer;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ApplesoftFilterAdapter
extends FilterAdapter {
    private StyledText styledText;

    public ApplesoftFilterAdapter(FileViewerWindow fileViewerWindow, String string, String string2, Image image) {
        super(fileViewerWindow, string, string2, image);
    }

    public void display() {
        if (this.styledText == null) {
            this.createStyledText();
        }
        Point point = this.styledText.computeSize(-1, -1, true);
        this.getComposite().setContent((Control)this.styledText);
        this.getComposite().setExpandHorizontal(true);
        this.getComposite().setExpandVertical(true);
        this.getComposite().setMinWidth(point.x);
        this.getComposite().setMinHeight(point.y);
        this.getComposite().getContent().addListener(2, this.getToolbarCommandHandler());
        this.setContentTypeAdapter(new StyledTextAdapter(this.styledText, this.getFileEntry().getFilename()));
    }

    public void dispose() {
        this.styledText.dispose();
    }

    protected void createStyledText() {
        this.styledText = new StyledText((Composite)this.getComposite(), 0);
        this.styledText.setForeground(this.getBlackColor());
        this.styledText.setFont(this.getCourierFont());
        this.styledText.setEditable(false);
        ApplesoftTokenizer applesoftTokenizer = new ApplesoftTokenizer(this.getFileEntry());
        boolean bl = true;
        while (applesoftTokenizer.hasMoreTokens()) {
            StyleRange styleRange;
            int n;
            ApplesoftToken applesoftToken = applesoftTokenizer.getNextToken();
            if (applesoftToken == null) continue;
            if (applesoftToken.isLineNumber()) {
                if (bl) {
                    bl = false;
                } else {
                    this.styledText.append("\n");
                }
                this.styledText.append(Integer.toString(applesoftToken.getLineNumber()));
                this.styledText.append(" ");
                continue;
            }
            if (applesoftToken.isCommandSeparator() || applesoftToken.isExpressionSeparator()) {
                this.styledText.append(applesoftToken.getStringValue());
                continue;
            }
            if (applesoftToken.isEndOfCommand()) {
                this.styledText.append("\n");
                continue;
            }
            if (applesoftToken.isString()) {
                n = this.styledText.getCharCount();
                this.styledText.append(applesoftToken.getStringValue());
                styleRange = new StyleRange();
                styleRange.start = n;
                styleRange.length = applesoftToken.getStringValue().length();
                styleRange.foreground = this.getGreenColor();
                this.styledText.setStyleRange(styleRange);
                continue;
            }
            if (!applesoftToken.isToken()) continue;
            n = this.styledText.getCharCount();
            this.styledText.append(applesoftToken.getTokenString());
            styleRange = new StyleRange();
            styleRange.start = n;
            styleRange.length = applesoftToken.getTokenString().length();
            styleRange.foreground = this.getBlueColor();
            this.styledText.setStyleRange(styleRange);
        }
    }
}

