/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.ui.swt;

import com.webcodepro.applecommander.storage.FormattedDisk;
import com.webcodepro.applecommander.ui.UiBundle;
import com.webcodepro.applecommander.util.TextBundle;
import java.util.Iterator;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class DiskInfoTab {
    private TextBundle textBundle = UiBundle.getInstance();
    private Table infoTable;
    private Composite composite;
    private FormattedDisk[] formattedDisks;

    public DiskInfoTab(CTabFolder cTabFolder, FormattedDisk[] formattedDiskArray) {
        this.formattedDisks = formattedDiskArray;
        CTabItem cTabItem = new CTabItem(cTabFolder, 0);
        cTabItem.setText(this.textBundle.get("DiskInfoTab.Title"));
        cTabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DiskInfoTab.this.getInfoTable().removeAll();
                DiskInfoTab.this.buildDiskInfoTable(DiskInfoTab.this.getFormattedDisk(0));
            }
        });
        ScrolledComposite scrolledComposite = new ScrolledComposite((Composite)cTabFolder, 2816);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        cTabItem.setControl((Control)scrolledComposite);
        this.composite = new Composite((Composite)scrolledComposite, 0);
        this.createDiskInfoTable();
        if (formattedDiskArray.length > 1) {
            RowLayout rowLayout = new RowLayout(512);
            rowLayout.wrap = false;
            this.composite.setLayout((Layout)rowLayout);
            for (int i = 0; i < formattedDiskArray.length; ++i) {
                Label label = new Label(this.composite, 0);
                label.setText(formattedDiskArray[i].getDiskName());
                this.buildDiskInfoTable(formattedDiskArray[i]);
            }
        } else {
            this.composite.setLayout((Layout)new FillLayout());
            this.buildDiskInfoTable(formattedDiskArray[0]);
        }
        this.composite.pack();
        scrolledComposite.setContent((Control)this.composite);
        scrolledComposite.setMinSize(this.composite.computeSize(-1, -1));
    }

    public void createDiskInfoTable() {
        this.infoTable = new Table(this.composite, 65536);
        this.infoTable.setHeaderVisible(true);
        TableColumn tableColumn = new TableColumn(this.infoTable, 16384);
        tableColumn.setResizable(true);
        tableColumn.setText(this.textBundle.get("DiskInfoTab.LabelHeader"));
        tableColumn.setWidth(200);
        tableColumn = new TableColumn(this.infoTable, 16384);
        tableColumn.setResizable(true);
        tableColumn.setText(this.textBundle.get("DiskInfoTab.ValueHeader"));
        tableColumn.setWidth(400);
    }

    public void buildDiskInfoTable(FormattedDisk formattedDisk) {
        Iterator iterator = formattedDisk.getDiskInformation().iterator();
        TableItem tableItem = null;
        while (iterator.hasNext()) {
            FormattedDisk.DiskInformation diskInformation = (FormattedDisk.DiskInformation)iterator.next();
            tableItem = new TableItem(this.infoTable, 0);
            tableItem.setText(new String[]{diskInformation.getLabel(), diskInformation.getValue()});
        }
    }

    public void dispose() {
        this.infoTable.dispose();
        this.composite.dispose();
    }

    protected Table getInfoTable() {
        return this.infoTable;
    }

    protected FormattedDisk getFormattedDisk(int n) {
        return this.formattedDisks[n];
    }
}

