/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.storage.filters;

import com.webcodepro.applecommander.storage.FileEntry;
import com.webcodepro.applecommander.storage.FileFilter;
import com.webcodepro.applecommander.util.AppleUtil;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.text.NumberFormat;

public class AppleWorksSpreadSheetFileFilter
implements FileFilter {
    private static final int HEADER_SSMINVERS_BYTE = 242;
    private static final int CELL_VALUE_CONSTANT_MASK = 41184;
    private static final int CELL_VALUE_CONSTANT_ID = 40960;
    private static final int CELL_VALUE_LABEL_MASK = 41096;
    private static final int CELL_VALUE_LABEL_ID = 32904;
    private static final int CELL_VALUE_FORMULA_MASK = 41088;
    private static final int CELL_VALUE_FORMULA_ID = 32896;
    private static final int CELL_PROPAGATED_VALUE_MASK = 160;
    private static final int CELL_PROPAGATED_VALUE_ID = 32;
    private static final int CELL_LABEL_VALUE_MASK = 224;
    private static final int CELL_LABEL_VALUE_ID = 0;
    private static final int FORMULA_OFFSET = 192;
    private static final String[] formulaText = new String[]{"@Deg", "@Rad", "@Pi", "@True", "@False", "@Not", "@IsBlank", "@IsNA", "@IsError", "@Exp", "@Ln", "@Log", "@Cos", "@Sin", "@Tan", "@ACos", "@ASin", "@ATan2", "@ATan", "@Mod", "@FV", "@PV", "@PMT", "@Term", "@Rate", "@Round", "@Or", "@And", "@Sum", "@Avg", "@Choose", "@Count", "@Error", "@IRR", "@If", "@Int", "@Lookup", "@Max", "@Min", "@NA", "@NPV", "@Sqrt", "@Abs", null, "<>", ">=", "<=", "=", ">", "<", ",", "^", ")", "-", "+", "/", "*", "(", "-", "+", "..", null, null, null};
    private static final int FORMULA_ERROR_CODE = 224;
    private static final int FORMULA_NA_CODE = 231;
    private static final int FORMULA_SANE_CODE = 253;
    private static final int FORMULA_ROW_COLUMN_CODE = 254;
    private static final int FORMULA_STRING_CODE = 255;

    public byte[] filter(FileEntry fileEntry) {
        byte[] byArray = fileEntry.getFileData();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter(byteArrayOutputStream, true);
        boolean bl = byArray[242] == 30;
        int n = 300 + (bl ? 2 : 0);
        int n2 = AppleUtil.getWordValue(byArray, n);
        while (n2 != 65535) {
            int n3 = AppleUtil.getWordValue(byArray, n + 2);
            this.processRow(printWriter, byArray, n += 4, n3);
            n2 = AppleUtil.getWordValue(byArray, n += n2 - 2);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public String getSuggestedFileName(FileEntry fileEntry) {
        return fileEntry.getFilename() + ".csv";
    }

    public void processRow(PrintWriter printWriter, byte[] byArray, int n, int n2) {
        int n3 = 0;
        while (true) {
            int n4;
            if ((n4 = AppleUtil.getUnsignedByte(byArray[n])) <= 127) {
                if (n3 > 0) {
                    printWriter.print(",");
                }
                this.processCell(printWriter, byArray, n + 1, n4, n2, n3);
                n += n4;
            } else {
                if (n4 >= 255) break;
                if (n3 > 0) {
                    printWriter.print(",");
                }
                int n5 = n4 - 128;
                this.skipColumns(n3, printWriter, n5);
                n3 += n5;
            }
            ++n;
            ++n3;
        }
        printWriter.println();
    }

    protected void skipColumns(int n, PrintWriter printWriter, int n2) {
        while (n2 > 0) {
            if (n > 0) {
                printWriter.print(",");
            }
            printWriter.print("\",\"");
            --n2;
            ++n;
        }
    }

    protected void processCell(PrintWriter printWriter, byte[] byArray, int n, int n2, int n3, int n4) {
        int n5;
        int n6 = AppleUtil.getUnsignedByte(byArray[n]);
        int n7 = (n6 << 8) + (n5 = AppleUtil.getUnsignedByte(byArray[n + 1]));
        if ((n7 & 0xA0E0) == 40960) {
            double d = AppleUtil.getSaneNumber(byArray, n + 2);
            printWriter.print(d);
        } else if ((n7 & 0xA088) != 32904) {
            if ((n7 & 0xA080) == 32896) {
                int n8 = 10;
                printWriter.print('\"');
                block7: while (n8 < n2) {
                    int n9 = AppleUtil.getUnsignedByte(byArray[n + n8]);
                    ++n8;
                    switch (n9) {
                        case 224: {
                            n8 += 3;
                            continue block7;
                        }
                        case 231: {
                            n8 += 3;
                            continue block7;
                        }
                        case 253: {
                            double d = AppleUtil.getSaneNumber(byArray, n + n8);
                            printWriter.print(d);
                            n8 += 8;
                            continue block7;
                        }
                        case 254: {
                            byte by = byArray[n + n8];
                            int n10 = AppleUtil.getSignedWordValue(byArray, n + n8 + 1);
                            printWriter.print(this.getColumnReference(n4 + by));
                            printWriter.print(this.getRowReference(n3 + n10));
                            n8 += 3;
                            continue block7;
                        }
                        case 255: {
                            String string = AppleUtil.getPascalString(byArray, n + n8);
                            printWriter.print(string);
                            n8 += string.length() + 1;
                            continue block7;
                        }
                    }
                    printWriter.print(formulaText[n9 - 192]);
                }
                printWriter.print('\"');
            } else if ((n6 & 0xA0) == 32) {
                char c = (char)AppleUtil.getUnsignedByte(byArray[n + 1]);
                printWriter.print('\"');
                for (int i = 0; i < 8; ++i) {
                    printWriter.print(c);
                }
                printWriter.print('\"');
            } else if ((n6 & 0xE0) == 0) {
                String string = AppleUtil.getString(byArray, n + 1, n2 - 1);
                printWriter.print('\"');
                printWriter.print(string);
                printWriter.print('\"');
            } else {
                printWriter.print("\"Unknown Cell Contents!\"");
            }
        }
    }

    protected String getColumnReference(int n) {
        int n2 = n / 26;
        int n3 = n % 26;
        StringBuffer stringBuffer = new StringBuffer();
        if (n2 > 0) {
            stringBuffer.append((char)(64 + n2));
        }
        stringBuffer.append((char)(64 + n3));
        return stringBuffer.toString();
    }

    protected String getRowReference(int n) {
        NumberFormat numberFormat = NumberFormat.getInstance();
        return numberFormat.format(n);
    }
}

