/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.ui.swt.wizard.importfile;

import com.webcodepro.applecommander.ui.ImportSpecification;
import com.webcodepro.applecommander.ui.UiBundle;
import com.webcodepro.applecommander.ui.UserPreferences;
import com.webcodepro.applecommander.ui.swt.util.SwtUtil;
import com.webcodepro.applecommander.ui.swt.wizard.WizardPane;
import com.webcodepro.applecommander.ui.swt.wizard.importfile.ImportWizard;
import com.webcodepro.applecommander.util.AppleUtil;
import com.webcodepro.applecommander.util.TextBundle;
import java.io.File;
import java.util.Iterator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class ImportSelectFilesWizardPane
extends WizardPane {
    private TextBundle textBundle = UiBundle.getInstance();
    private ImportWizard wizard;
    private Composite control;
    private Composite parent;
    private Button removeButton;
    private Button editButton;
    private Table fileTable;
    private Text addressText;
    private Button rawCheckbox;

    public ImportSelectFilesWizardPane(Composite composite, ImportWizard importWizard) {
        this.parent = composite;
        this.wizard = importWizard;
    }

    public WizardPane getNextPane() {
        return null;
    }

    public void open() {
        this.control = new Composite(this.parent, 0);
        this.wizard.enableNextButton(false);
        this.wizard.enableFinishButton(false);
        RowLayout rowLayout = new RowLayout(512);
        rowLayout.justify = true;
        rowLayout.marginBottom = 5;
        rowLayout.marginLeft = 5;
        rowLayout.marginRight = 5;
        rowLayout.marginTop = 5;
        rowLayout.spacing = 3;
        this.control.setLayout((Layout)rowLayout);
        Label label = new Label(this.control, 64);
        label.setText(this.textBundle.get("ImportWizardPrompt"));
        this.fileTable = new Table(this.control, 68356);
        this.fileTable.setLayoutData((Object)new RowData(330, 100));
        this.fileTable.setHeaderVisible(true);
        this.fileTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ImportSelectFilesWizardPane.this.getRemoveButton().setEnabled(true);
                ImportSelectFilesWizardPane.this.getEditButton().setEnabled(true);
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                ImportSelectFilesWizardPane.this.editSelection();
            }
        });
        TableColumn tableColumn = new TableColumn(this.fileTable, 16384);
        tableColumn.setText(this.textBundle.get("SourceColumnHeader"));
        tableColumn.setWidth(130);
        tableColumn = new TableColumn(this.fileTable, 16384);
        tableColumn.setText(this.textBundle.get("TargetColumnHeader"));
        tableColumn.setWidth(130);
        tableColumn = new TableColumn(this.fileTable, 16384);
        tableColumn.setText(this.textBundle.get("TypeColumnHeader"));
        tableColumn.setWidth(70);
        Composite composite = new Composite(this.control, 0);
        composite.setLayout((Layout)new FillLayout());
        Button button = new Button(composite, 8);
        button.setText(this.textBundle.get("ChooseButton"));
        button.setFocus();
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FileDialog fileDialog = new FileDialog(ImportSelectFilesWizardPane.this.getParent().getShell(), 4098);
                fileDialog.setFilterPath(UserPreferences.getInstance().getImportDirectory());
                String string = fileDialog.open();
                if (string != null) {
                    ImportSelectFilesWizardPane.this.setFilenames(fileDialog.getFilterPath(), fileDialog.getFileNames());
                    UserPreferences.getInstance().setImportDirectory(fileDialog.getFilterPath());
                }
            }
        });
        this.removeButton = new Button(composite, 8);
        this.removeButton.setText(this.textBundle.get("RemoveButton"));
        this.removeButton.setEnabled(false);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TableItem[] tableItemArray = ImportSelectFilesWizardPane.this.getFileTable().getSelection();
                for (int i = 0; i < tableItemArray.length; ++i) {
                    ImportSpecification importSpecification = (ImportSpecification)tableItemArray[i].getData();
                    ImportSelectFilesWizardPane.this.getWizard().removeImportSpecification(importSpecification);
                }
                ImportSelectFilesWizardPane.this.getRemoveButton().setEnabled(false);
                ImportSelectFilesWizardPane.this.refreshTable();
            }
        });
        this.editButton = new Button(composite, 8);
        this.editButton.setText(this.textBundle.get("EditButton"));
        this.editButton.setEnabled(false);
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ImportSelectFilesWizardPane.this.editSelection();
            }
        });
    }

    protected void setFilenames(String string, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            ImportSpecification importSpecification = new ImportSpecification(string + File.separatorChar + stringArray[i], this.wizard.getDisk().getSuggestedFilename(stringArray[i]), this.wizard.getDisk().getSuggestedFiletype(stringArray[i]));
            this.wizard.addImportSpecification(importSpecification);
        }
        this.refreshTable();
    }

    protected void refreshTable() {
        this.fileTable.removeAll();
        Iterator iterator = this.wizard.getImportSpecifications().iterator();
        boolean bl = iterator.hasNext();
        while (iterator.hasNext()) {
            ImportSpecification importSpecification = (ImportSpecification)iterator.next();
            File file = new File(importSpecification.getSourceFilename());
            TableItem tableItem = new TableItem(this.fileTable, 0);
            tableItem.setText(new String[]{file.getName(), importSpecification.getTargetFilename(), importSpecification.getFiletype()});
            tableItem.setData((Object)importSpecification);
            bl &= importSpecification.hasFiletype();
        }
        this.fileTable.redraw();
        this.wizard.enableFinishButton(bl);
    }

    public void dispose() {
        this.fileTable.dispose();
        this.control.dispose();
    }

    public void editSelection() {
        final ImportSpecification importSpecification = (ImportSpecification)this.fileTable.getSelection()[0].getData();
        final Shell shell = new Shell(this.wizard.getDialog(), 67680);
        shell.setText(this.textBundle.get("FileImportSettingsTitle"));
        GridLayout gridLayout = new GridLayout();
        gridLayout.horizontalSpacing = 5;
        gridLayout.makeColumnsEqualWidth = false;
        gridLayout.marginHeight = 5;
        gridLayout.marginWidth = 5;
        gridLayout.numColumns = 2;
        gridLayout.verticalSpacing = 5;
        shell.setLayout((Layout)gridLayout);
        Label label = new Label((Composite)shell, 0);
        label.setText(this.textBundle.get("FilenameLabel"));
        final Text text = new Text((Composite)shell, 2048);
        text.setText(importSpecification.getTargetFilename());
        text.setTextLimit(30);
        GridData gridData = new GridData();
        gridData.widthHint = 150;
        text.setLayoutData((Object)gridData);
        label = new Label((Composite)shell, 0);
        label.setText(this.textBundle.get("FiletypeLabel"));
        final Combo combo = new Combo((Composite)shell, 2056);
        combo.setItems(this.wizard.getDisk().getFiletypes());
        if (importSpecification.hasFiletype()) {
            combo.select(combo.indexOf(importSpecification.getFiletype()));
        }
        label = new Label((Composite)shell, 0);
        label.setText(this.textBundle.get("AddressLabel"));
        this.addressText = new Text((Composite)shell, 2048);
        this.addressText.setTextLimit(5);
        this.addressText.setText(AppleUtil.getFormattedWord(importSpecification.getAddress()));
        gridData = new GridData();
        gridData.widthHint = 75;
        this.addressText.setLayoutData((Object)gridData);
        if (importSpecification.hasFiletype()) {
            this.addressText.setEnabled(this.wizard.getDisk().needsAddress(importSpecification.getFiletype()));
        }
        label = new Label((Composite)shell, 0);
        label.setText(this.textBundle.get("RawBinaryCheckbox"));
        this.rawCheckbox = new Button((Composite)shell, 32);
        this.rawCheckbox.setSelection(importSpecification.isRawFileImport());
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                String string = combo.getItem(combo.getSelectionIndex());
                ImportSelectFilesWizardPane.this.getAddressText().setEnabled(ImportSelectFilesWizardPane.this.getWizard().getDisk().needsAddress(string));
            }
        });
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 2;
        Composite composite = new Composite((Composite)shell, 0);
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new FillLayout(256));
        Button button = new Button(composite, 8);
        button.setText(this.textBundle.get("CancelButton"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                text.dispose();
                combo.dispose();
                ImportSelectFilesWizardPane.this.getAddressText().dispose();
                ImportSelectFilesWizardPane.this.getRawCheckBox().dispose();
                shell.close();
            }
        });
        button = new Button(composite, 8);
        button.setText(this.textBundle.get("OkButton"));
        shell.setDefaultButton(button);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                importSpecification.setTargetFilename(ImportSelectFilesWizardPane.this.getWizard().getDisk().getSuggestedFilename(text.getText()));
                importSpecification.setFiletype(combo.getItem(combo.getSelectionIndex()));
                importSpecification.setAddress(AppleUtil.convertFormattedWord(ImportSelectFilesWizardPane.this.getAddressText().getText()));
                importSpecification.setRawFileImport(ImportSelectFilesWizardPane.this.getRawCheckBox().getSelection());
                text.dispose();
                combo.dispose();
                ImportSelectFilesWizardPane.this.getAddressText().dispose();
                ImportSelectFilesWizardPane.this.getRawCheckBox().dispose();
                shell.close();
                ImportSelectFilesWizardPane.this.refreshTable();
            }
        });
        shell.pack();
        SwtUtil.center(this.wizard.getDialog(), shell);
        shell.open();
    }

    protected Button getRemoveButton() {
        return this.removeButton;
    }

    protected Button getEditButton() {
        return this.editButton;
    }

    protected Composite getParent() {
        return this.parent;
    }

    protected Table getFileTable() {
        return this.fileTable;
    }

    protected ImportWizard getWizard() {
        return this.wizard;
    }

    protected Text getAddressText() {
        return this.addressText;
    }

    protected Button getRawCheckBox() {
        return this.rawCheckbox;
    }
}

